/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui.profile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.sintinium.oauth.gui.ErrorScreen;
import com.sintinium.oauth.gui.LoginLoadingScreen;
import com.sintinium.oauth.gui.LoginScreen;
import com.sintinium.oauth.gui.MultiplayerDisabledScreen;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.gui.profile.FakePlayer;
import com.sintinium.oauth.gui.profile.ProfileEntry;
import com.sintinium.oauth.gui.profile.ProfileList;
import com.sintinium.oauth.login.LoginUtil;
import com.sintinium.oauth.login.MicrosoftLogin;
import com.sintinium.oauth.profile.MicrosoftProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import com.sintinium.oauth.profile.ProfileManager;
import com.sintinium.oauth.util.PlayerRenderers;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.apache.logging.log4j.LogManager;

public class ProfileSelectionScreen
extends OAuthScreen {
    private ProfileList profileList;
    private Button removeAccountButton;
    private Button loginButton;
    private Button loginOfflineButton;
    private ProfileEntry initialEntry;

    public ProfileSelectionScreen() {
        super((Component)new TextComponent("Profiles"));
    }

    public ProfileSelectionScreen(ProfileEntry initialEntry) {
        this();
        this.initialEntry = initialEntry;
    }

    private static void onMojangType() {
        ProfileSelectionScreen.setScreen(new LoginScreen());
    }

    public void onLoginButton() {
        this.onLoginButton((ProfileEntry)this.profileList.m_93511_());
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        ProfileEntry selected = (ProfileEntry)this.profileList.m_93511_();
        super.m_6574_(p_96575_, p_96576_, p_96577_);
        if (selected != null) {
            this.profileList.m_6702_().stream().filter(entry -> entry.getProfile().getUUID().equals(selected.getProfile().getUUID())).findFirst().ifPresent(profile -> this.profileList.setSelected((ProfileEntry)((Object)profile)));
        }
    }

    protected void m_7856_() {
        this.profileList = new ProfileList(this, Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 52, 16);
        this.profileList.loadProfiles();
        FakePlayer.getInstance().clearCache();
        if (LoginUtil.isOnline()) {
            GameProfile profile = ProfileManager.getInstance().getGameProfileOrNull(Minecraft.m_91087_().m_91094_().m_92548_().getId());
            if (profile == null) {
                profile = Minecraft.m_91087_().m_91094_().m_92548_();
            }
            FakePlayer.getInstance().setSkin(profile);
            FakePlayer.getInstance().setSkin(profile);
        } else if (this.profileList.m_93511_() != null) {
            ProfileEntry entry = (ProfileEntry)this.profileList.m_93511_();
            FakePlayer.getInstance().setSkin(entry.getProfile().getGameProfile());
            FakePlayer.getInstance().setSkin(entry.getProfile().getGameProfile());
        } else {
            FakePlayer.getInstance().setSkin(null);
        }
        this.addButton(this.f_96543_ / 2 - 45 - 90 - 2, this.f_96544_ - 2 - 20, 90, "Add Account", p_onPress_1_ -> this.onMicrosoftType(null));
        this.removeAccountButton = this.addButton(this.f_96543_ / 2 - 45, this.f_96544_ - 2 - 20, 90, "Remove Account", p_onPress_1_ -> {
            if (this.profileList.m_93511_() != null) {
                ProfileManager.getInstance().removeProfile(((ProfileEntry)this.profileList.m_93511_()).getProfile().getUUID());
                int index = this.profileList.m_6702_().indexOf(this.profileList.m_93511_());
                this.profileList.m_6702_().remove(this.profileList.m_93511_());
                if (this.profileList.m_6702_().isEmpty()) {
                    this.profileList.setSelected(null);
                } else if (index < this.profileList.m_6702_().size()) {
                    this.profileList.setSelected((ProfileEntry)((Object)((Object)this.profileList.m_6702_().get(index))));
                } else if (index - 1 < this.profileList.m_6702_().size() && index - 1 >= 0) {
                    this.profileList.setSelected((ProfileEntry)((Object)((Object)this.profileList.m_6702_().get(index - 1))));
                }
            }
        });
        this.removeAccountButton.f_93623_ = false;
        this.addButton(this.f_96543_ / 2 + 45 + 2, this.f_96544_ - 2 - 20, 90, "Back", p_onPress_1_ -> ProfileSelectionScreen.setScreen((Screen)new TitleScreen()));
        this.loginButton = this.addButton(this.f_96543_ / 2 - 137, this.f_96544_ - 4 - 40, 137, "Login", p_onPress_1_ -> this.onLoginButton());
        this.loginOfflineButton = this.addButton(this.f_96543_ / 2 + 1, this.f_96544_ - 4 - 40, 137, "Login Offline", p_onPress_1_ -> {
            if (this.profileList.m_93511_() != null) {
                try {
                    LoginUtil.loginOffline(((ProfileEntry)this.profileList.m_93511_()).getProfile().getName());
                    ProfileSelectionScreen.setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
                }
                catch (LoginUtil.WrongMinecraftVersionException e) {
                    ProfileSelectionScreen.setScreen(new ErrorScreen(((ProfileEntry)this.profileList.m_93511_()).getProfile() instanceof MicrosoftProfile, e));
                    e.printStackTrace();
                }
            }
        });
        this.loginButton.f_93623_ = false;
        this.loginOfflineButton.f_93623_ = false;
        this.m_7787_((GuiEventListener)this.profileList);
        if (this.initialEntry != null) {
            if (this.profileList.m_6702_().contains((Object)this.initialEntry)) {
                this.profileList.setSelected(this.initialEntry);
            }
            this.initialEntry = null;
        }
    }

    public void onLoginButton(ProfileEntry selected) {
        if (selected == null || selected.getProfile() == null) {
            return;
        }
        if (selected.getProfile() instanceof OfflineProfile) {
            try {
                selected.getProfile().login();
                Minecraft.m_91087_().m_91152_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, e));
                e.printStackTrace();
                return;
            }
        }
        Thread thread = new Thread(() -> {
            try {
                AtomicBoolean isCancelled = new AtomicBoolean();
                LoginLoadingScreen loginLoadingScreen = new LoginLoadingScreen(() -> {
                    ProfileSelectionScreen.setScreen(new ProfileSelectionScreen(selected));
                    isCancelled.set(true);
                }, selected.getProfile() instanceof MicrosoftProfile);
                if (selected.getProfile() instanceof MicrosoftProfile) {
                    loginLoadingScreen.updateText("Logging into Microsoft.");
                } else {
                    loginLoadingScreen.updateText("Logging into Minecraft.");
                }
                ProfileSelectionScreen.setScreen(loginLoadingScreen);
                boolean isSuccessful = selected.getProfile().login();
                if (isCancelled.get()) {
                    return;
                }
                if (!isSuccessful && selected.getProfile() instanceof MicrosoftProfile) {
                    if (LoginUtil.isMultiplayerDisabled()) {
                        ProfileSelectionScreen.setScreen(new MultiplayerDisabledScreen());
                        return;
                    }
                    this.onMicrosoftType(selected);
                    return;
                }
                if (!isSuccessful && Minecraft.m_91087_().f_91080_ instanceof ProfileSelectionScreen) {
                    ProfileSelectionScreen.setScreen(new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, "Login Failed"));
                    return;
                }
                try {
                    ProfileManager.getInstance().getProfile(selected.getProfile().getUUID()).setName(Minecraft.m_91087_().m_91094_().m_92546_());
                    ProfileManager.getInstance().save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ProfileSelectionScreen.setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
            }
            catch (UserMigratedException e) {
                ErrorScreen errorScreen = new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, "This account has migrated to Microsoft. Please create a new profile with your Microsoft account.");
                ProfileSelectionScreen.setScreen(errorScreen);
                e.printStackTrace();
            }
            catch (InvalidCredentialsException e) {
                if (e.getMessage() == null || e.getMessage().equals(e.getCause().toString())) {
                    ErrorScreen errorScreen = new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, e);
                    ProfileSelectionScreen.setScreen(errorScreen);
                } else {
                    ErrorScreen errorScreen = new ErrorScreen(((ProfileEntry)this.profileList.m_93511_()).getProfile() instanceof MicrosoftProfile, e.getMessage() + ". Please delete the profile and create a new one.");
                    errorScreen.setInfo();
                    ProfileSelectionScreen.setScreen(errorScreen);
                }
                e.printStackTrace();
            }
            catch (MicrosoftLogin.BaseMicrosoftLoginException e) {
                ProfileSelectionScreen.setScreen(ErrorScreen.microsoftExceptionScreen(e));
                e.printStackTrace();
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(((ProfileEntry)this.profileList.m_93511_()).getProfile() instanceof MicrosoftProfile, e));
                e.printStackTrace();
            }
        }, "LoginThread");
        thread.setDaemon(true);
        thread.start();
    }

    private void onMicrosoftType(@Nullable ProfileEntry entry) {
        MicrosoftLogin login = new MicrosoftLogin();
        LoginLoadingScreen loadingScreen = new LoginLoadingScreen(login::cancelLogin, true);
        login.setUpdateStatusConsumer(loadingScreen::updateText);
        Thread thread = new Thread(() -> {
            MicrosoftProfile profile;
            try {
                profile = login.login();
            }
            catch (MicrosoftLogin.BaseMicrosoftLoginException e) {
                ProfileSelectionScreen.setScreen(ErrorScreen.microsoftExceptionScreen(e));
                e.printStackTrace();
                LogManager.getLogger().error(login.getErroredResponses());
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(true, e));
                e.printStackTrace();
                LogManager.getLogger().error(login.getErroredResponses());
                return;
            }
            if (profile != null) {
                ProfileManager.getInstance().addProfile(profile);
                ProfileEntry newProfile = new ProfileEntry(this.profileList, profile);
                this.onLoginButton(newProfile);
            }
        }, "Oauth microsoft");
        ProfileSelectionScreen.setScreen(loadingScreen);
        thread.setDaemon(true);
        thread.start();
    }

    private Button addButton(int x, int y, int width, String text, Button.OnPress onPress) {
        return (Button)this.m_142416_((GuiEventListener)new Button(x, y, width, 20, (Component)new TextComponent(text), onPress));
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return super.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        if (this.profileList.m_93511_() == null) {
            this.removeAccountButton.f_93623_ = false;
            this.loginButton.f_93623_ = false;
            this.loginOfflineButton.f_93623_ = false;
            return;
        }
        this.removeAccountButton.f_93623_ = true;
        this.loginButton.f_93623_ = true;
        this.loginOfflineButton.f_93623_ = true;
        if (((ProfileEntry)this.profileList.m_93511_()).isOffline()) {
            this.loginButton.f_93623_ = false;
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        int size = 60;
        int x = 40;
        int y = this.f_96544_ / 2 + size;
        this.profileList.m_6305_(stack, mouseX, mouseY, delta);
        this.renderPlayer(RenderSystem.m_157191_(), mouseX, mouseY, delta);
        Minecraft.m_91087_().f_91062_.m_92750_(stack, "Status: " + (LoginUtil.isOnline() ? "Online" : "Offline"), 12.0f, 12.0f, LoginUtil.isOnline() ? 0x55FF55 : 0xFF5555);
        ProfileSelectionScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)("Current Profile: " + Minecraft.m_91087_().m_91094_().m_92546_()), (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        super.m_6305_(stack, mouseX, mouseY, delta);
    }

    private void renderPlayer(PoseStack stack, int mouseX, int mouseY, float delta) {
        int size = 60;
        int x = 40;
        int y = this.f_96544_ / 2 + size;
        float rotX = -mouseX + x;
        float rotY = (float)(-mouseY + y - size * 2) + (float)size / 2.0f;
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 1050.0);
        stack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        FakePlayer fakePlayer = FakePlayer.getInstance();
        float f = (float)Math.atan(rotX / 40.0f);
        float f1 = (float)Math.atan(rotY / 40.0f);
        fakePlayer.f_20883_ = 180.0f + f * 20.0f;
        fakePlayer.m_146922_(180.0f + f * 40.0f);
        fakePlayer.m_146926_(-f1 * 20.0f);
        fakePlayer.f_20885_ = fakePlayer.m_146908_();
        fakePlayer.f_20886_ = fakePlayer.m_146908_();
        PoseStack playerStack = new PoseStack();
        playerStack.m_85837_(0.0, 0.0, 1000.0);
        playerStack.m_85841_((float)size, (float)size, (float)size);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_((float)Math.atan(rotX / 40.0f));
        quaternion.m_80148_(quaternion1);
        playerStack.m_85845_(quaternion);
        playerStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        Lighting.m_166384_();
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> this.renderEntity(playerStack, (MultiBufferSource)multiBufferSource));
        multiBufferSource.m_109911_();
        stack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private void renderEntity(PoseStack stack, MultiBufferSource multiBufferSource) {
        this.renderModel(stack, multiBufferSource);
    }

    private void renderModel(PoseStack stack, MultiBufferSource multiBufferSource) {
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - Mth.m_14179_((float)1.0f, (float)FakePlayer.getInstance().f_20884_, (float)FakePlayer.getInstance().f_20883_)));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, -1.501, 0.0);
        boolean slim = false;
        PlayerModel<AbstractClientPlayer> model = FakePlayer.getInstance().m_108564_().equals("slim") ? PlayerRenderers.slimPlayerModel : PlayerRenderers.playerModel;
        model.m_6839_((LivingEntity)FakePlayer.getInstance(), 0.0f, 0.0f, 1.0f);
        float rotation = Mth.m_14189_((float)1.0f, (float)FakePlayer.getInstance().f_20886_, (float)FakePlayer.getInstance().f_20885_) - Mth.m_14179_((float)1.0f, (float)FakePlayer.getInstance().f_20884_, (float)FakePlayer.getInstance().f_20883_);
        model.m_6973_((LivingEntity)FakePlayer.getInstance(), 0.0f, 0.0f, 0.0f, rotation, Mth.m_14179_((float)1.0f, (float)FakePlayer.getInstance().f_19860_, (float)FakePlayer.getInstance().m_146909_()));
        RenderType renderType = model.m_103119_(FakePlayer.getInstance().m_108560_());
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
        int overlayCoords = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false));
        model.m_8009_(true);
        model.f_102610_ = false;
        model.m_7695_(stack, vertexConsumer, 0xF000F0, overlayCoords, 1.0f, 1.0f, 1.0f, 1.0f);
        FakePlayer fakePlayer = FakePlayer.getInstance();
        if (fakePlayer.m_108555_() && fakePlayer.m_36170_(PlayerModelPart.CAPE) && fakePlayer.m_108561_() != null) {
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, 0.225);
            stack.m_85845_(Vector3f.f_122226_.m_122240_(5.0f));
            stack.m_85845_(Vector3f.f_122223_.m_122240_(5.0f));
            VertexConsumer vertexConsumer1 = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)fakePlayer.m_108561_()));
            model.m_103411_(stack, vertexConsumer1, 0xF000F0, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
        stack.m_85849_();
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
    }
}

