/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui.profile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.sintinium.oauth.gui.profile.FakeClientPlayNetHandler;
import com.sintinium.oauth.gui.profile.FakeWorld;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class FakePlayer
extends LocalPlayer {
    private static FakePlayer instance;
    private ResourceLocation skin;
    private ResourceLocation cape = null;
    private String skinModel = "default";
    private final Map<UUID, PlayerData> cache = new ConcurrentHashMap<UUID, PlayerData>();

    public FakePlayer() {
        super(Minecraft.m_91087_(), (ClientLevel)FakeWorld.getInstance(), (ClientPacketListener)FakeClientPlayNetHandler.getInstance(), null, null, false, false);
        Minecraft.m_91087_().m_91109_().m_118817_(this.m_36316_(), (type, resourceLocation, minecraftProfileTexture) -> {
            this.skin = resourceLocation;
        }, true);
    }

    public static FakePlayer getInstance() {
        if (instance == null) {
            instance = new FakePlayer();
        }
        return instance;
    }

    public void setSkin(GameProfile profile) {
        try {
            if (profile == null) {
                this.skin = DefaultPlayerSkin.m_118626_();
                this.cape = null;
                this.skinModel = "default";
                return;
            }
            PlayerData data = new PlayerData();
            this.cape = null;
            Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, resourceLocation, minecraftProfileTexture) -> {
                if (type == MinecraftProfileTexture.Type.SKIN) {
                    this.skin = resourceLocation;
                    this.skinModel = minecraftProfileTexture.getMetadata("model");
                    if (this.skinModel == null) {
                        this.skinModel = "default";
                    }
                    data.skin = this.skin;
                    data.skinModel = this.skinModel;
                    this.cache.put(profile.getId(), data);
                }
                if (type == MinecraftProfileTexture.Type.CAPE) {
                    data.cape = this.cape = resourceLocation;
                }
            }, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_36170_(PlayerModelPart p_175148_1_) {
        return true;
    }

    public ResourceLocation m_108560_() {
        if (this.skin == null) {
            return DefaultPlayerSkin.m_118626_();
        }
        return this.skin;
    }

    public String m_108564_() {
        return this.skinModel;
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_7500_() {
        return true;
    }

    public boolean m_108555_() {
        return true;
    }

    @Nullable
    public ResourceLocation m_108561_() {
        return this.cape;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public float m_20270_(Entity pEntity) {
        return Float.MAX_VALUE;
    }

    public double m_20280_(Entity pEntity) {
        return 3.4028234663852886E38;
    }

    private static class PlayerData {
        private ResourceLocation skin;
        private ResourceLocation cape;
        private String skinModel;

        private PlayerData() {
        }
    }
}

