/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockBedrockFlower;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.util.Utils;

public class ClientHandler {
    public static void setup() {
        GTAPI.all(BlockCasing.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        GTAPI.all(BlockColoredWall.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        GTAPI.all(BlockBedrockFlower.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        ModelUtils.setRenderLayer((Block)GT5RMachines.NUCLEAR_REACTOR_CORE.getBlockState(Tier.NONE), (RenderType)RenderType.m_110463_());
        ClientHandler.copyProgrammerArtIfMissing();
    }

    private static void copyProgrammerArtIfMissing() {
        ClientHandler.writeResourcePack("Classic-GT5-Machine-Textures", "classic-gt5-machine-textures");
        ClientHandler.writeResourcePack("Old-GTI-Machine-Textures", "old-gti-machine-textures");
    }

    private static void writeResourcePack(String writeName, String readName) {
        File dir = new File(FMLPaths.CONFIGDIR.get().getParent().toFile(), "resourcepacks");
        File target = new File(dir, writeName + ".zip");
        try {
            dir.mkdirs();
            InputStream in = GT5Reimagined.class.getResourceAsStream("/assets/gt5r/" + readName + ".zip");
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[16384];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void onTooltipEvent(ItemTooltipEvent event) {
        String material;
        Material mat;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == GT5RItems.DataOrb && stack.m_41783_() != null && stack.m_41783_().m_128441_("scanned_gt_material") && (mat = Material.get((String)(material = stack.m_41783_().m_128461_("scanned_gt_material")))) != Material.NULL && mat.getElement() != null) {
            event.getToolTip().add(1, Utils.translatable((String)"tooltip.gt5r.data_orb.elemental_scan", (Object[])new Object[0]));
            event.getToolTip().add(2, Utils.literal((String)mat.getChemicalFormula()));
        }
    }
}

