/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.material;

import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.event.MaterialEvent;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.data.ToolData;

public class GT5RMaterialEvent
extends MaterialEvent<GT5RMaterialEvent> {
    public GT5RMaterialEvent asSolid(int meltingPoint, int blastFurnaceTemp, IMaterialTag ... tags) {
        super.asSolid(meltingPoint, tags);
        GT5RMaterialTags.BLAST_FURNACE_TEMP.add(this.material, (Object)blastFurnaceTemp);
        if (blastFurnaceTemp >= 2000) {
            this.flags(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE, MaterialTags.HAS_CUSTOM_SMELTING});
        }
        if (blastFurnaceTemp > 2400) {
            this.flags(new IMaterialTag[]{GTMaterialTypes.HOT_INGOT});
        }
        return this;
    }

    public GT5RMaterialEvent asMetal(int meltingPoint, int blastFurnaceTemp, IMaterialTag ... tags) {
        this.flags(new IMaterialTag[]{MaterialTags.METAL, MaterialTags.MOLTEN});
        this.asSolid(meltingPoint, blastFurnaceTemp, tags);
        return this;
    }

    public GT5RMaterialEvent forceBF(boolean hotIngot) {
        this.flags(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE, MaterialTags.HAS_CUSTOM_SMELTING});
        if (hotIngot) {
            this.flags(new IMaterialTag[]{GTMaterialTypes.HOT_INGOT});
        }
        return this;
    }

    public GT5RMaterialEvent asSolid(int meltingPoint, IMaterialTag ... tags) {
        return this.asSolid(meltingPoint, meltingPoint, tags);
    }

    public GT5RMaterialEvent asMetal(int meltingPoint, IMaterialTag ... tags) {
        return this.asMetal(meltingPoint, meltingPoint, tags);
    }

    public GT5RMaterialEvent elecTicks(int ticks) {
        GT5RMaterialTags.ELEC_TICKS.add(this.material, (Object)ticks);
        return this;
    }

    protected GT5RMaterialEvent buildTool(ToolData builder) {
        this.flags(new IMaterialTag[]{GTMaterialTypes.LONG_ROD});
        return (GT5RMaterialEvent)super.buildTool(builder);
    }

    public GT5RMaterialEvent thermal(Material byProduct) {
        GT5RMaterialTags.THERMAL_CENTRIFUGE_EXPLICIT.add(this.material, (Object)byProduct);
        return this;
    }

    public GT5RMaterialEvent bathMercury(Material byProduct) {
        GT5RMaterialTags.BATH_MERCURY.add(this.material, (Object)byProduct);
        return this;
    }

    public GT5RMaterialEvent bathPersulfate(Material byProduct) {
        GT5RMaterialTags.BATH_PERSULFATE.add(this.material, (Object)byProduct);
        return this;
    }
}

