/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.util.Utils;

public class ParallelRecipeHandler<T extends BlockEntityMachine<T>>
extends MachineRecipeHandler<T> {
    public int concurrentRecipes = 0;
    final int maxSimultaneousRecipes;

    public ParallelRecipeHandler(T tile, int maxSimultaneousRecipes) {
        super(tile);
        this.maxSimultaneousRecipes = maxSimultaneousRecipes;
    }

    public boolean consumeInputs() {
        boolean simulate;
        boolean consumeInput;
        this.concurrentRecipes = 0;
        for (int i = 0; i < this.maxSimultaneousRecipes() && (consumeInput = this.consumeSingleInput(simulate = i != 0)); ++i) {
            if (simulate) {
                this.consumeSingleInput(false);
            }
            ++this.concurrentRecipes;
        }
        return this.concurrentRecipes > 0;
    }

    protected boolean consumeSingleInput(boolean simulate) {
        boolean flag = true;
        if (!this.tile.hadFirstTick()) {
            return true;
        }
        List[] itemInputs = new List[]{new ArrayList()};
        List[] fluidInputs = new List[]{new ArrayList()};
        if (this.activeRecipe.hasInputItems()) {
            flag &= this.tile.itemHandler.map(h -> {
                itemInputs[0] = h.consumeInputs(this.activeRecipe, simulate);
                return !itemInputs[0].isEmpty();
            }).orElse(true).booleanValue();
        }
        if (this.activeRecipe.hasInputFluids()) {
            flag &= this.tile.fluidHandler.map(h -> {
                fluidInputs[0] = h.consumeAndReturnInputs(this.activeRecipe.getInputFluids(), simulate);
                return !fluidInputs[0].isEmpty();
            }).orElse(true).booleanValue();
        }
        if (!simulate) {
            if (flag) {
                this.consumedResources = true;
            }
            this.itemInputs = itemInputs[0];
            this.fluidInputs = fluidInputs[0];
        }
        return flag;
    }

    protected void addOutputs() {
        for (int i = 0; i < this.concurrentRecipes; ++i) {
            if (this.activeRecipe.hasOutputItems()) {
                this.addSingleItemOutput();
            }
            if (!this.activeRecipe.hasOutputFluids()) continue;
            this.addSingleFluidOutput();
        }
        if (this.activeRecipe.hasOutputItems()) {
            this.tile.onMachineEvent((IMachineEvent)MachineEvent.ITEMS_OUTPUTTED, new Object[0]);
        }
        if (this.activeRecipe.hasOutputFluids()) {
            this.tile.onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
        }
        this.concurrentRecipes = 0;
    }

    protected boolean addSingleFluidOutput() {
        AtomicBoolean successful = new AtomicBoolean(false);
        this.tile.fluidHandler.ifPresent(h -> {
            if (h.canOutputsFit(this.activeRecipe.getOutputFluids())) {
                h.addOutputs(this.activeRecipe.getOutputFluids());
                successful.set(true);
            }
        });
        return successful.get();
    }

    protected boolean addSingleItemOutput() {
        AtomicBoolean successful = new AtomicBoolean(false);
        this.tile.itemHandler.ifPresent(h -> {
            ItemStack[] out = this.activeRecipe.getOutputItems(true);
            if (h.canOutputsFit(out)) {
                h.addOutputs(out);
                successful.set(true);
            }
        });
        return successful.get();
    }

    protected void addPartialOutputs() {
        int successfulRecipes = 0;
        for (int i = 0; i < this.concurrentRecipes; ++i) {
            boolean successful = false;
            if (this.activeRecipe.hasOutputItems() && this.addSingleItemOutput()) {
                successful = true;
            }
            if (this.activeRecipe.hasOutputFluids() && this.addSingleFluidOutput()) {
                successful = true;
            }
            if (!successful) continue;
            ++successfulRecipes;
        }
        this.concurrentRecipes -= successfulRecipes;
        if (this.activeRecipe.hasOutputItems()) {
            this.tile.onMachineEvent((IMachineEvent)MachineEvent.ITEMS_OUTPUTTED, new Object[0]);
        }
        if (this.activeRecipe.hasOutputFluids()) {
            this.tile.onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
        }
    }

    protected void logString(String message) {
        GTLib.LOGGER.info(message);
    }

    public void onServerUpdate() {
        if (this.tile.getMachineState() == MachineState.OUTPUT_FULL && !this.canOutput() && super.canOutput()) {
            this.addPartialOutputs();
            return;
        }
        if (this.activeRecipe == null && this.concurrentRecipes > 0) {
            this.concurrentRecipes = 0;
        }
        super.onServerUpdate();
    }

    public boolean canOutput() {
        if (this.concurrentRecipes <= 1) {
            return super.canOutput();
        }
        if (this.tile.itemHandler.isPresent() && this.activeRecipe.hasOutputItems() && !this.tile.itemHandler.map(t -> {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < this.concurrentRecipes; ++i) {
                for (ItemStack item : this.activeRecipe.getOutputItems(false)) {
                    outputs.add(item.m_41777_());
                }
            }
            List merged = Utils.mergeItems(new ArrayList(), outputs);
            return t.canOutputsFit((ItemStack[])merged.toArray(ItemStack[]::new));
        }).orElse(false).booleanValue()) {
            return false;
        }
        if (!this.tile.fluidHandler.isPresent() || !this.activeRecipe.hasOutputFluids()) {
            return true;
        }
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        for (int i = 0; i < this.concurrentRecipes; ++i) {
            for (FluidStack fluidHolder : this.activeRecipe.getOutputFluids()) {
                outputs.add(fluidHolder.copy());
            }
        }
        List merged = Utils.mergeFluids(new ArrayList(), outputs);
        return this.tile.fluidHandler.map(t -> t.canOutputsFit((FluidStack[])merged.toArray(FluidStack[]::new))).orElse(false);
    }

    protected int maxSimultaneousRecipes() {
        return this.maxSimultaneousRecipes;
    }

    public int getOverclock() {
        return 0;
    }

    public long getPower() {
        return super.getPower() * (long)Math.max(1, Math.min(this.maxSimultaneousRecipes, 4));
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("concurrentRecipes", this.concurrentRecipes);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.concurrentRecipes = nbt.m_128451_("concurrentRecipes");
    }

    public void getInfo(List<String> builder) {
        super.getInfo(builder);
        builder.add("Concurrent Recipes: " + this.concurrentRecipes);
        builder.add("Tick timer: " + this.tickTimer);
    }
}

