/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.multi;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.integration.SpaceModRegistrar;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.util.Utils;

public class BedrockDrillLoader {
    public static void init() {
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Adamantine, 105, Materials.Adamantium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Bastnasite, 63, Materials.Monazite, Materials.RareEarth, Materials.Neodymium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Bauxite, 53, Materials.Ilmenite, Materials.Hematite, Materials.Alumina);
        ItemStack cobble = new ItemStack((ItemLike)Items.f_42594_);
        cobble.m_41714_((Component)Utils.literal((String)"Various Cobblestone Types"));
        RecipeMaps.BEDROCK_DRILL.RB().ii(new ItemLike[]{Items.f_41829_}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(100)}).io(new ItemStack[]{cobble, GTMaterialTypes.DUST.get(Materials.Bedrock, 1)}).outputChances(new int[]{9990, 10});
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Cassiterite, 35, Materials.Molybdenite, Materials.Fluorite, Materials.Sperrylite, Materials.Apatite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Chalcopyrite, 40, Materials.Pyrite, Materials.Cobaltite, Materials.Cadmium, Materials.Gold, Materials.Sperrylite, Materials.Indium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Coal, 105, Materials.Lignite, Materials.Sulfur);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Sheldonite, 79, Materials.Palladium, Materials.Nickel, Materials.Iridium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Copper, 53, Materials.Cobaltite, Materials.Gold, Materials.Nickel, Materials.Malachite, Materials.Arsenic);
        if (SpaceModRegistrar.INSTANCE.isEnabled()) {
            BedrockDrillLoader.addBedrockDrillRecipe(SpaceModRegistrar.Desh, 35, Materials.Cobaltite, Materials.Monazite, Materials.LithiumChloride);
        }
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Diamond, 105, Materials.Graphite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Galena, 45, Materials.Sphalerite, Materials.Silver, Materials.Lead, Materials.Selenium, Materials.Fluorite, Materials.Calcite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Gold, 79, Materials.Copper, Materials.Nickel, Materials.Cinnabar);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Graphite, 157, Materials.Carbon);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Hematite, 63, Materials.Ilmenite, Materials.Pyrolusite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Monazite, 63, Materials.Thorium, Materials.Neodymium, Materials.RareEarth);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Naquadah, 105, new Material[0]);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Quartz, 63, Materials.Barite, Materials.Fluorite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Pentlandite, 53, Materials.Hematite, Materials.Sulfur, Materials.Cobaltite, Materials.Sperrylite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Pitchblende, 63, Materials.Lead, Materials.Radium, Materials.RareEarth, Materials.Thorium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Powellite, 105, Materials.Molybdenite, Materials.Scheelite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Redstone, 79, Materials.Cinnabar, Materials.RareEarth, Materials.Glowstone);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Scheelite, 79, Materials.Pyrolusite, Materials.Molybdenite, Materials.Calcite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Sphalerite, 45, Materials.Cadmium, Materials.Gallium, Materials.Zinc, Materials.Selenium, Materials.Indium);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Stibnite, 35, Materials.Antimony, Materials.Cinnabar, Materials.Galena, Materials.Pyrite, Materials.Barite, Materials.Calcite);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Tungstate, 79, Materials.Pyrolusite, Materials.Silver, Materials.LithiumChloride);
        BedrockDrillLoader.addBedrockDrillRecipe(Materials.Uraninite, 63, Materials.Lead, Materials.Radium, Materials.RareEarth, Materials.Thorium);
    }

    public static void addBedrockDrillRecipe(Material main, int byproductChance, Material ... byproduct) {
        RecipeBuilder rb = RecipeMaps.BEDROCK_DRILL.RB();
        ArrayList<Integer> chances = new ArrayList<Integer>();
        chances.add(9687);
        rb.ii(new Ingredient[]{RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.ORE.getMaterialTag(main, VanillaStoneTypes.BEDROCK), GTMaterialTypes.SMALL_ORE.getMaterialTag(main, VanillaStoneTypes.BEDROCK)})}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(100)}).io(new Item[]{GTMaterialTypes.RAW_ORE.get(main)});
        for (Material m : byproduct) {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RAW_ORE})) {
                rb.io(new Item[]{GTMaterialTypes.RAW_ORE.get(m)});
            } else {
                if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST})) continue;
                rb.io(new Item[]{GTMaterialTypes.DUST.get(m)});
            }
            chances.add(byproductChance);
        }
        rb.io(new Item[]{GTMaterialTypes.DUST.get(Materials.Bedrock)});
        chances.add(10);
        ItemStack cobble = new ItemStack((ItemLike)Items.f_42594_);
        cobble.m_41714_((Component)Utils.literal((String)"Various Cobblestone Types"));
        rb.io(new ItemStack[]{cobble});
        chances.add(10000);
        rb.outputChances(chances.stream().mapToInt(i -> i).toArray());
        rb.add("bedrock_" + main.getId() + "_ore", 1L, 32768L);
    }
}

