/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.FluidPipe;
import org.gtreimagined.gtlib.pipe.types.ItemPipe;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class RecyclingLoader {
    public static void initRecyclingRecipes() {
        for (MaterialType t2 : GTAPI.all(MaterialType.class)) {
            if (t2.getUnitValue() <= 0L || t2 == GTMaterialTypes.DUST || t2 == GTMaterialTypes.TINY_DUST || t2 == GTMaterialTypes.SMALL_DUST || t2 == GTMaterialTypes.INGOT || t2 == GTMaterialTypes.NUGGET || t2 == GTMaterialTypes.CHUNK || t2 == GTMaterialTypes.HOT_INGOT || t2 == GTMaterialTypes.GEM || t2 == GTMaterialTypes.CHIPPED_GEM || t2 == GTMaterialTypes.FLAWED_GEM || t2 == GTMaterialTypes.FLAWLESS_GEM || t2 == GTMaterialTypes.EXQUISITE_GEM || t2 == GTMaterialTypes.ROCK || t2 == GTMaterialTypes.BEARING_ROCK) continue;
            double amount = (double)t2.getUnitValue() / 1.8144E7;
            t2.all().forEach(m -> {
                if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST}) || m == Materials.Bone || m == Materials.Carbon || m == Materials.Blaze) {
                    return;
                }
                if (m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                    int i = (int)amount;
                    float leftover = (float)(amount - (double)i);
                    RecipeBuilder mac = RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{t2.getMaterialIngredient(m, 1)});
                    if (leftover > 0.0f) {
                        float mExtraF = leftover * 4.0f;
                        int mExtra = (int)mExtraF;
                        float mLeftover = mExtraF - (float)mExtra;
                        int aExtra = (int)(leftover * 9.0f);
                        if (mLeftover > 0.0f) {
                            mac.io(new ItemStack[]{GTMaterialTypes.TINY_DUST.get(m, i * 9 + aExtra)});
                        } else {
                            mac.io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(m, i * 4 + mExtra)});
                        }
                    } else {
                        mac.io(new ItemStack[]{GTMaterialTypes.DUST.get(m, i)});
                    }
                    mac.add(m.getId() + "_" + t2.getId() + "_recycling", m.getMass() * 2L, 4L);
                } else {
                    RecyclingLoader.addRecyclingRecipe((Ingredient)t2.getMaterialIngredient(m, 1), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)m, (Object)Float.valueOf((float)amount)), m.getId() + "_" + t2.getId() + "_recycling");
                }
            });
        }
        GTAPI.all(BlockColoredWall.class).forEach(b -> {
            if (b.getMaterial() == Materials.Wood) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)b.m_5456_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Lead, (Object)Float.valueOf(1.0f), (Object)Materials.Wood, (Object)Float.valueOf(4.0f)));
            } else {
                RecyclingLoader.addRecyclingRecipe((ItemLike)b.m_5456_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)b.getMaterial(), (Object)Float.valueOf(4.0f)));
            }
        });
        GTAPI.all(FluidPipe.class).stream().filter(t -> t.getMaterial() != Materials.Wood && t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST})).forEach(t -> {
            if (t.getSizes().contains((Object)PipeSize.TINY)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.TINY), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(0.5f)));
            }
            if (t.getSizes().contains((Object)PipeSize.SMALL)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.SMALL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(1.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.NORMAL)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.NORMAL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(3.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.LARGE)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.LARGE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(6.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.HUGE)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.HUGE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(12.0f)));
            }
        });
        GTAPI.all(ItemPipe.class).stream().filter(t -> t.getMaterial() != Materials.Wood && t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST})).forEach(t -> {
            if (t.getSizes().contains((Object)PipeSize.TINY)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.TINY), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(0.5f)));
            }
            if (t.getSizes().contains((Object)PipeSize.SMALL)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.SMALL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(1.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.NORMAL)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.NORMAL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(3.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.LARGE)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.LARGE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(6.0f)));
            }
            if (t.getSizes().contains((Object)PipeSize.HUGE)) {
                RecyclingLoader.addRecyclingRecipe((ItemLike)t.getBlockItem(PipeSize.HUGE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)t.getMaterial(), (Object)Float.valueOf(12.0f)));
            }
        });
        GTAPI.all(Wire.class, w -> {
            ImmutableSet sizes = w.getSizes();
            if (!w.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            sizes.forEach(size -> {
                PipeItemBlock cableItem = w.getBlockItem(size);
                int ct = size.getCableThickness();
                float amount = ct == 1 ? 0.5f : (ct == 2 ? 1.0f : (ct == 4 ? 2.0f : (ct == 8 ? 4.0f : (ct == 12 ? 6.0f : 8.0f))));
                RecyclingLoader.addRecyclingRecipe((ItemLike)cableItem, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)w.getMaterial(), (Object)Float.valueOf(amount)));
            });
        });
        GTAPI.all(RedstoneWire.class, w -> {
            ImmutableSet sizes = w.getSizes();
            if (!w.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            sizes.forEach(size -> {
                PipeItemBlock cableItem = w.getBlockItem(size);
                int ct = size.getCableThickness();
                float amount = ct == 1 ? 0.5f : (ct == 2 ? 1.0f : (ct == 4 ? 2.0f : (ct == 8 ? 4.0f : (ct == 12 ? 6.0f : 8.0f))));
                RecyclingLoader.addRecyclingRecipe((ItemLike)cableItem, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)w.getMaterial(), (Object)Float.valueOf(amount)));
            });
        });
        GTAPI.all(Cable.class, c -> {
            ImmutableSet sizes = c.getSizes();
            if (!c.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            sizes.forEach(size -> {
                float multiplier;
                PipeItemBlock cableItem = c.getBlockItem(size);
                int ct = size.getCableThickness();
                float f = ct == 16 ? 5.0f : (ct == 12 ? 4.0f : (ct == 8 ? 3.0f : (multiplier = ct == 4 ? 2.0f : 1.0f)));
                float amount = ct == 1 ? 0.5f : (ct == 2 ? 1.0f : (ct == 4 ? 2.0f : (ct == 8 ? 4.0f : (ct == 12 ? 6.0f : 8.0f))));
                RecyclingLoader.addRecyclingRecipe((ItemLike)cableItem, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)c.getMaterial(), (Object)Float.valueOf(amount), (Object)Materials.Rubber, (Object)Float.valueOf(multiplier)));
            });
        });
        RecyclingLoader.addRecyclingRecipe((ItemLike)GTCoreItems.MotorLV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Tin, (Object)Float.valueOf(1.0f), (Object)Materials.Steel, (Object)Float.valueOf(1.0f), (Object)Materials.Iron, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GTCoreItems.MotorMV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(5.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(1.0f), (Object)Materials.Steel, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GTCoreItems.MotorHV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(8.0f), (Object)Materials.Gold, (Object)Float.valueOf(1.0f), (Object)Materials.StainlessSteel, (Object)Float.valueOf(1.0f), (Object)Materials.Steel, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GTCoreItems.MotorEV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(16.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(1.0f), (Object)Materials.Titanium, (Object)Float.valueOf(1.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GTCoreItems.MotorIV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(32.0f), (Object)Materials.Tungsten, (Object)Float.valueOf(1.0f), (Object)Materials.TungstenSteel, (Object)Float.valueOf(1.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_PUMP.getItem(Tier.LV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Tin, (Object)Float.valueOf(5.78f), (Object)Materials.Bronze, (Object)Float.valueOf(3.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Iron, (Object)Float.valueOf(1.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_PUMP.getItem(Tier.MV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(5.5f), (Object)Materials.Bronze, (Object)Float.valueOf(4.34f), (Object)Materials.Steel, (Object)Float.valueOf(3.5f), (Object)Materials.Aluminium, (Object)Float.valueOf(1.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_PUMP.getItem(Tier.HV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(8.0f), (Object)Materials.Steel, (Object)Float.valueOf(4.78f), (Object)Materials.StainlessSteel, (Object)Float.valueOf(4.0f), (Object)Materials.Gold, (Object)Float.valueOf(1.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_PUMP.getItem(Tier.EV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(16.0f), (Object)Materials.StainlessSteel, (Object)Float.valueOf(4.78f), (Object)Materials.Titanium, (Object)Float.valueOf(4.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(1.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_PUMP.getItem(Tier.IV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(32.0f), (Object)Materials.TungstenSteel, (Object)Float.valueOf(3.67f), (Object)Materials.Tungsten, (Object)Float.valueOf(1.5f), (Object)Materials.Neodymium, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_CONVEYOR.getItem(Tier.LV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Rubber, (Object)Float.valueOf(6.0f), (Object)Materials.Copper, (Object)Float.valueOf(4.0f), (Object)Materials.Iron, (Object)Float.valueOf(3.0f), (Object)Materials.Tin, (Object)Float.valueOf(2.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_CONVEYOR.getItem(Tier.MV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Rubber, (Object)Float.valueOf(6.0f), (Object)Materials.Copper, (Object)Float.valueOf(10.5f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f), (Object)Materials.Steel, (Object)Float.valueOf(1.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_CONVEYOR.getItem(Tier.HV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(16.0f), (Object)Materials.Gold, (Object)Float.valueOf(2.5f), (Object)Materials.StainlessSteel, (Object)Float.valueOf(2.0f), (Object)Materials.Steel, (Object)Float.valueOf(1.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_CONVEYOR.getItem(Tier.EV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(32.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.5f), (Object)Materials.Titanium, (Object)Float.valueOf(2.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(1.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RCovers.COVER_CONVEYOR.getItem(Tier.IV).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(64.0f), (Object)Materials.Tungsten, (Object)Float.valueOf(2.5f), (Object)Materials.TungstenSteel, (Object)Float.valueOf(2.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(1.0f)));
        RecyclingLoader.addRecyclingRecipe(GT5RItems.PistonLV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(5.0f), (Object)Materials.Tin, (Object)Float.valueOf(2.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Iron, (Object)Float.valueOf(1.5f)));
        RecyclingLoader.addRecyclingRecipe(GT5RItems.PistonMV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Aluminium, (Object)Float.valueOf(6.0f), (Object)Materials.Copper, (Object)Float.valueOf(6.0f), (Object)Materials.Steel, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe(GT5RItems.PistonHV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(8.0f), (Object)Materials.StainlessSteel, (Object)Float.valueOf(6.0f), (Object)Materials.Gold, (Object)Float.valueOf(2.0f), (Object)Materials.Steel, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe(GT5RItems.PistonEV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(16.0f), (Object)Materials.Titanium, (Object)Float.valueOf(6.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe(GT5RItems.PistonIV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(32.0f), (Object)Materials.TungstenSteel, (Object)Float.valueOf(6.0f), (Object)Materials.Tungsten, (Object)Float.valueOf(2.0f), (Object)Materials.Neodymium, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.SOLID_FUEL_BOILER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Bronze, (Object)Float.valueOf(5.0f), (Object)Materials.Brick, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.SOLID_FUEL_BOILER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Steel, (Object)Float.valueOf(5.0f), (Object)Materials.Brick, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.LAVA_BOILER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(10.0f), (Object)Materials.Glass, (Object)Float.valueOf(3.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.SOLAR_BOILER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(7.0f), (Object)Materials.Glass, (Object)Float.valueOf(3.0f), (Object)Materials.Silver, (Object)Float.valueOf(3.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_FURNACE.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(12.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_FURNACE.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(12.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_COMPRESSOR.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(14.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_COMPRESSOR.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(14.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_EXTRACTOR.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(14.0f), (Object)Materials.Stone, (Object)Float.valueOf(4.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_EXTRACTOR.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(14.0f), (Object)Materials.Stone, (Object)Float.valueOf(4.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_FORGE_HAMMER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(14.0f), (Object)Materials.Iron, (Object)Float.valueOf(10.0f), (Object)Materials.Stone, (Object)Float.valueOf(4.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_FORGE_HAMMER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(14.0f), (Object)Materials.Iron, (Object)Float.valueOf(10.0f), (Object)Materials.Stone, (Object)Float.valueOf(4.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_ALLOY_SMELTER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(11.0f), (Object)Materials.Stone, (Object)Float.valueOf(16.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_ALLOY_SMELTER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(11.0f), (Object)Materials.Stone, (Object)Float.valueOf(16.0f), (Object)Materials.Wood, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_SIFTER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(11.0f), (Object)Materials.Steel, (Object)Float.valueOf(3.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_SIFTER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(14.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_MACERATOR.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(12.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f), (Object)Materials.Diamond, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_MACERATOR.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(12.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f), (Object)Materials.Diamond, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_CUTTER.getItem(Tier.BRONZE), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(13.0f), (Object)Materials.Steel, (Object)Float.valueOf(4.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RMachines.STEAM_CUTTER.getItem(Tier.STEEL), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(17.0f), (Object)Materials.Stone, (Object)Float.valueOf(8.0f), (Object)Materials.Wood, (Object)Float.valueOf(6.0f)));
        for (Tier tier : Tier.getAllElectric()) {
            RecyclingLoader.addRecyclingRecipe((ItemLike)GT5Reimagined.get(BlockCasing.class, "casing_" + tier.getId()), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (Object)Float.valueOf(8.0f)));
        }
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRONZE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRICKED_BRONZE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(5.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STEEL_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRICKED_STEEL_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(5.0f), (Object)Materials.Brick, (Object)Float.valueOf(3.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.SOLID_STEEL_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STAINLESS_STEEL_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.StainlessSteel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TITANIUM_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Titanium, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTEN_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Tungsten, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.PLATINUM_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Platinum, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BLACK_BRONZE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.BlackBronze, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.HEAT_PROOF_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Invar, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.FROST_PROOF_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Aluminium, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.RADIATION_PROOF_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Lead, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.DENSE_LEAD_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Lead, (Object)Float.valueOf(56.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRONZE_FIREBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STEEL_FIREBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TITANIUM_FIREBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Titanium, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_FIREBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRONZE_GEARBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(14.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STEEL_GEARBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(14.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TITANIUM_GEARBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Titanium, (Object)Float.valueOf(14.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_GEARBOX_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(14.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.BRONZE_PIPE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Bronze, (Object)Float.valueOf(18.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STEEL_PIPE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(18.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TITANIUM_PIPE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Titanium, (Object)Float.valueOf(18.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_PIPE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(18.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STEEL_TURBINE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(9.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.STAINLESS_STEEL_TURBINE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.StainlessSteel, (Object)Float.valueOf(9.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TITANIUM_TURBINE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Titanium, (Object)Float.valueOf(9.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_TURBINE_CASING, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(9.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.CUPRONICKEL_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Cupronickel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.KANTHAL_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Kanthal, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.NICHROME_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Nichrome, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.TUNGSTENSTEEL_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.HSSG_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.HSSG, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.NAQUADAH_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Naquadah, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.NAQUADAH_ALLOY_COIL, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.NaquadahAlloy, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42341_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Iron, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.MINING_PIPE_THIN, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Steel, (Object)Float.valueOf(0.5f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_ITEM_PIPE, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Electrum, (Object)Float.valueOf(12.0f), (Object)Materials.Plastic, (Object)Float.valueOf(4.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_FLUID_PIPE, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.StainlessSteel, (Object)Float.valueOf(12.0f), (Object)Materials.Plastic, (Object)Float.valueOf(4.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_WIRE_EV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Tin, (Object)Float.valueOf(16.0f), (Object)Materials.Rubber, (Object)Float.valueOf(4.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_WIRE_IV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Copper, (Object)Float.valueOf(18.0f), (Object)Materials.Rubber, (Object)Float.valueOf(4.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_WIRE_LUV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Electrum, (Object)Float.valueOf(16.0f), (Object)Materials.Rubber, (Object)Float.valueOf(4.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_WIRE_ZPM, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Aluminium, (Object)Float.valueOf(18.0f), (Object)Materials.Rubber, (Object)Float.valueOf(4.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)GT5RBlocks.LONG_DIST_WIRE_UV, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Platinum, (Object)Float.valueOf(16.0f), (Object)Materials.Rubber, (Object)Float.valueOf(4.0f), (Object)Materials.Copper, (Object)Float.valueOf(2.0f), (Object)Materials.Aluminium, (Object)Float.valueOf(2.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42468_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Iron, (Object)Float.valueOf(5.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42469_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Iron, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42470_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Iron, (Object)Float.valueOf(7.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42471_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Iron, (Object)Float.valueOf(4.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42476_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Gold, (Object)Float.valueOf(5.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42477_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Gold, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42478_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Gold, (Object)Float.valueOf(7.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42479_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Gold, (Object)Float.valueOf(4.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42472_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Diamond, (Object)Float.valueOf(5.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42473_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Diamond, (Object)Float.valueOf(8.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42474_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Diamond, (Object)Float.valueOf(7.0f)));
        RecyclingLoader.addRecyclingRecipe((ItemLike)Items.f_42475_, (ImmutableMap<Material, Float>)ImmutableMap.of((Object)Materials.Diamond, (Object)Float.valueOf(4.0f)));
        MaterialTags.ARMOR.all().forEach(m -> {
            RecyclingLoader.addRecyclingRecipe((ItemLike)GTTools.HELMET.getToolStack(m).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)m, (Object)Float.valueOf(5.0f)));
            RecyclingLoader.addRecyclingRecipe((ItemLike)GTTools.CHESTPLATE.getToolStack(m).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)m, (Object)Float.valueOf(8.0f)));
            RecyclingLoader.addRecyclingRecipe((ItemLike)GTTools.LEGGINGS.getToolStack(m).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)m, (Object)Float.valueOf(7.0f)));
            RecyclingLoader.addRecyclingRecipe((ItemLike)GTTools.BOOTS.getToolStack(m).m_41720_(), (ImmutableMap<Material, Float>)ImmutableMap.of((Object)m, (Object)Float.valueOf(4.0f)));
        });
    }

    private static void addRecyclingRecipe(ItemLike input, ImmutableMap<Material, Float> outputs) {
        RecyclingLoader.addRecyclingRecipe(RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{input}), outputs, RegistryUtils.getIdFromItem((Item)input.m_5456_()).m_135815_());
    }

    private static void addRecyclingRecipe(Ingredient input, ImmutableMap<Material, Float> outputs, String id) {
        RecipeBuilder arc = RecipeMaps.ARC_FURNACE.RB();
        RecipeBuilder mac = RecipeMaps.PULVERIZER.RB();
        arc.ii(new Ingredient[]{input});
        mac.ii(new Ingredient[]{input});
        long[] totalMassArc = new long[]{0L};
        long[] totalMassMac = new long[]{0L};
        outputs.forEach((material, floatAmount) -> {
            Material arcOutput = material.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) || material == Materials.Wood ? Materials.Ash : (Material)MaterialTags.ARC_SMELT_INTO.get(material);
            Material macOutput = (Material)MaterialTags.MACERATE_INTO.get(material);
            int roundedAmount = floatAmount.intValue();
            float arcFloatAmount = floatAmount.floatValue();
            if (material.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) || material == Materials.Wood) {
                arcFloatAmount = floatAmount.floatValue() / 9.0f;
            }
            int roundedArcAmount = (int)arcFloatAmount;
            float leftover = floatAmount.floatValue() - (float)roundedAmount;
            float arcLeftover = arcFloatAmount - (float)roundedArcAmount;
            totalMassMac[0] = totalMassMac[0] + (long)((float)material.getMass() * floatAmount.floatValue());
            if (leftover > 0.0f) {
                float smallLeftover = leftover * 4.0f;
                int smallExtra = (int)smallLeftover;
                float tinyLeftover = smallLeftover - (float)smallExtra;
                int tinyExtra = (int)(leftover * 9.0f);
                if (tinyLeftover > 0.0f) {
                    mac.io(new ItemStack[]{GTMaterialTypes.TINY_DUST.get(macOutput, roundedAmount * 9 + tinyExtra)});
                } else {
                    mac.io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(macOutput, roundedAmount * 4 + smallExtra)});
                }
            } else {
                mac.io(new ItemStack[]{GTMaterialTypes.DUST.get(macOutput, roundedAmount)});
            }
            if (arcOutput == Materials.Ash || arcOutput.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                MaterialTypeItem arcType;
                int amount = 0;
                if (arcLeftover > 0.0f) {
                    float smallLeftover = arcLeftover * 4.0f;
                    int smallExtra = (int)smallLeftover;
                    float tinyLeftover = smallLeftover - (float)smallExtra;
                    int tinyExtra = (int)(arcLeftover * 9.0f);
                    if (tinyLeftover > 0.0f) {
                        amount = roundedArcAmount * 9 + tinyExtra;
                        arcType = arcOutput == Materials.Ash ? GTMaterialTypes.TINY_DUST : GTMaterialTypes.NUGGET;
                    } else {
                        arcType = arcOutput == Materials.Ash ? GTMaterialTypes.SMALL_DUST : GTMaterialTypes.CHUNK;
                        amount = roundedArcAmount * 4 + smallExtra;
                    }
                } else {
                    arcType = arcOutput == Materials.Ash ? GTMaterialTypes.DUST : GTMaterialTypes.INGOT;
                    amount = roundedArcAmount;
                }
                if (amount > 0) {
                    totalMassArc[0] = totalMassArc[0] + (long)((float)arcOutput.getMass() * arcFloatAmount);
                    arc.io(new ItemStack[]{arcType.get(arcOutput, amount)});
                }
            }
        });
        if (totalMassArc[0] > 0L) {
            arc.fi(new FluidStack[]{Materials.Oxygen.getGas((int)totalMassArc[0])}).tags(new String[]{"recycling"}).add(id, totalMassArc[0], 32L);
        }
        if (totalMassMac[0] > 0L) {
            mac.tags(new String[]{"recycling"}).add(id, totalMassMac[0] * 2L, 4L);
        }
    }

    static int fromTier(Tier tier) {
        if (tier == Tier.LV) {
            return 1;
        }
        if (tier == Tier.MV) {
            return 2;
        }
        if (tier == Tier.HV) {
            return 4;
        }
        if (tier == Tier.IV) {
            return 16;
        }
        return 8;
    }
}

