/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.block.BlockAsphalt;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class MixerLoader {
    public static void init() {
        MixerLoader.addDust(Materials.StainlessSteel, 8, 900);
        MixerLoader.addDust(Materials.Nichrome, 8, 500);
        MixerLoader.addDust(Materials.Invar, 8, 300);
        MixerLoader.addDust(Materials.Bronze, 8, 200);
        MixerLoader.addDust(Materials.BlackBronze, 8, 500);
        MixerLoader.addDust(Materials.FerriteMixture, 8, 600);
        MixerLoader.addDust(Materials.IndiumGalliumPhosphide, 8, 400);
        MixerLoader.addDust(Materials.Energium, 8, 200);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.DUST_LAPIS_LAZURITE, (int)6), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Redstone, 4)}).fi(new FluidStack[]{Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.Lapotronium.getLiquid(1000)}).add("lapotronium_fluid", 200L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.DUST_LAPIS_LAZURITE, (int)6), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Redstone, 4)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(1000)}).fo(new FluidStack[]{Materials.Lapotronium.getLiquid(1000)}).add("lapotronium_fluid_from_distilled", 200L, 8L);
        MixerLoader.addDust(Materials.GalliumArsenide, 8, 300);
        MixerLoader.addDust(Materials.VanadiumSteel, 8, 1000);
        MixerLoader.addDust(Materials.CobaltBrass, 8, 900);
        MixerLoader.addDust(Materials.CdInAGAlloy, 8, 800);
        MixerLoader.addDust(Materials.BlueSteel, 8, 800);
        MixerLoader.addDust(Materials.RedSteel, 8, 800);
        MixerLoader.addDust(Materials.BlackSteel, 8, 500);
        MixerLoader.addDust(Materials.SterlingSilver, 8, 500);
        MixerLoader.addDust(Materials.RoseGold, 8, 500);
        MixerLoader.addDust(Materials.BismuthBronze, 8, 500);
        MixerLoader.addDust(Materials.VanadiumGallium, 8, 400);
        MixerLoader.addDust(Materials.Ultimet, 8, 900);
        MixerLoader.addDust(Materials.TinAlloy, 8, 200);
        MixerLoader.addDust(Materials.SodiumSulfide, 8, 60);
        MixerLoader.addDust(Materials.Magnalium, 8, 400);
        MixerLoader.addDust(Materials.Kanthal, 8, 300);
        MixerLoader.addDust(Materials.Electrum, 8, 200);
        MixerLoader.addDust(Materials.Brass, 8, 400);
        MixerLoader.addDust(Materials.BatteryAlloy, 8, 500);
        MixerLoader.addDust(Materials.Cupronickel, 8, 200);
        MixerLoader.addDust(Materials.EnderEye, 8, 100);
        MixerLoader.recipes();
        MixerLoader.addAsphaltRecipe(Materials.Stone, GT5RBlocks.GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Andesite, GT5RBlocks.LIGHT_GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Basalt, GT5RBlocks.BLACK_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.BlueSchist, GT5RBlocks.LIGHT_BLUE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Calcite, GT5RBlocks.WHITE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Deepslate, GT5RBlocks.BLACK_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Diorite, GT5RBlocks.WHITE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Endstone, GT5RBlocks.WHITE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Granite, GT5RBlocks.RED_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.BlackGranite, GT5RBlocks.BLACK_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.RedGranite, GT5RBlocks.RED_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Kimberlite, GT5RBlocks.BROWN_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Komatiite, GT5RBlocks.YELLOW_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Limestone, GT5RBlocks.ORANGE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Marble, GT5RBlocks.WHITE_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Netherrack, GT5RBlocks.RED_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.OilShale, GT5RBlocks.GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Prismarine, GT5RBlocks.LIME_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.DarkPrismarine, GT5RBlocks.GREEN_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Quartzite, GT5RBlocks.PINK_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Shale, GT5RBlocks.GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Slate, GT5RBlocks.GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.Talc, GT5RBlocks.GRAY_ASPHALT);
        MixerLoader.addAsphaltRecipe(Materials.GreenSchist, GT5RBlocks.GREEN_ASPHALT);
        for (DyeColor dye : DyeColor.values()) {
            String dyeName = dye.m_41065_() + "_dye";
            Material dyeMaterial = Material.get((String)("water_mixed_" + dyeName));
            RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)dye.getTag())}).fi(new FluidStack[]{Materials.Water.getLiquid(144)}).fo(new FluidStack[]{dyeMaterial.getLiquid(216)}).add("water_mixed_" + dyeName, 16L, 4L);
            RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)dye.getTag())}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(144)}).fo(new FluidStack[]{dyeMaterial.getLiquid(216)}).add("water_mixed_" + dyeName + "_distilled_water", 16L, 4L);
            RecipeMaps.MIXER.RB().fi(new FluidStack[]{Material.get((String)("chemical_" + dyeName)).getLiquid(144), Materials.Concrete.getLiquid(144)}).fo(new FluidStack[]{Material.get((String)(dye.m_41065_() + "_concrete")).getLiquid(144)}).add(dye.m_41065_() + "_concrete", 16L, 4L);
        }
    }

    private static void addAsphaltRecipe(Material dust, BlockAsphalt asphalt) {
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(dust, 1)}).fi(new FluidStack[]{Materials.Bitumen.getLiquid(144)}).io(new Item[]{asphalt.m_5456_()}).add(asphalt.getId() + "_from_" + dust.getId(), 16L, 16L);
    }

    private static void addDust(Material mat, int eut, int duration) {
        for (MaterialTypeItem type : new MaterialTypeItem[]{GTMaterialTypes.DUST, GTMaterialTypes.SMALL_DUST, GTMaterialTypes.TINY_DUST}) {
            List ings = mat.getProcessInto().stream().map(t -> type.getMaterialIngredient(t.m, t.s)).collect(Collectors.toList());
            if (ings.size() == 0) {
                return;
            }
            MaterialTypeItem type2 = type;
            int count = mat.getProcessInto().stream().mapToInt(t -> t.s).sum();
            if (type != GTMaterialTypes.DUST) {
                if (type == GTMaterialTypes.SMALL_DUST) {
                    if (count % 4 == 0) {
                        count /= 4;
                        type2 = GTMaterialTypes.DUST;
                    }
                } else if (count % 9 == 0) {
                    count /= 9;
                    type2 = GTMaterialTypes.DUST;
                }
            }
            RecipeMaps.MIXER.RB().ii(ings).io(new ItemStack[]{type2.get(mat, count)}).add(type.getId() + "_" + mat.getId(), (long)duration, (long)eut);
        }
    }

    private static void recipes() {
        if (GT5RConfig.MORE_COMPLICATED_CHEMICAL_RECIPES) {
            RecipeMaps.MIXER.RB().fi(new FluidStack[]{Materials.PolyvinylAcetate.getLiquid(1000), Materials.Acetone.getLiquid(1500)}).fo(new FluidStack[]{Materials.Glue.getLiquid(2500)}).add("glue", 50L, 8L);
            RecipeMaps.MIXER.RB().fi(new FluidStack[]{Materials.PolyvinylAcetate.getLiquid(1000), Materials.MethylAcetate.getLiquid(1500)}).fo(new FluidStack[]{Materials.Glue.getLiquid(2500)}).add("glue_1", 50L, 8L);
        }
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Apatite, 1), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Ash), GTMaterialTypes.DUST.getMaterialTag(Materials.Potassium)})}).io(new ItemStack[]{new ItemStack((ItemLike)GTCoreItems.Fertilizer, 2)}).add("fertilizer", 200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.TricalciumPhosphate, 3), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Ash), GTMaterialTypes.DUST.getMaterialTag(Materials.Potassium)})}).io(new ItemStack[]{new ItemStack((ItemLike)GTCoreItems.Fertilizer, 4)}).add("fertilizer_1", 200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Phosphate, 3), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Ash), GTMaterialTypes.DUST.getMaterialTag(Materials.Potassium)})}).io(new ItemStack[]{new ItemStack((ItemLike)GTCoreItems.Fertilizer, 5)}).add("fertilizer_2", 200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Salt, 2))}).fi(new FluidStack[]{Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.SaltWater.getLiquid(1000)}).add("salt_water", 40L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Salt, 2))}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(1000)}).fo(new FluidStack[]{Materials.SaltWater.getLiquid(1000)}).add("salt_water_2", 40L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_1", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_2", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_3", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_4", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_5", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Redstone, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_6", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Redstone, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_7", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Redstone, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_8", 128L, 4L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Glass, 7)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Boron, 1))}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.BorosilicateGlass, 8)}).add("borosilicate_glass", 800L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Saltpeter, 2)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Sulfur, 1)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Coal, 1))}).io(new Item[]{Items.f_42403_}).add("gunpowder", 400L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Saltpeter, 2)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Sulfur, 1)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Charcoal, 1))}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42403_, 2)}).add("gunpowder_1", 300L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Stone, 1))}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(20), Materials.Water.getLiquid(4980)}).fo(new FluidStack[]{Materials.DrillingFluid.getLiquid(5000)}).add("drilling_fluid", 64L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Stone, 3)), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Clay, 1))}).fi(new FluidStack[]{Materials.Water.getLiquid(500)}).fo(new FluidStack[]{Materials.Concrete.getLiquid(576)}).add("concrete", 20L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GTCoreItems.Biochaff})}).fi(new FluidStack[]{Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.Biomass.getLiquid(1000)}).add("biomass", 400L, 8L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.DUST_LAPIS_LAZURITE, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(1000)}).fo(new FluidStack[]{Materials.Coolant.getLiquid(1000)}).add("cold_coolant", 256L, 48L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumPersulfate, 1)}).fi(new FluidStack[]{Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.SodiumPersulfateSolution.getLiquid(1000)}).add("sodium_persulfate_solution", 20L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumPersulfate, 1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(1000)}).fo(new FluidStack[]{Materials.SodiumPersulfateSolution.getLiquid(1000)}).add("sodium_persulfate_solution_distilled", 20L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Lithium, 1)}).fi(new FluidStack[]{Materials.Glue.getLiquid(333)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder", 800L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sodium, 1)}).fi(new FluidStack[]{Materials.Glue.getLiquid(333)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder_1", 800L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Caesium, 1)}).fi(new FluidStack[]{Materials.Glue.getLiquid(333)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 12)}).add("super_fuel_binder_2", 800L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Lithium, 1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(300)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder_3", 1200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sodium, 1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(300)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder_4", 1200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Caesium, 1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(300)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 12)}).add("super_fuel_binder_5", 1200L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Lithium, 1)}).fi(new FluidStack[]{Materials.Creosote.getLiquid(1000)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder_6", 1600L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sodium, 1)}).fi(new FluidStack[]{Materials.Creosote.getLiquid(1000)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 8)}).add("super_fuel_binder_7", 1600L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 4), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Caesium, 1)}).fi(new FluidStack[]{Materials.Creosote.getLiquid(1000)}).io(new ItemStack[]{new ItemStack(GT5RItems.SuperFuelBinder, 12)}).add("super_fuel_binder_8", 1600L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Lignite, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)6)}).fi(new FluidStack[]{Materials.LPG.getLiquid(1500)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_lignite_lpg", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Charcoal, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)4)}).fi(new FluidStack[]{Materials.LPG.getLiquid(1200)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_charcoal_lpg", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Coal, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)2)}).fi(new FluidStack[]{Materials.LPG.getLiquid(750)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_coal_lpg", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Lignite, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)6)}).fi(new FluidStack[]{Materials.NitroDiesel.getLiquid(1000)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_lignite_nitro", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Charcoal, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)4)}).fi(new FluidStack[]{Materials.NitroDiesel.getLiquid(800)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_charcoal_nitro", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.BLOCK.getMaterialIngredient(Materials.Coal, 1), RecipeIngredient.of(GT5RItems.SuperFuelBinder, (int)2)}).fi(new FluidStack[]{Materials.NitroDiesel.getLiquid(500)}).io(new Item[]{GT5RBlocks.SOLID_SUPER_FUEL.m_5456_()}).add("solid_super_fuel_coal_nitro", 120L, 96L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 1)}).fi(new FluidStack[]{Materials.Glue.getLiquid(25)}).io(new Item[]{GT5RItems.WoodPellet}).add("wood_pellet", 16L, 16L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.TINY_DUST.getMaterialIngredient(Materials.Thorium, 1)}).fi(new FluidStack[]{Materials.LithiumChloride.getLiquid(2304)}).fo(new FluidStack[]{Materials.ThoriumSalt.getLiquid(2304)}).add("thorium_salt_tiny", 128L, 64L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Thorium, 1)}).fi(new FluidStack[]{Materials.LithiumChloride.getLiquid(5184)}).fo(new FluidStack[]{Materials.ThoriumSalt.getLiquid(5184)}).add("thorium_salt_small", 288L, 64L);
        RecipeMaps.MIXER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Thorium, 1)}).fi(new FluidStack[]{Materials.LithiumChloride.getLiquid(20736)}).fo(new FluidStack[]{Materials.ThoriumSalt.getLiquid(20736)}).add("thorium_salt_dust", 1152L, 64L);
    }
}

