/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;

public class MaceratorLoader {
    public static void initAuto() {
        GTMaterialTypes.ORE.all().forEach(m -> GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).filter(s -> s != VanillaStoneTypes.BEDROCK).forEach(s -> {
            Material sm = s.getMaterial();
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && !m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE})) {
                return;
            }
            ItemStack stoneDust = sm.has(new IMaterialTag[]{GTMaterialTypes.DUST}) ? GTMaterialTypes.DUST.get(sm, 1) : ItemStack.f_41583_;
            TagKey oreTag = GTMaterialTypes.ORE.getMaterialTag(m, s);
            RecipeIngredient ore = RecipeIngredient.of((TagKey)oreTag, (int)1);
            ItemStack crushedStack = (m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE}) ? GTMaterialTypes.CRUSHED_ORE : GTMaterialTypes.DUST).get(m, MaterialTags.ORE_MULTI.getInt(m));
            Material oreByProduct1 = m.getByProducts().size() > 0 ? (Material)m.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(m);
            RecipeMap<RecipeBuilder> rm = s.isSandLike() ? RecipeMaps.SIFTER : RecipeMaps.PULVERIZER;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * (rm == RecipeMaps.SIFTER ? 1 : 2)), (ItemStack)crushedStack));
            if (rm == RecipeMaps.SIFTER) {
                stacks.add(crushedStack);
                stacks.add(crushedStack);
                stacks.add(crushedStack);
            }
            stacks.add(GTMaterialTypes.DUST.get(oreByProduct1, 1));
            if (!stoneDust.m_41619_()) {
                stacks.add(stoneDust);
            }
            ItemStack[] stackArray = stacks.toArray(new ItemStack[0]);
            ArrayList<Double> ints = new ArrayList<Double>();
            if (rm == RecipeMaps.SIFTER) {
                ints.add(0.7);
                ints.add(0.5);
                ints.add(0.3);
                ints.add(0.1);
            } else {
                ints.add(1.0);
            }
            ints.add(0.1 * (double)MaterialTags.BY_PRODUCT_MULTI.getInt(m));
            if (!stoneDust.m_41619_()) {
                ints.add(0.5);
            }
            double[] chances = ints.stream().mapToDouble(i -> i).toArray();
            rm.RB().ii(new Ingredient[]{ore}).io(stackArray).outputChances(chances).tags(new String[]{"macerator_ore_processing"}).add("ore_" + m.getId() + "_" + s.getId(), 400L, 2L);
        }));
        GTMaterialTypes.CRUSHED_ORE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE})) {
                return;
            }
            RecipeIngredient crushed = GTMaterialTypes.CRUSHED_ORE.getIngredient(m, 1);
            Material aOreByProduct1 = !m.getByProducts().isEmpty() ? (Material)m.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(m);
            Material aOreByProduct2 = m.getByProducts().size() > 1 ? (Material)m.getByProducts().get(1) : aOreByProduct1;
            Material aOreByProduct3 = m.getByProducts().size() > 2 ? (Material)m.getByProducts().get(2) : aOreByProduct2;
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{crushed}).io(new ItemStack[]{GTMaterialTypes.IMPURE_DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), GTMaterialTypes.DUST.get(aOreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1}).tags(new String[]{"macerator_ore_processing"}).add("crushed_" + m.getId(), 400L, 2L);
            if (m.has(new IMaterialTag[]{GTMaterialTypes.REFINED_ORE})) {
                RecipeBuilder rb = RecipeMaps.PULVERIZER.RB();
                rb.ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GTMaterialTypes.REFINED_ORE.get(m, 1))}).io(new ItemStack[]{GTMaterialTypes.DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), GTMaterialTypes.DUST.get(aOreByProduct3, 1)});
                ArrayList<Integer> chances = new ArrayList<Integer>();
                chances.add(10000);
                chances.add(1000);
                if (m.getByProducts().size() > 3) {
                    rb.io(new Item[]{GTMaterialTypes.DUST.get((Material)m.getByProducts().get(3))});
                    chances.add(1000);
                }
                if (m.getByProducts().size() > 4) {
                    rb.io(new Item[]{GTMaterialTypes.DUST.get((Material)m.getByProducts().get(4))});
                    chances.add(1000);
                }
                rb.outputChances(chances.stream().mapToInt(i -> i).toArray()).tags(new String[]{"macerator_ore_processing"}).add("refined_" + m.getId(), 400L, 2L);
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.PURIFIED_ORE}) && m.has(new IMaterialTag[]{GTMaterialTypes.PURE_DUST})) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.PURIFIED_ORE.getIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.PURE_DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), GTMaterialTypes.DUST.get(aOreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1}).tags(new String[]{"macerator_ore_processing"}).add("purified_" + m.getId(), 400L, 2L);
            }
        });
        GTMaterialTypes.RAW_ORE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && !m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE})) {
                return;
            }
            Material aOreByProduct1 = !m.getByProducts().isEmpty() ? (Material)m.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(m);
            ItemStack crushedStack = (m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE}) ? GTMaterialTypes.CRUSHED_ORE : GTMaterialTypes.DUST).get(m, MaterialTags.ORE_MULTI.getInt(m));
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.RAW_ORE.getMaterialTag(m), (int)1)}).io(new ItemStack[]{Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * 2), (ItemStack)crushedStack), GTMaterialTypes.DUST.get(aOreByProduct1, 1)}).outputChances(new double[]{1.0, 0.1 * (double)MaterialTags.BY_PRODUCT_MULTI.getInt(m)}).tags(new String[]{"macerator_ore_processing"}).add("raw_" + m.getId(), 400L, 2L);
        });
        GTMaterialTypes.EXQUISITE_GEM.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.EXQUISITE_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get((Material)MaterialTags.MACERATE_INTO.get(m), 4)}).add(m.getId() + "_exquisite", m.getMass(), 4L);
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.FLAWLESS_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get((Material)MaterialTags.MACERATE_INTO.get(m), 2)}).add(m.getId() + "_flawless", m.getMass(), 4L);
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.FLAWED_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get((Material)MaterialTags.MACERATE_INTO.get(m), 2)}).add(m.getId() + "_flawed", m.getMass(), 4L);
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.CHIPPED_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get((Material)MaterialTags.MACERATE_INTO.get(m), 1)}).add(m.getId() + "_chipped", m.getMass(), 4L);
        });
        GTMaterialTypes.GEM.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{GTMaterialTypes.GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get((Material)MaterialTags.MACERATE_INTO.get(m), 1)}).add("gem_" + m.getId(), m.getMass(), 4L);
        });
        GTMaterialTypes.INGOT.all().forEach(t -> {
            if (!((Material)MaterialTags.MACERATE_INTO.get(t)).has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(t), (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get((Material)MaterialTags.MACERATE_INTO.get(t), 1)}).add("dust_" + t.getId(), 40L, 2L);
            if (t.has(new IMaterialTag[]{GTMaterialTypes.NUGGET})) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.NUGGET.getMaterialTag(t), (int)1)}).io(new ItemStack[]{GTMaterialTypes.TINY_DUST.get((Material)MaterialTags.MACERATE_INTO.get(t), 1)}).add("dust_tiny_" + t.getId(), 10L, 2L);
            }
            if (t.has(new IMaterialTag[]{GTMaterialTypes.CHUNK})) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.CHUNK.getMaterialTag(t), (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get((Material)MaterialTags.MACERATE_INTO.get(t), 1)}).add("dust_small_" + t.getId(), 10L, 2L);
            }
        });
        GTMaterialTypes.BEARING_ROCK.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.BEARING_ROCK.getMaterialTag(r), (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get((Material)MaterialTags.MACERATE_INTO.get(r), 1)}).add("dust_small_" + r.getId() + "_from_bearing_rock", 20L, 2L);
            }
        });
        GTMaterialTypes.ROCK.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.ROCK.getMaterialTag(r), (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get((Material)MaterialTags.MACERATE_INTO.get(r), 1)}).add("dust_small_" + r.getId() + "_from_rock", 20L, 2L);
            }
        });
        GTAPI.all(StoneType.class, s -> {
            if (s.getMaterial() == Material.NULL || !s.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST}) || s.isSandLike() || s.getState().m_60734_() instanceof BlockOreStone) {
                return;
            }
            RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)s.getState().m_60734_().m_5456_(), (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(s.getMaterial(), 9)}).add(s.getId() + "_stone_to_" + s.getMaterial().getId() + "_dust", 400L, 2L);
            if (s instanceof CobbleStoneType) {
                RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((CobbleStoneType)s).getBlock("cobble").m_5456_(), (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(s.getMaterial(), 9)}).add("cobbled_" + s.getId() + "_to_" + s.getMaterial().getId() + "_dust", 400L, 2L);
            }
        });
        for (DyeColor color : DyeColor.values()) {
            RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(color.m_7912_().toLowerCase() + "_concrete"))}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(color.m_7912_().toLowerCase() + "_concrete_powder"))}).add(color.m_41060_() + "_concrete", 400L, 2L);
        }
    }

    public static void init() {
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41905_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41832_, 1)}).add("gravel", 100L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42594_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41830_, 1)}).add("sand", 100L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41832_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Stone, 9)}).add("stone_dust_from_gravel", 100L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42460_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Brick, 2)}).add("brick_dust", 50L, 4L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42413_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Coal, 1)}).add("coal_dust", 50L, 4L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ItemTags.f_13182_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Wood, 2)}).add("wood_dust", 40L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42461_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Clay, 2)}).add("clay_dust_small", 16L, 4L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41983_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Clay, 2)}).add("clay_dust", 30L, 4L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42199_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Clay, 1)}).add("clay_dust_1", 16L, 4L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.Plantball, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)GTCoreItems.Biochaff, 1)}).add("biochaff", 32L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.Biochaff, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42329_, 1)}).add("dirt", 32L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTCoreTags.RUBBER_LOGS)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Wood, 6), new ItemStack((ItemLike)GTCoreItems.StickyResin, 1)}).outputChances(new double[]{1.0, 0.33}).add("rubber_log", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152497_})}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Calcite)}).add("calcite_from_mc_calcite", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50080_, Blocks.f_50723_})}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Obsidian, 9)}).add("obsidian_dust", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42585_})}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42593_, 5)}).add("blaze_powder", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_})}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42499_, 5)}).add("bone_meal", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42157_})}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Quartz, 4)}).add("quartz_dust_from_block", Materials.Quartz.getMass(), 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)Tags.Items.GLASS)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Glass, 1)}).add("glass_dust", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)ItemTags.f_13167_)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42401_, 4)}).add("wool_to_string", 400L, 2L);
        RecipeMaps.PULVERIZER.RB().ii(new ItemLike[]{GTCoreItems.CarbonMesh}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Carbon, 16)}).add("carbon_mesh_to_dust", 400L, 2L);
    }
}

