/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.function.ToLongFunction;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class CutterLoader {
    public static void init() {
        ToLongFunction<Material> baseDuration = m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS})) {
                return ((Integer)GT5RMaterialTags.RECIPE_MASS.get(m)).intValue();
            }
            return m.getMass();
        };
        for (Material mat : GTMaterialTypes.PLATE.all()) {
            int multiplier = 1;
            if (mat == Materials.Diamond || mat == Materials.NetherizedDiamond) {
                multiplier = 5;
            }
            if (mat.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.GEM.getMaterialTag(mat), GTMaterialTypes.PLATE.get(mat, 1), "plate_" + mat.getId() + "_from_gem", (int)(baseDuration.applyAsLong(mat) * (long)multiplier), 96);
                if (mat.has(new IMaterialTag[]{GTMaterialTypes.FLAWLESS_GEM})) {
                    CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.FLAWLESS_GEM.getMaterialTag(mat), GTMaterialTypes.PLATE.get(mat, 2), "plate_" + mat.getId() + "_from_gem_flawless", (int)(baseDuration.applyAsLong(mat) * (long)multiplier), 96);
                }
                if (mat.has(new IMaterialTag[]{GTMaterialTypes.EXQUISITE_GEM})) {
                    CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.EXQUISITE_GEM.getMaterialTag(mat), GTMaterialTypes.PLATE.get(mat, 4), "plate_" + mat.getId() + "_from_gem_exquisite", (int)(baseDuration.applyAsLong(mat) * (long)multiplier), 96);
                }
            }
            if (!mat.has(new IMaterialTag[]{GTMaterialTypes.BLOCK})) continue;
            int count = mat.has(new IMaterialTag[]{MaterialTags.QUARTZ_LIKE_BLOCKS}) ? 4 : 9;
            CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.BLOCK.getMaterialTag(mat), GTMaterialTypes.PLATE.get(mat, count), "plate_" + mat.getId(), (int)(baseDuration.applyAsLong(mat) * 8L * (long)multiplier), 30);
            if (mat.has(new IMaterialTag[]{GTMaterialTypes.ITEM_CASING})) {
                CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.PLATE.getMaterialTag(mat), GTMaterialTypes.ITEM_CASING.get(mat, 2), "item_casing_" + mat.getId(), (int)(baseDuration.applyAsLong(mat) * 5L * (long)multiplier), 16);
            }
            if (mat != Materials.Silicon) continue;
            CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.PLATE.getMaterialTag(Materials.Silicon), GTMaterialTypes.FOIL.get(Materials.Silicon, 4), "foil_silicon", (int)baseDuration.applyAsLong(Materials.Silicon), 24);
        }
        GTAPI.all(StoneType.class, s -> {
            if (s instanceof CobbleStoneType) {
                CobbleStoneType c = (CobbleStoneType)s;
                for (String type : CobbleStoneType.SUFFIXES) {
                    String id = (String)(type.isEmpty() ? c.getId() : c.getId() + "_" + type) + "_cover";
                    Item cover = (Item)GTAPI.get(Item.class, (String)id, (String)"antimatter_shared");
                    if (cover == null) continue;
                    CutterLoader.addCutterRecipe(c.getBlock(type).m_5456_(), new ItemStack((ItemLike)cover, 8), GTMaterialTypes.DUST.get(c.getMaterial(), 1), id, 20, 2);
                }
            }
        });
        GTMaterialTypes.BOLT.all().forEach(t -> {
            if (t.has(new IMaterialTag[]{GTMaterialTypes.ROD})) {
                CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.ROD.getMaterialTag(t), GTMaterialTypes.BOLT.get(t, 4), "bolt_" + t.getId(), (int)(baseDuration.applyAsLong((Material)t) * 2L), 4);
            }
        });
        GTMaterialTypes.LONG_ROD.all().stream().filter(m -> m.has(new IMaterialTag[]{GTMaterialTypes.ROD})).forEach(m -> CutterLoader.addCutterRecipe((TagKey<Item>)GTMaterialTypes.LONG_ROD.getMaterialTag(m), GTMaterialTypes.ROD.get(m, 2), "rod_" + m.getId(), (int)(baseDuration.applyAsLong((Material)m) * 2L), 4));
        if (!GTAPI.isModLoaded((String)"tfc")) {
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13184_, Items.f_42647_, 1, "oak_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13185_, Items.f_42753_, 1, "birch_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13188_, Items.f_42700_, 1, "spruce_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13186_, Items.f_42795_, 1, "acacia_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13183_, Items.f_42796_, 1, "dark_oak_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13187_, Items.f_42794_, 1, "jungle_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13189_, Items.f_42797_, 1, "crimson_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)ItemTags.f_13190_, Items.f_42798_, 1, "warped_planks", 200, 8);
            CutterLoader.addWoodRecipe((TagKey<Item>)GTCoreTags.RUBBER_LOGS, GTCoreBlocks.RUBBER_PLANKS.m_5456_(), 1, "rubber_planks", 200, 8);
        }
    }

    private static void addCutterRecipe(TagKey<Item> input, ItemStack output, String id, int duration, int euPerTick) {
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{new FluidStack((Fluid)Fluids.f_76193_, Math.max(4, Math.min(1000, duration * euPerTick / 320)))}).io(new ItemStack[]{output}).add(id + "_with_water", (long)duration * 2L, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(Math.max(1, Math.min(250, duration * euPerTick / 1280)))}).io(new ItemStack[]{output}).add(id + "_with_lubricant", (long)duration, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(Math.max(3, Math.min(750, duration * euPerTick / 426)))}).io(new ItemStack[]{output}).add(id + "_with_distilled_water", (long)duration * 2L, (long)euPerTick);
    }

    private static void addCutterRecipe(Item input, ItemStack output, ItemStack dust, String id, int duration, int euPerTick) {
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{new FluidStack((Fluid)Fluids.f_76193_, Math.max(4, Math.min(1000, duration * euPerTick / 320)))}).io(new ItemStack[]{output, dust}).add(id + "_with_water", (long)duration * 2L, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(Math.max(1, Math.min(250, duration * euPerTick / 1280)))}).io(new ItemStack[]{output, dust}).add(id + "_with_lubricant", (long)duration, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(Math.max(3, Math.min(750, duration * euPerTick / 426)))}).io(new ItemStack[]{output, dust}).add(id + "_with_distilled_water", (long)duration * 2L, (long)euPerTick);
    }

    public static void addWoodRecipe(TagKey<Item> input, Item output, int multiplier, String id, int duration, int euPerTick) {
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{new FluidStack((Fluid)Fluids.f_76193_, Math.max(4, Math.min(1000, duration * euPerTick / 320)))}).io(new ItemStack[]{new ItemStack((ItemLike)output, 4 * multiplier), GTMaterialTypes.DUST.get(Materials.Wood, 2)}).add(id + "_with_water", (long)duration * 2L, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(Math.max(1, Math.min(250, duration * euPerTick / 1280)))}).io(new ItemStack[]{new ItemStack((ItemLike)output, 6 * multiplier), GTMaterialTypes.DUST.get(Materials.Wood, 1)}).add(id + "_with_lubricant", (long)duration, (long)euPerTick);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(Math.max(3, Math.min(750, duration * euPerTick / 426)))}).io(new ItemStack[]{new ItemStack((ItemLike)output, 4 * multiplier), GTMaterialTypes.DUST.get(Materials.Wood, 2)}).add(id + "_with_distilled_water", (long)duration * 2L, (long)euPerTick);
    }
}

