/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class ChemicalReactorLoader {
    public static void init() {
        ChemicalReactorLoader.addShared();
        if (GT5RConfig.COMPLICATED_CHEMICAL_PROCESSING.get()) {
            ChemicalReactorLoader.addComplicated();
        }
        ChemicalReactorLoader.nuclearProcessing();
    }

    private static void addShared() {
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1), Materials.Ethylene.getGas(144)}).fo(new FluidStack[]{Materials.Plastic.getLiquid(216)}).add("ethylene_to_polyethylene", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Air.getGas(2), Materials.Ethylene.getGas(288)}).fo(new FluidStack[]{Materials.Plastic.getLiquid(288)}).add("ethylene_to_polyethylene_2", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(1000), Materials.Ethylene.getGas(3000)}).fo(new FluidStack[]{Materials.VinylChloride.getGas(3000), Materials.HydrochloricAcid.getLiquid(1000)}).add("vinyl_chloride", 80L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.VinylChloride.getGas(144)}).fo(new FluidStack[]{Materials.PolyvinylChloride.getLiquid(216)}).add("vinylchloride_to_polyvinylchloride", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Tetrafluoroethylene.getGas(144)}).fo(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(216)}).add("tetrafluoroethylene_to_polytetrafluoroethylene", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Naphtha.getLiquid(3000), Materials.Fluorine.getGas(1000), Materials.Epichlorohydrin.getLiquid(432)}).fo(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(432)}).add("tetrafluoroethylene_to_polytetrafluoroethylene_2", 240L, 256L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(2000), Materials.Ethylene.getGas(1000)}).fo(new FluidStack[]{Materials.Tetrafluoroethylene.getGas(3000)}).add("ethylene_to_tetrafluoroethylene", 180L, 180L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1)}).fi(new FluidStack[]{Materials.LPG.getLiquid(432), Materials.Chlorine.getGas(1000)}).fo(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(432)}).add("epichlorohydrin", 480L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Naphtha.getLiquid(3000), Materials.NitrogenDioxide.getGas(1000), Materials.Epichlorohydrin.getLiquid(144)}).fo(new FluidStack[]{Materials.EpoxyResin.getLiquid(288)}).add("epoxy_resin", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Propene.getGas(1000), Materials.Benzene.getLiquid(1000), Materials.Chlorine.getGas(500)}).fo(new FluidStack[]{Materials.EpoxyResin.getLiquid(288)}).add("epoxy_resin_1", 120L, 240L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42501_, (int)9), RecipeIngredient.of((ItemStack)GTMaterialTypes.DUST.get(Materials.Plastic, 1))}).fi(new FluidStack[]{Materials.Toluene.getLiquid(1200)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.GelledToluene, 18)}).add("gelled_toluene", 560L, 192L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.GelledToluene), (int)4)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(250)}).io(new Item[]{Items.f_41996_}).add("tnt", 200L, 24L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1), RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Calcium), (int)1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(3000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Calcite, 5)}).add("calcite", 500L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Quicklime), (int)2)}).fi(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Calcite, 5)}).add("calcite_1", 80L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 1)}).fi(new FluidStack[]{Materials.Hydrogen.getGas(4000)}).fo(new FluidStack[]{Materials.Methane.getGas(5000)}).add("methane", 3500L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Glycerol.getLiquid(2800), Materials.NitricAcid.getLiquid(3000), Materials.SulfuricAcid.getLiquid(4200)}).fo(new FluidStack[]{Materials.GlycerylTrinitrate.getLiquid(4000), Materials.SulfurDioxide.getGas(1200)}).add("glyceryl_trinitrate", 180L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Diesel.getLiquid(4000), Materials.GlycerylTrinitrate.getLiquid(1000)}).fo(new FluidStack[]{Materials.NitroDiesel.getLiquid(5000)}).add("nitro_diesel_1", 80L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SeedOil.getLiquid(100000), Materials.Ethanol.getLiquid(10000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(100000), Materials.Glycerol.getLiquid(10000)}).add("biodiesel_from_ethanol", 1200L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.FishOil.getLiquid(100000), Materials.Ethanol.getLiquid(10000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(100000), Materials.Glycerol.getLiquid(10000)}).add("biodiesel_from_ethanol_2", 1200L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1), RecipeIngredient.of((ItemLike)GTMaterialTypes.DUST.get(Materials.RawRubber), (int)9)}).fo(new FluidStack[]{Materials.Rubber.getLiquid(1296)}).add("rubber", 200L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Air.getGas(14000), Materials.Isoprene.getLiquid(2000)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.DUST.get(Materials.RawRubber), 21)}).add("raw_rubber_dust", 2240L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.Isoprene.getLiquid(288)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.DUST.get(Materials.RawRubber), 3)}).add("raw_rubber_dust_2", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Propene.getGas(3000), Materials.Ethylene.getGas(2000)}).fo(new FluidStack[]{Materials.Isoprene.getLiquid(5000)}).add("isopropene", 120L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(2000), Materials.Ethanol.getLiquid(3000)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Sulfur, 6)}).fo(new FluidStack[]{Materials.Ethylene.getGas(2000), Materials.Water.getLiquid(1500)}).add("ethylene_2", 400L, 120L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Potassium), (int)1)}).fi(new FluidStack[]{Materials.Nitrogen.getGas(1000), Materials.Oxygen.getGas(3000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Saltpeter, 5)}).add("saltpeter", 180L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.NitrogenMonoxide.getGas(2000), Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.NitrogenDioxide.getGas(3000)}).add("nitrogen_dioxide", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.NitrogenDioxide.getGas(9000), Materials.Water.getLiquid(3000)}).fo(new FluidStack[]{Materials.NitricAcid.getLiquid(10000), Materials.NitrogenMonoxide.getGas(2000)}).add("nitric_acid", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RTags.DUST_SIO, (int)3), GTMaterialTypes.DUST.getMaterialIngredient(Materials.CalciumSulfate, 6)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Wollastonite, 5)}).fo(new FluidStack[]{Materials.SulfurTrioxide.getGas(4000)}).add("wollastonite", 144L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(3000), Materials.SulfurTrioxide.getGas(4000)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).add("sulfuric_acid_", 320L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.SulfurDioxide.getGas(3000)}).fo(new FluidStack[]{Materials.SulfurTrioxide.getGas(4000)}).add("sulfur_trioxide", 200L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sulfur, 1)}).fo(new FluidStack[]{Materials.SulfurDioxide.getGas(3000)}).add("sulfur_dioxide", 60L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(3000), Materials.Chlorine.getGas(2000)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000), Materials.Oxygen.getGas(1000)}).add("hydrochloric_acid", 60L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.DistilledWater.getLiquid(3000), Materials.Chlorine.getGas(2000)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000), Materials.Oxygen.getGas(1000)}).add("hydrochloric_acid_2", 60L, 8L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sylvite, 2)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(2000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.PotassiumBisulfate, 7)}).add("hydrochloric_acid_3", 144L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Salt, 2)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(2000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.SodiumBisulfate, 7)}).add("hydrochloric_acid_4", 144L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Rutile), (int)1), RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1)}).fi(new FluidStack[]{Materials.Chlorine.getGas(4000), Materials.Calcite.getLiquid(144)}).fo(new FluidStack[]{Materials.TitaniumTetrachloride.getLiquid(5000), Materials.CarbonDioxide.getGas(3000)}).add("titanium_tetrachloride", 500L, 480L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Ilmenite), (int)5), RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)3)}).fi(new FluidStack[]{Materials.Chlorine.getGas(7000), Materials.Calcite.getLiquid(144)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.FerricChloride, 4)}).fo(new FluidStack[]{Materials.TitaniumTetrachloride.getLiquid(5000), Materials.CarbonMonoxide.getGas(6000)}).add("titanium_tetrachloride_2", 500L, 480L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.MagnesiumCarbonate, 5)}).fi(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.MagnesiumChloride, 3)}).fo(new FluidStack[]{Materials.Water.getLiquid(3000), Materials.CarbonDioxide.getGas(3000)}).add("magnesium_chloride", 144L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Fluorite, 3)}).fo(new FluidStack[]{Materials.HydrogenFluoride.getGas(4000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.CalciumSulfate, 6)}).add("hydrogen_fluoride", 160L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(1000), Materials.Hydrogen.getGas(1000)}).fo(new FluidStack[]{Materials.HydrogenFluoride.getGas(2000)}).add("hydrogen_fluoride_1", 16L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(2000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Calcium, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Fluorite, 3)}).add("fluorite", 48L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HydrogenFluoride.getGas(4000)}).ii(new Ingredient[]{RecipeIngredient.m_204132_(GT5RTags.DUST_SIO)}).fo(new FluidStack[]{Materials.Water.getLiquid(2000), Materials.HexafluorosilicicAcid.getLiquid(3000)}).add("hexafluorosilicic_acid", 80L, 16L);
        if (GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HexafluorosilicicAcid.getLiquid(9000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 5)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.SiliconDioxide, 3)}).fo(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(1152), Materials.Water.getLiquid(3000)}).add("aluminium_fluoride", 224L, 16L);
            RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(3000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Aluminium, 1)}).fo(new FluidStack[]{Materials.AluminiumFluoride.getLiquid(576)}).add("aluminium_fluoride_pure", 64L, 16L);
            RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HydrogenFluoride.getGas(24000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumHydroxide, 18), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 5)}).fo(new FluidStack[]{Materials.Cryolite.getLiquid(2880), Materials.Water.getLiquid(27000)}).add("cryolite", 752L, 16L);
        }
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(2000), Materials.NitricAcid.getLiquid(1250)}).fo(new FluidStack[]{Materials.AquaRegia.getLiquid(3250)}).add("aqua_regia", 16L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(6000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.TungstenTrioxide, 4)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Tungsten)}).fo(new FluidStack[]{Materials.Water.getLiquid(9000)}).add("tungsten", 160L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Saltpeter, 5)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.PotassiumBisulfate, 7)}).fo(new FluidStack[]{Materials.NitricAcid.getLiquid(5000)}).add("potassium_bisulfate", 192L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.NUGGET.getMaterialTag(Materials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_})}).io(new Item[]{Items.f_42546_}).add("glistering_melon_slice", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(Materials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_})}).io(new Item[]{Items.f_42436_}).add("golden_apple", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_})}).io(new Item[]{Items.f_42542_}).add("magma_cream", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_})}).io(new Item[]{Items.f_42545_}).add("ender_eye", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.NUGGET.getMaterialTag(Materials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_})}).io(new Item[]{Items.f_42677_}).add("golden_carrot", 50L, 30L);
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.m_41065_() + "_dye";
            Material chemDye = Material.get((String)("chemical_" + dyeName));
            RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)color.getTag()), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Salt, 2)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(432)}).fo(new FluidStack[]{chemDye.getLiquid(288)}).add(chemDye.getId(), 600L, 48L);
        }
    }

    private static void addComplicated() {
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(1000), Materials.HydrogenSulfide.getGas(1000)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(1500)}).add("sulfuric_acid_1", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.HydrogenSulfide.getGas(1000)}).fo(new FluidStack[]{Materials.SulfurDioxide.getGas(1000), Materials.Water.getLiquid(1000)}).add("sulfur_dioxide_1", 40L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Ethylene.getGas(1000), Materials.AceticAcid.getLiquid(2000), Materials.Methanol.getLiquid(1000)}).fo(new FluidStack[]{Materials.Glue.getLiquid(4000)}).add("glue", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.SeedOil.getLiquid(100000), Materials.Methanol.getLiquid(10000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(105000), Materials.Glycerol.getLiquid(5000)}).add("biodiesel_from_methanol", 1200L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.FishOil.getLiquid(100000), Materials.Methanol.getLiquid(10000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(105000), Materials.Glycerol.getLiquid(5000)}).add("biodiesel_from_methanol_2", 1200L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)9)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ethylene.getGas(3000)}).fo(new FluidStack[]{Materials.AceticAcid.getLiquid(4000)}).add("acetic_acid", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.CarbonMonoxide.getGas(1000), Materials.Methanol.getLiquid(3000)}).fo(new FluidStack[]{Materials.AceticAcid.getLiquid(4000)}).add("acetic_acid_1", 150L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.CarbonMonoxide.getGas(1000), Materials.Hydrogen.getGas(1000)}).fo(new FluidStack[]{Materials.AceticAcid.getLiquid(2000)}).add("acetic_acid_2", 80L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(2000), Materials.CarbonDioxide.getGas(1000)}).fo(new FluidStack[]{Materials.Methanol.getLiquid(2000), Materials.Water.getLiquid(1000)}).add("methanol", 200L, 120L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Benzene.getLiquid(2000), Materials.Ethylene.getGas(1000)}).fo(new FluidStack[]{Materials.Styrene.getLiquid(3000)}).add("ethylene_to_styrene", 120L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Butadiene.getGas(3000), Materials.Oxygen.getGas(4000), Materials.Styrene.getLiquid(1000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.RawStyreneButadieneRubber, 6)}).add("raw_styrene_butadiene_rubber_pulp", 160L, 240L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.RawStyreneButadieneRubber), (int)9), RecipeIngredient.of((ItemLike)GTMaterialTypes.DUST.get(Materials.Sulfur), (int)1)}).fo(new FluidStack[]{Materials.StyreneButadieneRubber.getLiquid(1296)}).add("styrenebutadiene_rubber", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Methane.getGas(2000), Materials.Chlorine.getGas(1000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Polydimethylsiloxane, 3)}).add("polydimethylsiloxane_pulp", 240L, 120L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Polydimethylsiloxane), (int)9), RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).fo(new FluidStack[]{Materials.SiliconeRubber.getLiquid(1296)}).add("silcone_rubber", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Silicon), (int)1)}).fi(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(144)}).fo(new FluidStack[]{Materials.SiliconeRubber.getLiquid(144)}).add("silcone_rubber_1", 240L, 96L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(3000), Materials.Nitrogen.getGas(1000)}).fo(new FluidStack[]{Materials.Ammonia.getGas(1000)}).add("ammonia", 320L, 384L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ammonia.getGas(1000)}).fo(new FluidStack[]{Materials.NitricAcid.getLiquid(1000), Materials.Water.getLiquid(1000)}).add("nitric_acid_2", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Calcite, 5)}).fi(new FluidStack[]{Materials.AceticAcid.getLiquid(8000)}).fo(new FluidStack[]{Materials.Acetone.getLiquid(5000), Materials.CarbonDioxide.getGas(3000)}).add("acetone", 400L, 480L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Quicklime, 5)}).fi(new FluidStack[]{Materials.AceticAcid.getLiquid(8000)}).fo(new FluidStack[]{Materials.Acetone.getLiquid(5000), Materials.CarbonDioxide.getGas(3000)}).add("acetone_1", 400L, 480L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Methanol.getLiquid(6000), Materials.AceticAcid.getLiquid(8000)}).fo(new FluidStack[]{Materials.MethylAcetate.getLiquid(11000), Materials.Water.getLiquid(3000)}).add("methyl_acetate", 240L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(500), Materials.Ethylene.getGas(3000), Materials.AceticAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.VinylAcetate.getLiquid(6000)}).add("vinyl_acetate", 90L, 30L, -1L);
        ChemicalReactorLoader.addPolymerRecipe(Materials.VinylAcetate, Materials.PolyvinylAcetate);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Methane.getGas(6000), Materials.Chlorine.getGas(5000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)13)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(6000), Materials.Chloroform.getLiquid(5000)}).add("hydrochloric_acid_1", 16L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(1000), Materials.Benzene.getLiquid(6000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).fo(new FluidStack[]{Materials.Chlorobenzene.getLiquid(6000), Materials.HydrochloricAcid.getLiquid(1000)}).add("chlorobenzene", 120L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(1000), Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(1000), Materials.HypochlorousAcid.getLiquid(1000)}).add("hypochlorous_acid", 60L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.AllylChloride.getLiquid(3000), Materials.HypochlorousAcid.getLiquid(1000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumHydroxide, 1)}).fo(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(4000), Materials.SaltWater.getLiquid(1000)}).add("complicated_elpichlorohydrin", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Glycerol.getLiquid(7000), Materials.HydrochloricAcid.getLiquid(1000)}).fo(new FluidStack[]{Materials.Water.getLiquid(3000), Materials.Epichlorohydrin.getLiquid(5000)}).add("complicated_epichlorohydrin_1", 240L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.LPG.getLiquid(432), Materials.Chlorine.getGas(1000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 1)}).fo(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(432)}).add("complicated_epichlorohydrin_2", 480L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(9000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.PhosphorousPentoxide, 7)}).fo(new FluidStack[]{Materials.PhosphoricAcid.getLiquid(16000)}).add("phosphoric_acid", 120L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(4000), Materials.Oxygen.getGas(2500)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.TricalciumPhosphate, 1)}).fo(new FluidStack[]{Materials.PhosphoricAcid.getLiquid(8000)}).add("phosphoric_acid_1", 320L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Benzene.getLiquid(8000), Materials.Propene.getGas(6000), Materials.PhosphoricAcid.getLiquid(1000)}).fo(new FluidStack[]{Materials.Cumene.getLiquid(14000)}).add("cumene", 360L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.Cumene.getLiquid(11000)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(6000), Materials.Acetone.getLiquid(6000)}).add("phenol", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Water.getLiquid(3000), Materials.Chlorine.getGas(2000), Materials.Benzene.getLiquid(12000)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(13000), Materials.HydrochloricAcid.getLiquid(2000), Materials.DilutedHydrochloricAcid.getLiquid(2000)}).add("phenol_1", 560L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorobenzene.getLiquid(12000), Materials.Water.getLiquid(3000)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(13000), Materials.DilutedHydrochloricAcid.getLiquid(2000)}).add("phenol_2", 240L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.PhosphoricAcid.getLiquid(1000), Materials.Benzene.getLiquid(12000), Materials.Propene.getGas(9000)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(13000), Materials.Acetone.getLiquid(10000)}).add("phenol_3", 480L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(2000), Materials.Benzene.getLiquid(12000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumHydroxide, 1)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(13000), Materials.HydrochloricAcid.getLiquid(2000)}).add("phenol_4", 560L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorobenzene.getLiquid(4000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumHydroxide, 1)}).fo(new FluidStack[]{Materials.Phenol.getLiquid(4000)}).add("phenol_5", 960L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Acetone.getLiquid(1000), Materials.Phenol.getLiquid(2000)}).fo(new FluidStack[]{Materials.BisphenolA.getLiquid(3000)}).add("bisphenol_a", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.BisphenolA.getLiquid(12000), Materials.Epichlorohydrin.getLiquid(4000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumHydroxide, 1)}).fo(new FluidStack[]{Materials.EpoxyResin.getLiquid(16000), Materials.SaltWater.getLiquid(1000)}).add("complicated_epoxy_resin", 200L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(2000), Materials.Methane.getGas(5000)}).ii(new Ingredient[]{(Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).fo(new FluidStack[]{Materials.Chloromethane.getGas(5000), Materials.HydrochloricAcid.getLiquid(2000)}).add("chloromethane", 80L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Methanol.getLiquid(6000), Materials.HydrochloricAcid.getLiquid(2000)}).fo(new FluidStack[]{Materials.Chloromethane.getGas(5000), Materials.Water.getLiquid(3000)}).add("chloromethane_1", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Propene.getGas(9000), Materials.Chlorine.getGas(2000)}).fo(new FluidStack[]{Materials.AllylChloride.getLiquid(9000), Materials.HydrochloricAcid.getLiquid(2000)}).add("hydrochloric_acid_5", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HydrogenFluoride.getGas(1000), Materials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(2000)}).add("hydrofluoric_acid", 60L, 8L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chloroform.getLiquid(5000), Materials.HydrofluoricAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.Tetrafluoroethylene.getGas(3000), Materials.DilutedHydrochloricAcid.getLiquid(6000)}).add("tetrafluoroethylene", 480L, 240L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(6000), Materials.Methane.getGas(5000), Materials.HydrofluoricAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.Tetrafluoroethylene.getGas(6000), Materials.HydrochloricAcid.getLiquid(6000), Materials.DilutedHydrochloricAcid.getLiquid(6000)}).add("tetrafluoroethylene_1", 540L, 240L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Chloromethane.getGas(10000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Silicon, 1)}).fo(new FluidStack[]{Materials.Dimethyldichlorosilane.getLiquid(11000)}).add("dimethyldichlorosilane", 240L, 96L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Dimethyldichlorosilane.getLiquid(11000), Materials.Water.getLiquid(3000)}).fo(new FluidStack[]{Materials.DilutedHydrochloricAcid.getLiquid(4000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Polydimethylsiloxane, 10)}).add("polydimethylsiloxane", 240L, 96L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000), Materials.Methanol.getLiquid(12000)}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Silicon, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Polydimethylsiloxane, 10)}).fo(new FluidStack[]{Materials.DilutedHydrochloricAcid.getLiquid(4000)}).add("polydimethylsiloxane_2", 480L, 96L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Ammonia.getGas(8000), Materials.Oxygen.getGas(5000)}).fo(new FluidStack[]{Materials.NitrogenMonoxide.getGas(4000), Materials.Water.getLiquid(9000)}).add("nitrogen_monoxide", 160L, 30L, -1L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(125), Materials.NaturalGas.getGas(2000)}).fo(new FluidStack[]{Materials.RefineryGas.getGas(2000), Materials.HydrogenSulfide.getGas(125)}).add("refinery_gas", 20L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(125), Materials.SulfuricGas.getGas(1000)}).fo(new FluidStack[]{Materials.RefineryGas.getGas(1000), Materials.HydrogenSulfide.getGas(125)}).add("refinery_gas_1", 20L, 30L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(250), Materials.SulfuricNaphtha.getLiquid(3000)}).fo(new FluidStack[]{Materials.Naphtha.getLiquid(3000), Materials.HydrogenSulfide.getGas(250)}).add("naphtha", 40L, 30L);
    }

    private static void addPolymerRecipe(Material in, Material out) {
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{in.getLiquid(144), Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{out.getLiquid(216)}).add(in.getId() + "_polymer_to_" + out.getId(), 160L, 30L);
    }

    private static void nuclearProcessing() {
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Uraninite, 1)}).fi(new FluidStack[]{Materials.HydrogenFluoride.getGas(8000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.UraniumTetrafluoride, 5)}).fo(new FluidStack[]{Materials.Water.getLiquid(6000)}).add("uranium_tetrafluoride", 186L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.UraniumTetrafluoride, 1)}).fi(new FluidStack[]{Materials.Fluorine.getGas(400)}).fo(new FluidStack[]{Materials.UraniumHexafluoride.getGas(1400)}).add("uranium_hexafluoride", 22L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Uranium238Hexafluoride.getGas(1400), Materials.Hydrogen.getGas(400)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Uranium238Tetrafluoride)}).fo(new FluidStack[]{Materials.HydrogenFluoride.getGas(800)}).add("uranium_238_tetrafluoride", 28L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().fi(new FluidStack[]{Materials.Uranium235Hexafluoride.getGas(1400), Materials.Hydrogen.getGas(400)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Uranium235Tetrafluoride)}).fo(new FluidStack[]{Materials.HydrogenFluoride.getGas(800)}).add("uranium_235_tetrafluoride", 28L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Uranium235Tetrafluoride, 5), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Calcium, 2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Uranium235, 1), GTMaterialTypes.DUST.get(Materials.Fluorite, 6)}).add("uranium_235_tetrafluoride_to_uranium_235", 108L, 16L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Uranium238Tetrafluoride, 5), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Calcium, 2)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Uranium, 1), GTMaterialTypes.DUST.get(Materials.Fluorite, 6)}).add("uranium_238_tetrafluoride_to_uranium_238", 108L, 16L);
    }
}

