/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.items;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.GT5RMaterialTypes;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.data.RecipeBuilders;
import org.gtreimagined.gtlib.data.ForgeTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.SubTag;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.TagUtils;

public class Circuitry {
    public static void loadCraftingRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.addStackRecipe(output, "gt5r", "", "board_basic", new ItemStack(GT5RItems.CircuitBoardCoated, 3), ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)GTCoreItems.StickyResin).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Wood)).build(), new String[]{" R ", "PPP", " R "});
        if (GT5RConfig.HARDER_CIRCUITS) {
            Circuitry.bloodyCircuits(output, provider);
        } else {
            Circuitry.circuits(output, provider);
        }
    }

    private static void bloodyCircuits(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.addItemRecipe(output, "circuit_basic", GT5RItems.BasicCircuit, ImmutableMap.builder().put((Object)Character.valueOf('V'), GT5RItems.VacuumTube).put((Object)Character.valueOf('B'), GT5RItems.CircuitBoardCoated).put((Object)Character.valueOf('W'), (Object)GTCoreCables.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('R'), GT5RItems.Resistor).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.ITEM_CASING.get(Materials.Steel)).build(), new String[]{"RPR", "VBV", "WWW"});
        provider.addItemRecipe(output, "circuits", GT5RItems.GoodCircuit, ImmutableMap.builder().put((Object)Character.valueOf('S'), (Object)GTMaterialTypes.ITEM_CASING.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_BASIC).put((Object)Character.valueOf('c'), (Object)GTCoreCables.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('D'), GT5RItems.Diode).build(), new String[]{"SCc", "CDC", "cCS"});
        TagKey wire = TagUtils.getItemTag((ResourceLocation)new ResourceLocation("gtlib", SubTag.COPPER_WIRE.getId() + "_" + PipeSize.VTINY.getId()));
        provider.addItemRecipe(output, "vac_tube", GT5RItems.VacuumTube, ImmutableMap.builder().put((Object)Character.valueOf('G'), GT5RItems.GlassTube).put((Object)Character.valueOf('P'), (Object)Items.f_42516_).put((Object)Character.valueOf('W'), (Object)wire).build(), new String[]{"PGP", "WWW"});
        provider.addItemRecipe(output, "gt5r", "vacuum_tube_1", "vac_tube", GT5RItems.VacuumTube, ImmutableMap.builder().put((Object)Character.valueOf('G'), GT5RItems.GlassTube).put((Object)Character.valueOf('P'), (Object)Items.f_42516_).put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Copper)).build(), new String[]{"PGP", "WWW"});
        provider.addItemRecipe(output, "resistor", GT5RItems.Resistor, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)GTCoreTags.DUST_COALS).put((Object)Character.valueOf('P'), (Object)Items.f_42516_).put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Copper)).build(), new String[]{" P ", "WCW", " P "});
        provider.addItemRecipe(output, "gt5r", "", "diodes", GT5RItems.Diode, ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)ForgeTags.DYES_BLACK).put((Object)Character.valueOf('T'), (Object)GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), GT5RItems.Wafer).put((Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES).build(), new String[]{"BG ", "TWT", "BG "});
        provider.addItemRecipe(output, "gt5r", "diode_2", "diodes", GT5RItems.Diode, ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)ForgeTags.DYES_BLACK).put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Tin)).put((Object)Character.valueOf('W'), GT5RItems.Wafer).put((Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES).build(), new String[]{"BG ", "TWT", "BG "});
        provider.addStackRecipe(output, "gt5r", "diode_3", "diodes", new ItemStack(GT5RItems.Diode), ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)ForgeTags.DYES_BLACK).put((Object)Character.valueOf('T'), (Object)GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.TINY_DUST.getMaterialTag(Materials.Gallium)).put((Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES).build(), new String[]{"BG ", "TWT", "BG "});
        provider.addStackRecipe(output, "gt5r", "diode_4", "diodes", new ItemStack(GT5RItems.Diode), ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)ForgeTags.DYES_BLACK).put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Tin)).put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.TINY_DUST.getMaterialTag(Materials.Gallium)).put((Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES).build(), new String[]{"BG ", "TWT", "BG "});
        provider.addStackRecipe(output, "gt5r", "", "small_coils", new ItemStack(GT5RItems.SmallCoil, 2), ImmutableMap.of((Object)Character.valueOf('W'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('B'), (Object)GTMaterialTypes.BOLT.getMaterialTag(Materials.Steel)), new String[]{"WWW", "WBW", "WWW"});
        provider.addStackRecipe(output, "gt5r", "small_coil_1", "small_coils", new ItemStack(GT5RItems.SmallCoil, 4), ImmutableMap.of((Object)Character.valueOf('W'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('B'), (Object)GTMaterialTypes.BOLT.getMaterialTag(Materials.NickelZincFerrite)), new String[]{"WWW", "WBW", "WWW"});
    }

    private static void circuits(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.addItemRecipe(output, "circuits", GT5RItems.BasicCircuit, ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTMaterialTypes.FINE_WIRE.getMaterialTag(Materials.Tin), (Object)Character.valueOf('C'), GT5RItems.BasicCircuitBoard), new String[]{"SSS", "SCS", "SSS"});
        provider.addItemRecipe(output, "gt5r", "basic_circuit_board", "circuits", GT5RItems.BasicCircuitBoard, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)).put((Object)Character.valueOf('N'), GT5RItems.BasicCircuitParts).put((Object)Character.valueOf('S'), GT5RItems.CircuitBoardCoated).build(), new String[]{"CNC", "NSN", "CNC"});
        provider.addItemRecipe(output, "gt5r", "", "circuits", GT5RItems.BasicCircuitParts, ImmutableMap.of((Object)Character.valueOf('C'), (Object)GTMaterialTypes.ITEM_CASING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('R'), (Object)GTCoreCables.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (Object)Character.valueOf('T'), (Object)GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.VTINY)), new String[]{"CR", "RT"});
    }

    public static void init() {
        Circuitry.silicon();
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 1), RecipeIngredient.of((ItemLike)GTCoreItems.MoldPlate, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Glue.getLiquid(100)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardPhenolic, 8)}).add("phenolic_circuit_board", 30L, 8L);
        if (!GT5RConfig.HARDER_CIRCUITS) {
            Circuitry.boards();
            Circuitry.circuitParts();
            Circuitry.circuits();
        } else {
            Circuitry.bloodyBoards();
            Circuitry.bloodyCircuitParts();
            Circuitry.bloodyCircuits();
        }
    }

    private static void silicon() {
        Circuitry.addCuttingRecipe(GT5RMaterialTypes.BOULE.get(Materials.Silicon), GT5RItems.Wafer, 16, 1600, 384, 1);
        Circuitry.addCuttingRecipe(GT5RItems.Wafer, GT5RItems.SiliconChip, 8, 600, 48, 22);
        if (GT5RConfig.HARDER_CIRCUITS) {
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(2484).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Silicon, 16), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Glowstone, 1)}).fi(new FluidStack[]{Materials.Nitrogen.getGas(1000)}).io(new Item[]{GT5RItems.GlowstoneDopedSiliconBoule}).add("glowstone_doped_silicon_boule", 12000L, 480L);
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(2484).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Silicon, 16), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Naquadah, 1)}).fi(new FluidStack[]{Materials.Argon.getGas(1000)}).io(new Item[]{GT5RItems.NaquadahDopedSiliconBoule}).add("naquadah_doped_silicon_boule", 15000L, 1920L);
            Circuitry.addCuttingRecipe(GT5RItems.GlowstoneDopedSiliconBoule, GT5RItems.GlowstoneDopedWafer, 32, 800, 64, 20);
            Circuitry.addCuttingRecipe(GT5RItems.NaquadahDopedSiliconBoule, GT5RItems.NaquadahDopedWafer, 64, 1600, 64, 240);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.ASoCWafer, 1, 200, 1920, Materials.Amber, Materials.Topaz);
            Circuitry.addCuttingRecipe(GT5RItems.ASoCWafer, GT5RItems.ASoC, 8, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.Wafer, GT5RItems.CentralProcessingUnitWafer, 1, 900, 120, Materials.Diamond, Materials.Glass);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.CentralProcessingUnitWafer, 4, 500, 480, Materials.Diamond, Materials.Glass);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.CentralProcessingUnitWafer, 8, 200, 1920, Materials.Diamond, Materials.Glass);
            Circuitry.addCuttingRecipe(GT5RItems.CentralProcessingUnitWafer, GT5RItems.CentralProcessingUnit, 8, 600, 48, 22);
            RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.PICWafer}), GTMaterialTypes.DUST.getMaterialIngredient(Materials.IndiumGalliumPhosphide, 2)}).fi(new FluidStack[]{Materials.RedAlloy.getLiquid(288)}).io(new Item[]{GT5RItems.HPICWafer}).add("hpic_wafer", 1200L, 1920L);
            Circuitry.addCuttingRecipe(GT5RItems.HPICWafer, GT5RItems.HighPowerIC, 2, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.Wafer, GT5RItems.IntegratedLogicCircuitWafer, 1, 900, 120, Materials.Ruby, Materials.RedGarnet, Materials.Jade);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.IntegratedLogicCircuitWafer, 4, 500, 480, Materials.Ruby, Materials.RedGarnet, Materials.Jade);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.IntegratedLogicCircuitWafer, 8, 200, 1920, Materials.Ruby, Materials.RedGarnet, Materials.Jade);
            Circuitry.addCuttingRecipe(GT5RItems.IntegratedLogicCircuitWafer, GT5RItems.IntegratedLogicCircuit, 8, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.NANDMemoryChipWafer, 1, 500, 480, Materials.EnderPearl);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.NANDMemoryChipWafer, 4, 200, 1920, Materials.EnderPearl);
            Circuitry.addCuttingRecipe(GT5RItems.NANDMemoryChipWafer, GT5RItems.NANDMemoryChip, 32, 600, 48, 22);
            RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CentralProcessingUnitWafer}), RecipeIngredient.of((ItemLike)GTCoreItems.CarbonFibre, (int)16)}).fi(new FluidStack[]{Materials.Glowstone.getLiquid(576)}).io(new Item[]{GT5RItems.NanoCpuWafer}).add("nano_cpu_wafer", 400L, 1920L);
            Circuitry.addCuttingRecipe(GT5RItems.NanoCpuWafer, GT5RItems.NanoCpu, 7, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.NorMemoryChipWafer, 1, 500, 480, Materials.EnderEye);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.NorMemoryChipWafer, 4, 200, 1920, Materials.EnderEye);
            Circuitry.addCuttingRecipe(GT5RItems.NorMemoryChipWafer, GT5RItems.NorMemoryChip, 16, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.PICWafer, 1, 500, 480, Materials.Opal, Materials.Sapphire, Materials.BlueTopaz);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.PICWafer, 4, 200, 1920, Materials.Opal, Materials.Sapphire, Materials.BlueTopaz);
            Circuitry.addCuttingRecipe(GT5RItems.PICWafer, GT5RItems.PowerIC, 4, 600, 48, 22);
            RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.NanoCpuWafer}), RecipeIngredient.of(GT5RItems.QuantumEye, (int)2)}).fi(new FluidStack[]{Materials.GalliumArsenide.getLiquid(288)}).io(new Item[]{GT5RItems.QBitWafer}).add("qbit_wafer", 400L, 1920L);
            RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.NanoCpuWafer}), GTMaterialTypes.DUST.getMaterialIngredient(Materials.IndiumGalliumPhosphide, 1)}).fi(new FluidStack[]{Materials.Radon.getGas(50)}).io(new Item[]{GT5RItems.QBitWafer}).add("qbit_wafer_2", 600L, 1920L);
            Circuitry.addCuttingRecipe(GT5RItems.QBitWafer, GT5RItems.QBitProcessingUnit, 5, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.Wafer, GT5RItems.RandomAccessMemoryChipWafer, 1, 900, 120, Materials.GreenSapphire);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.RandomAccessMemoryChipWafer, 4, 500, 480, Materials.GreenSapphire);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.RandomAccessMemoryChipWafer, 8, 200, 1920, Materials.GreenSapphire);
            Circuitry.addCuttingRecipe(GT5RItems.RandomAccessMemoryChipWafer, GT5RItems.RandomAccessMemoryChip, 32, 600, 48, 22);
            Circuitry.addLensRecipe(GT5RItems.GlowstoneDopedWafer, GT5RItems.SOCWafer, 1, 500, 480, Materials.YellowGarnet);
            Circuitry.addLensRecipe(GT5RItems.NaquadahDopedWafer, GT5RItems.SOCWafer, 4, 200, 1920, Materials.YellowGarnet);
            Circuitry.addCuttingRecipe(GT5RItems.SOCWafer, GT5RItems.SOC, 10, 600, 48, 22);
        }
    }

    private static void addLensRecipe(ItemBasic<?> input, ItemBasic<?> output, int count, int ticks, int power, Material ... lenses) {
        String extra = input.getId().replace("doped_", "").replace("wafer", "");
        for (Material lens : lenses) {
            RecipeMaps.LASER_ENGRAVER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{input}), GTMaterialTypes.LENS.getMaterialIngredient(lens, 1).setNoConsume()}).io(new ItemStack[]{new ItemStack(output, count)}).add(output.getId() + "_" + extra + lens.getId(), (long)ticks, (long)power);
        }
    }

    private static void addCuttingRecipe(Item input, ItemBasic<?> output, int amount, int ticks, int power, int liquidMultiplier) {
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{new FluidStack((Fluid)Fluids.f_76193_, 5 * liquidMultiplier)}).io(new ItemStack[]{new ItemStack(output, amount)}).add(output.getId() + "_with_water", (long)ticks, (long)power);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(3 * liquidMultiplier)}).io(new ItemStack[]{new ItemStack(output, amount)}).add(output.getId() + "_with_distilled_water", (long)ticks, (long)power);
        RecipeMaps.CUTTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(liquidMultiplier)}).io(new ItemStack[]{new ItemStack(output, amount)}).add(output.getId() + "_with_lubricant", (long)(ticks / 2), (long)power);
    }

    private static void circuitParts() {
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Germanium, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Tin, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.BasicCircuitParts)}).add("basic_circuit_parts_germanium", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Silicon, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Tin, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.BasicCircuitParts)}).add("basic_circuit_parts_silicon", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.ITEM_CASING.getMaterialIngredient(Materials.Steel, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Tin, 2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.BasicCircuitParts)}).add("basic_circuit_parts_steel", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Silicon, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 1)}).io(new Item[]{GT5RItems.GoodCircuitParts}).add("good_circuit_parts_silicon", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Germanium, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 1)}).io(new Item[]{GT5RItems.GoodCircuitParts}).add("good_circuit_parts_germanium", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Silicon, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Signalum, 1)}).io(new Item[]{GT5RItems.AdvancedCircuitParts}).add("advanced_circuit_parts", 32L, 64L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Niobium, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Platinum, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Signalum, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.ComplexCircuitParts)}).add("complex_circuit_parts", 32L, 256L);
    }

    private static void boards() {
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Plastic, 1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Silicon, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.EmptyCircuitPlate)}).add("empty_circuit_plate_silicon", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Plastic, 1), RecipeIngredient.of(GT5RTags.DUST_SIO, (int)1)}).io(new ItemStack[]{new ItemStack(GT5RItems.EmptyCircuitPlate)}).add("empty_circuit_plate", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EmptyCircuitPlate}), RecipeIngredient.of(GT5RItems.CopperEtchedWiring, (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.CopperCircuitPlate)}).add("copper_circuit_plate", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EmptyCircuitPlate}), RecipeIngredient.of(GT5RItems.GoldEtchedWiring, (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.GoldCircuitPlate)}).add("gold_circuit_plate", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EmptyCircuitPlate}), RecipeIngredient.of(GT5RItems.PlatinumEtchedWiring, (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.PlatinumCircuitPlate)}).add("platinum_circuit_plate", 32L, 64L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CopperCircuitPlate, (int)1), RecipeIngredient.of(GT5RItems.BasicCircuitParts, (int)4)}).io(new Item[]{GT5RItems.BasicCircuitBoard}).add("basic_circuit_board", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CopperCircuitPlate, (int)1), RecipeIngredient.of(GT5RItems.GoodCircuitParts, (int)4)}).io(new Item[]{GT5RItems.GoodCircuitBoard}).add("good_circuit_board", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.GoldCircuitPlate, (int)1), RecipeIngredient.of(GT5RItems.AdvancedCircuitParts, (int)4)}).io(new Item[]{GT5RItems.AdvancedCircuitBoard}).add("advanced_circuit_board", 32L, 16L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.PlatinumCircuitPlate, (int)1), RecipeIngredient.of(GT5RItems.ComplexCircuitParts, (int)4)}).io(new Item[]{GT5RItems.ComplexCircuitBoard}).add("complex_circuit_board", 32L, 64L);
        RecipeMaps.FORMING_PRESS.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EmptyProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.PlatinumEtchedWiring, (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.ProcessorCircuitBoard)}).add("processor_circuit_board", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.Wafer, (int)2), GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Polytetrafluoroethylene, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.EmptyProcessorCircuitBoard)}).add("empty_processor_circuit_board", 32L, 256L);
    }

    private static void circuits() {
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.BasicCircuitBoard})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new Item[]{GT5RItems.BasicCircuit}).add("basic_circuit", 64L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.GoodCircuitBoard})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new Item[]{GT5RItems.GoodCircuit}).add("good_circuit", 64L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.AdvancedCircuitBoard})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new Item[]{GT5RItems.AdvancedCircuit}).add("advanced_circuit", 64L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ComplexCircuitBoard})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new Item[]{GT5RItems.ComplexCircuit}).add("complex_circuit", 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.Tin.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataStorageCircuit)}).add("data_storage_circuit_tin", 32L, 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataStorageCircuit)}).add("data_storage__circuit_soldering_alloy", 32L, 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.Lead.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataStorageCircuit)}).add("data_storage_circuit_lead", 32L, 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.DataStorageCircuit, (int)3)}).fi(new FluidStack[]{Materials.Tin.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataControlCircuit)}).add("data_control_circuit_tin", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.DataStorageCircuit, (int)3)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataControlCircuit)}).add("data_control_circuit_soldering_alloy", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.DataStorageCircuit, (int)3)}).fi(new FluidStack[]{Materials.Lead.getLiquid(576)}).io(new ItemStack[]{new ItemStack(GT5RItems.DataControlCircuit)}).add("data_control_circuit_lead", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.Tin.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GT5RItems.EnergyFlowCircuit)}).add("energy_flow_circuit_tin", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.EnergyFlowCircuit)}).add("energy_flow_circuit_soldering_alloy", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ProcessorCircuitBoard}), RecipeIngredient.of(GT5RItems.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.Lead.getLiquid(576)}).io(new ItemStack[]{new ItemStack(GT5RItems.EnergyFlowCircuit)}).add("energy_flow_circuit_lead", 32L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.CIRCUITS_ELITE, (int)2), RecipeIngredient.of(GT5RItems.EngravedCrystalChip, (int)18)}).io(new Item[]{GT5RItems.DataOrb}).add("data_orb", 500L, 256L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.CIRCUITS_MASTER, (int)2), RecipeIngredient.of(GT5RItems.EngravedLapotronChip, (int)18)}).io(new Item[]{GT5RItems.BatteryEnergyOrb}).add("lapotronic_energy_orb", 500L, 1024L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Europium, 4), RecipeIngredient.of(GT5RItems.BatteryEnergyOrb, (int)8)}).io(new Item[]{GT5RItems.BatteryEnergyOrbCluster}).add("lapotronic_energy_orb_cluster", 2040L, 4096L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTCoreTags.CIRCUITS_ADVANCED), RecipeIngredient.of(GT5RItems.BasicCircuitParts, (int)2), RecipeIngredient.of(GT5RItems.AdvancedCircuitParts, (int)2)}).fi(new FluidStack[]{Materials.Lead.getLiquid(288)}).io(new Item[]{GT5RItems.DataStick}).add("data_stick_lead", 120L, 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTCoreTags.CIRCUITS_ADVANCED), RecipeIngredient.of(GT5RItems.BasicCircuitParts, (int)2), RecipeIngredient.of(GT5RItems.AdvancedCircuitParts, (int)2)}).fi(new FluidStack[]{Materials.Tin.getLiquid(144)}).io(new Item[]{GT5RItems.DataStick}).add("data_stick_tin", 120L, 64L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTCoreTags.CIRCUITS_ADVANCED), RecipeIngredient.of(GT5RItems.BasicCircuitParts, (int)2), RecipeIngredient.of(GT5RItems.AdvancedCircuitParts, (int)2)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new Item[]{GT5RItems.DataStick}).add("data_stick_soldering_alloy", 120L, 64L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 4)}).fi(new FluidStack[]{Materials.EpoxyResin.getLiquid(144)}).io(new Item[]{GT5RItems.CircuitBoardEpoxy}).add("epoxy_circuit_board", 500L, 10L);
    }

    private static void bloodyBoards() {
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Plastic, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardPlastic, 1)}).add("plastic_circuit_board", 500L, 10L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.PolyvinylChloride, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardPlastic, 2)}).add("plastic_circuit_board_2", 500L, 10L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Polytetrafluoroethylene, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardPlastic, 4)}).add("plastic_circuit_board_4", 500L, 10L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.EpoxyResin, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardEpoxy, 1)}).add("epoxy_circuit_board", 500L, 10L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.FiberReinforcedEpoxyResin, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardFiber, 1)}).add("fiber_circuit_board", 500L, 10L);
        RecipeMaps.CHEMICAL_REACTOR.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardFiber, (int)1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Electrum, 16)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(250)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardMultiFiber, 1)}).add("multi_fiber_circuit_board", 100L, 480L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardMultiFiber, (int)1), RecipeIngredient.of((TagKey)GTCoreTags.CIRCUITS_GOOD, (int)1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.PetriDish}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.SensorLV}), RecipeIngredient.of((ItemStack)GT5RCovers.COVER_PUMP.getItem(Tier.LV))}).fi(new FluidStack[]{Materials.Polystyrene.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitBoardWetware, 1)}).add("wetware_circuit_board", 160L, 32768L);
    }

    private static void bloodyCircuitParts() {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.SiliconChip, (int)1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Tin, 6)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.Transistor, 8)}).add("transistor", 80L, 24L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Plastic, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Aluminium, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.Capacitor, 2)}).add("capacitor", 80L, 96L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Gallium, 1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.AnnealedCopper, 6)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDTransistor, 32)}).add("smd_transistor", 80L, 96L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.DUST.get(Materials.Carbon), (int)1), RecipeIngredient.of((ItemLike)GTMaterialTypes.FINE_WIRE.get(Materials.Electrum), (int)4)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDResistor, 24)}).add("smd_resistor", 80L, 96L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.PolyvinylChloride, 4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Tantalum, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(36)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDCapacitor, 32)}).add("smd_capacitor_tantalum", 50L, 96L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.PolyvinylChloride, 4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Aluminium, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(36)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDCapacitor, 16)}).add("smd_capacitor_aluminium", 50L, 96L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.SiliconeRubber, 4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Tantalum, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(36)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDCapacitor, 32)}).add("smd_capacitor_tantalum_rubber", 60L, 120L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.SiliconeRubber, 4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Aluminium, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(36)}).io(new ItemStack[]{new ItemStack(GT5RItems.SMDCapacitor, 16)}).add("smd_capacitor_aluminium_rubber", 60L, 120L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.AnnealedCopper, 4), GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Gallium, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GT5RItems.Diode, 16)}).add("diode", 400L, 48L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 8), GTMaterialTypes.BOLT.getMaterialIngredient(Materials.Steel, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.SmallCoil, 2)}).add("small_coil_1", 80L, 8L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 8), GTMaterialTypes.BOLT.getMaterialIngredient(Materials.NickelZincFerrite, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.SmallCoil, 4)}).add("small_coil_2", 80L, 8L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.AnnealedCopper, 8), GTMaterialTypes.BOLT.getMaterialIngredient(Materials.Steel, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.SmallCoil, 2)}).add("small_coil_3", 80L, 8L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.AnnealedCopper, 8), GTMaterialTypes.BOLT.getMaterialIngredient(Materials.NickelZincFerrite, 1)}).io(new ItemStack[]{new ItemStack(GT5RItems.SmallCoil, 4)}).add("small_coil_4", 80L, 8L);
    }

    private static void bloodyCircuits() {
        for (Material material : GT5RMaterialTags.SOLDER.all()) {
            boolean hasBad;
            int base = 18;
            boolean hasGood = GT5RMaterialTags.SOLDER.has(SubTag.GOOD_SOLDER, material);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardPhenolic, (int)1), RecipeIngredient.of(GT5RTags.RESISTORS, (int)2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 4), RecipeIngredient.of(GT5RItems.IntegratedLogicCircuit, (int)1)}).io(new ItemStack[]{new ItemStack(GT5RItems.BasicCircuit, 1)}).fi(new FluidStack[]{material.getLiquid((base *= (hasBad = GT5RMaterialTags.SOLDER.has(SubTag.BAD_SOLDER, material)) ? (hasGood ? 2 : 4) : 1) * 4)}).add("basic_circuit_using_" + material.getId(), 200L, 8L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.IntegratedLogicCircuit, (int)4), RecipeIngredient.of(GT5RTags.RESISTORS, (int)4), RecipeIngredient.of(GT5RTags.CAPACITORS, (int)4), RecipeIngredient.of(GT5RTags.TRANSISTORS, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.MicroProcessor, 4)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("microprocessor_using_" + material.getId(), 200L, 60L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.SOC, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Copper, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.MicroProcessor, 4)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("microprocessor_soc_using_" + material.getId(), 200L, 60L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardPhenolic, (int)1), RecipeIngredient.of(GT5RTags.RESISTORS, (int)4), RecipeIngredient.of(GT5RItems.BasicCircuit, (int)3), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 8)}).io(new ItemStack[]{new ItemStack(GT5RItems.GoodCircuit, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("good_circuit_using_" + material.getId(), 400L, 16L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.CentralProcessingUnit, (int)1), RecipeIngredient.of(GT5RTags.RESISTORS, (int)2), RecipeIngredient.of(GT5RTags.CAPACITORS, (int)2), RecipeIngredient.of(GT5RTags.TRANSISTORS, (int)2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.IntegratedProcessor, 4)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("integrated_processor_using_" + material.getId(), 200L, 60L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.SOC, (int)1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.IntegratedProcessor, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("integrated_processor_soc_using_" + material.getId(), 200L, 60L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.GoodCircuit, (int)2), RecipeIngredient.of(GT5RItems.IntegratedLogicCircuit, (int)3), RecipeIngredient.of(GT5RItems.RandomAccessMemoryChip, (int)1), RecipeIngredient.of(GT5RTags.TRANSISTORS, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 16)}).io(new ItemStack[]{new ItemStack(GT5RItems.AdvancedCircuit, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("advanced_circuit_using_" + material.getId(), 800L, 28L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.IntegratedProcessor, (int)2), RecipeIngredient.of(GT5RItems.SmallCoil, (int)4), RecipeIngredient.of(GT5RTags.CAPACITORS, (int)4), RecipeIngredient.of(GT5RItems.RandomAccessMemoryChip, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.RedAlloy, 12)}).io(new Item[]{GT5RItems.ProcessorAssembly}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("processor_assembly_using_" + material.getId(), 200L, 600L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.of(GT5RItems.NanoCpu, (int)1), RecipeIngredient.of(GT5RTags.RESISTORS, (int)2), RecipeIngredient.of(GT5RTags.CAPACITORS, (int)2), RecipeIngredient.of(GT5RTags.TRANSISTORS, (int)2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.NanoProcessor)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("nano_processor_using_" + material.getId(), 200L, 600L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardPlastic}), RecipeIngredient.of(GT5RItems.ASoC, (int)1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.NanoProcessor)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("nano_processor_asoc_using_" + material.getId(), 300L, 8192L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardPlastic, (int)2), RecipeIngredient.of(GT5RItems.ProcessorAssembly, (int)3), RecipeIngredient.of(GT5RTags.DIODES, (int)4), RecipeIngredient.of(GT5RItems.RandomAccessMemoryChip, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 6)}).io(new ItemStack[]{new ItemStack(GT5RItems.Workstation)}).fi(new FluidStack[]{material.getLiquid(base * 8)}).add("workstation_using_" + material.getId(), 400L, 90L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.of(GT5RItems.NanoProcessor, (int)2), RecipeIngredient.of(GT5RItems.SmallCoil, (int)4), RecipeIngredient.of(GT5RItems.SMDCapacitor, (int)4), RecipeIngredient.of(GT5RItems.RandomAccessMemoryChip, (int)4), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Electrum, 6)}).io(new ItemStack[]{new ItemStack(GT5RItems.NanoprocessorAssembly)}).fi(new FluidStack[]{material.getLiquid(base * 8)}).add("nanoprocessor_assembly_using_" + material.getId(), 400L, 600L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardFiber}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.QBitProcessingUnit}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.NanoCpu}), RecipeIngredient.of(GT5RItems.SMDCapacitor, (int)2), RecipeIngredient.of(GT5RItems.SMDTransistor, (int)2), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Platinum, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.QuantumProcessor)}).fi(new FluidStack[]{material.getLiquid(base * 8)}).add("quantum_processor_using_" + material.getId(), 200L, 2400L);
            RecipeMaps.CIRCUIT_ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CircuitBoardEpoxy}), RecipeIngredient.of(GT5RItems.ASoC, (int)1), GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Platinum, 2)}).io(new ItemStack[]{new ItemStack(GT5RItems.QuantumProcessor)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("quantum_processor_asoc_using_" + material.getId(), 50L, 8192L);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardMultiFiber, (int)1), RecipeIngredient.of(GT5RItems.Resistor, (int)8), RecipeIngredient.of(GT5RItems.Transistor, (int)8), RecipeIngredient.of(GT5RItems.Capacitor, (int)8), RecipeIngredient.of((ItemLike)GTMaterialTypes.FINE_WIRE.get(Materials.NiobiumTitanium), (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.EnergyFlowCircuit, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("energy_flow_circuit_using_" + material.getId(), 400L, 8192L);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of(GT5RItems.CircuitBoardWetware, (int)1), RecipeIngredient.of(GT5RItems.Resistor, (int)8), RecipeIngredient.of(GT5RItems.Transistor, (int)8), RecipeIngredient.of(GT5RItems.Capacitor, (int)8), RecipeIngredient.of((ItemLike)GTMaterialTypes.FINE_WIRE.get(Materials.YttriumBariumCuprate), (int)4)}).io(new ItemStack[]{new ItemStack(GT5RItems.CircuitWetware, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4)}).add("wetware_circuit_using_" + material.getId(), 400L, 32768L);
        }
    }
}

