/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.block.BlockAsphalt;
import org.gtreimagined.gt5r.block.BlockAsphaltSlab;
import org.gtreimagined.gt5r.block.BlockAsphaltStair;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class BlockParts {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        GTMaterialTypes.FRAME.all().forEach(frame -> {
            if (!frame.has(new IMaterialTag[]{GTMaterialTypes.ROD})) {
                return;
            }
            provider.addStackRecipe(output, "gt5r", "", "gtblockparts", ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(frame).asStack(2), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.get(frame), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"RRR", "RWR", "RRR"});
        });
        GTAPI.all(BlockColoredWall.class, b -> {
            if (b.getMaterial() == Materials.Wood) {
                provider.addItemRecipe(output, "walls", (ItemLike)b.m_5456_(), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('W'), (Object)ItemTags.f_13168_), new String[]{"W W", "SPH", "W W"});
            } else {
                provider.addItemRecipe(output, "walls", (ItemLike)b.m_5456_(), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(b.getMaterial()), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"WPP", "HPP"});
            }
        });
        BlockParts.addBrickedCasing(output, provider, Materials.Bronze, (Block)GT5RBlocks.BRICKED_BRONZE_CASING);
        provider.addStackRecipe(output, "gt5r", "firebricks", "blocks", new ItemStack((ItemLike)GT5RBlocks.FIRE_BRICKS), ImmutableMap.of((Object)Character.valueOf('F'), (Object)GTCoreItems.FireBrick), new String[]{"FF", "FF"});
        BlockParts.addBrickedCasing(output, provider, Materials.Steel, (Block)GT5RBlocks.BRICKED_STEEL_CASING);
        BlockParts.addFirebox(output, provider, Materials.Bronze, (Block)GT5RBlocks.BRONZE_FIREBOX_CASING);
        BlockParts.addFirebox(output, provider, Materials.Steel, (Block)GT5RBlocks.STEEL_FIREBOX_CASING);
        BlockParts.addFirebox(output, provider, Materials.Titanium, (Block)GT5RBlocks.TITANIUM_FIREBOX_CASING);
        BlockParts.addFirebox(output, provider, Materials.TungstenSteel, (Block)GT5RBlocks.TUNGSTENSTEEL_FIREBOX_CASING);
        BlockParts.addGearbox(output, provider, Materials.Bronze, (Block)GT5RBlocks.BRONZE_GEARBOX_CASING);
        BlockParts.addGearbox(output, provider, Materials.Steel, (Block)GT5RBlocks.STEEL_GEARBOX_CASING);
        BlockParts.addGearbox(output, provider, Materials.Titanium, (Block)GT5RBlocks.TITANIUM_GEARBOX_CASING);
        BlockParts.addGearbox(output, provider, Materials.TungstenSteel, (Block)GT5RBlocks.TUNGSTENSTEEL_GEARBOX_CASING);
        BlockParts.addPipeCasing(output, provider, Materials.Bronze, GT5RBlocks.FLUID_PIPE_BRONZE, (Block)GT5RBlocks.BRONZE_PIPE_CASING);
        BlockParts.addPipeCasing(output, provider, Materials.Steel, GT5RBlocks.FLUID_PIPE_STEEL, (Block)GT5RBlocks.STEEL_PIPE_CASING);
        BlockParts.addPipeCasing(output, provider, Materials.Titanium, GT5RBlocks.FLUID_PIPE_TITANIUM, (Block)GT5RBlocks.TITANIUM_PIPE_CASING);
        BlockParts.addPipeCasing(output, provider, Materials.TungstenSteel, GT5RBlocks.FLUID_PIPE_TUNGSTEN_STEEL, (Block)GT5RBlocks.TUNGSTENSTEEL_PIPE_CASING);
        BlockParts.addTurbine(output, provider, Materials.Steel, (Block)GT5RBlocks.STEEL_TURBINE_CASING);
        BlockParts.addTurbine(output, provider, Materials.StainlessSteel, (Block)GT5RBlocks.STAINLESS_STEEL_TURBINE_CASING);
        BlockParts.addTurbine(output, provider, Materials.Titanium, (Block)GT5RBlocks.TITANIUM_TURBINE_CASING);
        BlockParts.addTurbine(output, provider, Materials.TungstenSteel, (Block)GT5RBlocks.TUNGSTENSTEEL_TURBINE_CASING);
        BlockParts.addCasing(output, provider, Materials.Invar, (Block)GT5RBlocks.HEAT_PROOF_CASING);
        BlockParts.addCasing(output, provider, Materials.Aluminium, (Block)GT5RBlocks.FROST_PROOF_CASING);
        BlockParts.addCasing(output, provider, Materials.Steel, (Block)GT5RBlocks.SOLID_STEEL_CASING);
        BlockParts.addCasing(output, provider, Materials.StainlessSteel, (Block)GT5RBlocks.STAINLESS_STEEL_CASING);
        BlockParts.addCasing(output, provider, Materials.Titanium, (Block)GT5RBlocks.TITANIUM_CASING);
        BlockParts.addCasing(output, provider, Materials.Lead, (Block)GT5RBlocks.RADIATION_PROOF_CASING);
        BlockParts.addCasing(output, provider, Materials.TungstenSteel, (Block)GT5RBlocks.TUNGSTENSTEEL_CASING);
        BlockParts.addCasing(output, provider, Materials.Tungsten, (Block)GT5RBlocks.TUNGSTEN_CASING);
        BlockParts.addCasing(output, provider, Materials.Platinum, (Block)GT5RBlocks.PLATINUM_CASING);
        BlockParts.addCasing(output, provider, Materials.BlackBronze, (Block)GT5RBlocks.BLACK_BRONZE_CASING);
        BlockParts.addCasing(output, provider, Materials.Plastic, (Block)GT5RBlocks.PLASTIC_CASING);
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.DENSE_LEAD_CASING, ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.DENSE_PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(Materials.Lead), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"RLL", "LWL", "LLR"});
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.ELECTROLYTIC_CELL, ImmutableMap.of((Object)Character.valueOf('W'), (Object)GT5RBlocks.WIRE_PLATINUM.getBlockItem(PipeSize.VTINY), (Object)Character.valueOf('M'), (Object)((Object)GT5RBlocks.STAINLESS_STEEL_CASING), (Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)), new String[]{"WWW", "WMW", "CCC"});
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.GRINDING_WHEELS, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('M'), (Object)((Object)GT5RBlocks.TUNGSTENSTEEL_CASING), (Object)Character.valueOf('D'), GT5RTags.GRIND_HEADS), new String[]{"GDG", "GMG"});
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.ORE_WASHING_PARTS, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.Titanium), (Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_TITANIUM.getBlock(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.TITANIUM_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"GGG", "PCP", "PWP"});
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.FILTER_CASING, ImmutableMap.of((Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.TITANIUM_CASING), (Object)Character.valueOf('I'), (Object)GT5RCovers.COVER_ITEM_FILTER.getItem()), new String[]{" I ", "ICI", " I "});
        provider.addItemRecipe(output, "casings", (ItemLike)GT5RBlocks.BEDROCK_DRILL_HEAD, ImmutableMap.of((Object)Character.valueOf('D'), GT5RTags.GRIND_HEADS, (Object)Character.valueOf('d'), (Object)GTMaterialTypes.DRILL_BIT.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.TUNGSTENSTEEL_CASING)), new String[]{"GdG", "DCD", "GdG"});
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_CUPRONICKEL.getBlockItem(PipeSize.TINY), GT5RBlocks.CUPRONICKEL_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_KANTHAL.getBlockItem(PipeSize.TINY), GT5RBlocks.KANTHAL_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_NICHROME.getBlockItem(PipeSize.TINY), GT5RBlocks.NICHROME_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_TUNGSTEN_STEEL.getBlockItem(PipeSize.TINY), GT5RBlocks.TUNGSTENSTEEL_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_HSSG.getBlockItem(PipeSize.TINY), GT5RBlocks.HSSG_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_NAQUADAH.getBlockItem(PipeSize.TINY), GT5RBlocks.NAQUADAH_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.TINY), GT5RBlocks.NAQUADAH_ALLOY_COIL);
        BlockParts.addCoil(output, provider, GT5RBlocks.WIRE_SUPERCONDUCTOR.getBlockItem(PipeSize.TINY), GT5RBlocks.SUPERCONDUCTOR_COIL);
        provider.addItemRecipe(output, "coils", (ItemLike)GT5RBlocks.FUSION_COIL, ImmutableMap.of((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.LUV), (Object)Character.valueOf('F'), GT5RItems.FieldGenMV, (Object)Character.valueOf('c'), (Object)((Object)GT5RBlocks.SUPERCONDUCTOR_COIL), (Object)Character.valueOf('I'), (Object)GTCoreItems.IridiumNeutronReflector), new String[]{"CIC", "FcF", "CIC"});
        BlockParts.addTierCasing(output, provider, Tier.ULV);
        BlockParts.addTierCasing(output, provider, Tier.LV);
        BlockParts.addTierCasing(output, provider, Tier.MV);
        BlockParts.addTierCasing(output, provider, Tier.HV);
        BlockParts.addTierCasing(output, provider, Tier.EV);
        BlockParts.addTierCasing(output, provider, Tier.IV);
        BlockParts.addTierCasing(output, provider, Tier.LUV);
        BlockParts.addTierCasing(output, provider, Tier.ZPM);
        BlockParts.addTierCasing(output, provider, Tier.UV);
        BlockParts.addTierCasing(output, provider, Tier.UHV);
        BlockParts.addTierHull(output, provider, Materials.Wood, Tier.ULV);
        BlockParts.addTierHull(output, provider, Materials.WroughtIron, Tier.LV);
        BlockParts.addTierHull(output, provider, Materials.WroughtIron, Tier.MV);
        BlockParts.addTierHull(output, provider, Materials.Plastic, Tier.HV);
        BlockParts.addTierHull(output, provider, Materials.Plastic, Tier.EV);
        BlockParts.addTierHull(output, provider, Materials.Plastic, Tier.IV);
        BlockParts.addTierHull(output, provider, Materials.Plastic, Tier.LUV);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.ZPM);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.UV);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.UHV);
        provider.addStackRecipe(output, "gt5r", "", "gtblockparts", new ItemStack((ItemLike)GT5RBlocks.ENGINE_INTAKE_CASING, 1), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(Materials.Titanium), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((Object)GT5RBlocks.TITANIUM_CASING), (Object)Character.valueOf('G'), (Object)GT5RBlocks.FLUID_PIPE_TITANIUM.getBlockItem(PipeSize.NORMAL)), new String[]{"PHP", "GFG", "PWP"});
        if (GT5RConfig.HARD_SETTINGS) {
            provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.ASSEMBLY_LINE_CASING, ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.IV), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"SHS", "RFR", "SWS"});
            provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.ADVANCED_ASSEMBLER_CASING, ImmutableMap.of((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.EV), (Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.IV), (Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('M'), (Object)GTCoreItems.MotorIV), new String[]{"CcC", "CFC", "CMC"});
        }
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.AUTOCRAFTER_ASSEMBLY_LINE_CASING, ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Steel), (Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.Steel), (Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.HV), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"SHS", "RFR", "SWS"});
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.ASSEMBLER_CASING, ImmutableMap.of((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.MV), (Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.HV), (Object)Character.valueOf('I'), (Object)GT5RCovers.COVER_CONVEYOR.getItem(Tier.HV), (Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.Steel), (Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV), new String[]{"IcI", "CFC", "CMC"});
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.GRATE_CASING, ImmutableMap.of((Object)Character.valueOf('B'), (Object)Items.f_42025_, (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(Materials.Steel), (Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.Steel), (Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV), new String[]{"BRB", "BFB", "BMB"});
        provider.addStackRecipe(output, "gt5r", "", "gtblockparts", new ItemStack((ItemLike)GT5RBlocks.BRONZE_PLATED_BRICK_CASING, 1), ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Bronze)).put((Object)Character.valueOf('B'), (Object)Blocks.f_50076_).put((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()).put((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()).build(), new String[]{"PHP", "PBP", "PWP"});
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)GT5RBlocks.STEEL_CASING, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Steel)).put((Object)Character.valueOf('W'), (Object)GTTools.HAMMER.getTag()).build(), new String[]{"PPP", "PWP", "PPP"});
        provider.addStackRecipe(output, "gt5r", "", "gtblockparts", new ItemStack((ItemLike)GT5RBlocks.FUSION_CASING, 1), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.TungstenSteel), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((Object)GT5RBlocks.CASING_LUV)), new String[]{"PHP", "PFP", "PWP"});
        provider.addItemRecipe(output, "long_distance_cables", (ItemLike)GT5RBlocks.LONG_DIST_WIRE_EV, ImmutableMap.of((Object)Character.valueOf('C'), (Object)GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.HUGE), (Object)Character.valueOf('c'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)), new String[]{"RAR", "cCc", "RAR"});
        provider.addItemRecipe(output, "long_distance_cables", (ItemLike)GT5RBlocks.LONG_DIST_WIRE_IV, ImmutableMap.of((Object)Character.valueOf('C'), (Object)TierMaps.WIRE_GETTER.apply(PipeSize.HUGE, Tier.LV), (Object)Character.valueOf('c'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)), new String[]{"RAR", "cCc", "RAR"});
        provider.addItemRecipe(output, "long_distance_cables", (ItemLike)GT5RBlocks.LONG_DIST_WIRE_LUV, ImmutableMap.of((Object)Character.valueOf('C'), (Object)GT5RBlocks.WIRE_ELECTRUM.getBlockItem(PipeSize.HUGE), (Object)Character.valueOf('c'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)), new String[]{"RAR", "cCc", "RAR"});
        provider.addItemRecipe(output, "long_distance_cables", (ItemLike)GT5RBlocks.LONG_DIST_WIRE_ZPM, ImmutableMap.of((Object)Character.valueOf('C'), (Object)GT5RBlocks.WIRE_ALUMINIUM.getBlockItem(PipeSize.HUGE), (Object)Character.valueOf('c'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)), new String[]{"RAR", "cCc", "RAR"});
        provider.addItemRecipe(output, "long_distance_cables", (ItemLike)GT5RBlocks.LONG_DIST_WIRE_UV, ImmutableMap.of((Object)Character.valueOf('C'), (Object)GT5RBlocks.WIRE_PLATINUM.getBlockItem(PipeSize.HUGE), (Object)Character.valueOf('c'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)), new String[]{"RAR", "cCc", "RAR"});
        provider.addItemRecipe(output, "long_distance_pipes", (ItemLike)GT5RBlocks.LONG_DIST_ITEM_PIPE, ImmutableMap.of((Object)Character.valueOf('E'), (Object)GT5RBlocks.ITEM_PIPE_ELECTRUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Plastic)), new String[]{"PEP", "EWE", "PEP"});
        provider.addItemRecipe(output, "long_distance_pipes", (ItemLike)GT5RBlocks.LONG_DIST_FLUID_PIPE, ImmutableMap.of((Object)Character.valueOf('E'), (Object)GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Plastic)), new String[]{"PEP", "EWE", "PEP"});
        GTAPI.all(BlockAsphalt.class, (String)"gt5r").forEach(b -> {
            Block slab = (Block)GTAPI.get(BlockAsphaltSlab.class, (String)(b.getId() + "_slab"), (String)"gt5r");
            Block stairs = (Block)GTAPI.get(BlockAsphaltStair.class, (String)(b.getId() + "_stairs"), (String)"gt5r");
            if (slab != null) {
                BlockParts.addSlabRecipe(output, provider, (Block)b, slab);
            }
            if (stairs != null) {
                BlockParts.addStairRecipe(output, provider, (Block)b, stairs);
            }
        });
        provider.removeRecipe(new ResourceLocation("tnt"));
        provider.addItemRecipe(output, "misc", (ItemLike)GT5RBlocks.POWDER_BARREL, ImmutableMap.of((Object)Character.valueOf('W'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('G'), (Object)Items.f_42403_, (Object)Character.valueOf('S'), (Object)Items.f_42401_), new String[]{"WSW", "GGG", "WGW"});
    }

    private static void addSlabRecipe(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Block full, Block slab) {
        provider.addStackRecipe(output, "slabs", new ItemStack((ItemLike)slab, 6), ImmutableMap.of((Object)Character.valueOf('F'), (Object)full), new String[]{"FFF"});
        provider.addItemRecipe(output, "slabs", (ItemLike)full, ImmutableMap.of((Object)Character.valueOf('S'), (Object)slab), new String[]{"S", "S"});
        SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{full}), (ItemLike)slab, (int)2).m_142409_("slabs").m_142284_("has_full", provider.hasSafeItem((ItemLike)full)).m_142700_(output, new ResourceLocation("gt5r", "stonecutting/" + RegistryUtils.getIdFromItem((Item)slab.m_5456_()).m_135815_()));
    }

    private static void addStairRecipe(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Block full, Block stair) {
        provider.addStackRecipe(output, "stairs", new ItemStack((ItemLike)stair, 4), ImmutableMap.of((Object)Character.valueOf('F'), (Object)full), new String[]{"F  ", "FF ", "FFF"});
        provider.addStackRecipe(output, "gt5r", RegistryUtils.getIdFromItem((Item)stair.m_5456_()).m_135815_() + "_mirrored", "stairs", new ItemStack((ItemLike)stair, 4), ImmutableMap.of((Object)Character.valueOf('F'), (Object)full), new String[]{"  F", " FF", "FFF"});
        SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{full}), (ItemLike)stair, (int)1).m_142409_("stairs").m_142284_("has_full", provider.hasSafeItem((ItemLike)full)).m_142700_(output, new ResourceLocation("gt5r", "stonecutting/" + RegistryUtils.getIdFromItem((Item)stair.m_5456_()).m_135815_()));
    }

    private static void addCasing(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gt5r", "", "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PHP", "PFP", "PWP"});
    }

    private static void addBrickedCasing(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('B'), (Object)Items.f_42460_, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PPP", "PHP", "BBB"});
    }

    private static void addFirebox(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gt5r", "", "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(mat), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PRP", "RFR", "PRP"});
    }

    private static void addGearbox(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gt5r", "", "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem(), (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(mat)), new String[]{"PHP", "GFG", "PWP"});
    }

    private static void addPipeCasing(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, PipeType<?> pipe, Block casing) {
        provider.addItemRecipe(output, "gt5r", "", "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)pipe.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PRP", "RFR", "PRP"});
    }

    private static void addTurbine(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(mat), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PRP", "PFP", "PRP"});
    }

    private static void addCoil(Consumer<FinishedRecipe> output, GTRecipeProvider provider, PipeItemBlock wire, BlockCoil coil) {
        provider.addItemRecipe(output, "casings", (ItemLike)coil, ImmutableMap.of((Object)Character.valueOf('P'), (Object)wire, (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"PPP", "PWP", "PPP"});
    }

    private static void addTierCasing(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Tier tier) {
        provider.addItemRecipe(output, "casings", (ItemLike)GTAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gt5r"), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"PPP", "PWP", "PPP"});
    }

    private static void addTierHull(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Material mat, Tier tier) {
        provider.addItemRecipe(output, "hulls", (ItemLike)GT5RMachines.HULL.getItem(tier), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (Object)Character.valueOf('W'), (Object)TierMaps.CABLE_GETTER.apply((Object)(tier == Tier.UV ? PipeSize.SMALL : PipeSize.VTINY), (Object)tier, (Object)false), (Object)Character.valueOf('K'), (Object)GTAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gt5r")), new String[]{"PRP", "WKW"});
    }
}

