/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.SpaceModRegistrar;
import org.gtreimagined.gt5r.worldgen.OilSpoutFluid;
import org.gtreimagined.gt5r.worldgen.OilSpoutSavedData;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.event.GTWorldGenEvent;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.worldgen.bedrockore.BedrockVein;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOreBuilder;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerBuilder;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerOre;
import org.gtreimagined.gtlib.worldgen.vanillaore.VanillaVeinBuilder;
import org.gtreimagined.gtlib.worldgen.vein.VeinBuilder;

public class WorldGenLoader {
    public static final ResourceKey<Level> TWILIGHT_FOREST = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("twilightforest:twilight_forest"));
    public static final ResourceKey<Level> BE_MOON = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "moon"));
    public static final ResourceKey<Level> AA_MOON = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("ad_astra", "moon"));
    public static final ResourceKey<Level> BE_MARS = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mars"));
    public static final ResourceKey<Level> AA_MARS = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("ad_astra", "mars"));
    public static final ResourceKey<Level> BE_MERCURY = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mercury"));
    public static final ResourceKey<Level> AA_MERCURY = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("ad_astra", "mercury"));
    public static final ResourceKey<Level> BE_VENUS = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "venus"));
    public static final ResourceKey<Level> AA_VENUS = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("ad_astra", "venus"));
    public static final ResourceKey<Level> JAMD_MINING = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("jamd", "mining"));

    public static void init(GTWorldGenEvent ev) {
        if (GT5RConfig.DEFAULT_STONE_LAYERS.get()) {
            WorldGenLoader.initStoneVeins(ev);
        }
        if (GT5RConfig.DEFAULT_ORE_VEINS.get()) {
            WorldGenLoader.initOreVeins(ev);
        }
        if (GT5RConfig.DEFAULT_SMALL_ORES.get() && !GTAPI.isModLoaded((String)"tfc")) {
            WorldGenLoader.initSmallOres(ev);
        }
        if (GT5RConfig.DEFAULT_BEDROCK_VEINS.get()) {
            WorldGenLoader.initBedrockVeins(ev);
        }
        OilSpoutSavedData.clearFluidMap();
        OilSpoutFluid.resetTotalWeight();
        new OilSpoutFluid("oil", Materials.Oil.getLiquid(), 20, 625, 4, 5);
        new OilSpoutFluid("light_oil", Materials.OilLight.getLiquid(), 20, 625, 3, 6);
        new OilSpoutFluid("heavy_oil", Materials.OilHeavy.getLiquid(), 20, 625, 5, 4);
        new OilSpoutFluid("natural_gas", Materials.NaturalGas.getGas(), 20, 625, 4, 7);
        if (GTAPI.isModLoaded((String)"twilightforest") && GT5RConfig.DEFAULT_TWILIGHT_ORE_GEN.get()) {
            WorldGenLoader.initTwilightForestOres(ev);
        }
    }

    private static void initBedrockVeins(GTWorldGenEvent ev) {
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "diamond"), (int)128000, (Material)Materials.Diamond, (boolean)true, (Block)GT5RBlocks.PANDANUS_CANDELABRUM, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "tungstate"), (int)96000, (Material)Materials.Tungstate, (boolean)true, (Block)GT5RBlocks.TUNGSTUS, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "scheelite"), (int)96000, (Material)Materials.Scheelite, (boolean)true, (Block)GT5RBlocks.TUNGSTUS, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "uraninite"), (int)60000, (Material)Materials.Uraninite, (boolean)true, (Block)GT5RBlocks.TUFTED_EVENING_PRIMROSE, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "pitchblende"), (int)60000, (Material)Materials.Pitchblende, (boolean)true, (Block)GT5RBlocks.THOMPSONS_LOCOWEED, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "gold_a"), (int)32000, (Material)Materials.Gold, (boolean)true, (Block)GT5RBlocks.ALTERED_ANDESITE_BUCKWHEAT, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "gold_b"), (int)32000, (Material)Materials.Gold, (boolean)true, (Block)GT5RBlocks.DESERT_TRUMPET, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "sheldonite"), (int)16000, (Material)Materials.Sheldonite, (boolean)true, (Block)GT5RBlocks.NARCISSUS_SHELDONIA, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "copper"), (int)16000, (Material)Materials.Copper, (boolean)true, (Block)GT5RBlocks.BECIUM_HOMBLEI, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "monzanite"), (int)16000, (Material)Materials.Monazite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "powellite"), (int)14000, (Material)Materials.Powellite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "bastnasite"), (int)8000, (Material)Materials.Bastnasite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "redstone"), (int)7000, (Material)Materials.Redstone, (boolean)true, (Block)GT5RBlocks.PRINCES_PLUME, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "vanadium_magnetite"), (int)6000, (Material)Materials.VanadiumMagnetite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "galena"), (int)6000, (Material)Materials.Galena, (boolean)true, (Block)GT5RBlocks.CROSBY_BUCKWHEAT, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "coal"), (int)5000, (Material)Materials.Coal, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "graphite"), (int)5000, (Material)Materials.Graphite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "stibnite"), (int)4000, (Material)Materials.Stibnite, (boolean)true, (Block)GT5RBlocks.ATRIPLEX_CANESCENS, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "hematite"), (int)4000, (Material)Materials.Hematite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "sphalerite"), (int)3000, (Material)Materials.Sphalerite, (boolean)true, (Block)GT5RBlocks.VIOLA_CALAMINARIA, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "pentlandite"), (int)3000, (Material)Materials.Pentlandite, (boolean)true, (Block)GT5RBlocks.THLASPI_LERESCHIANUM, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "saltpeter"), (int)3000, (Material)Materials.Saltpeter, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "bauxite"), (int)2000, (Material)Materials.Bauxite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "cassiterite"), (int)2000, (Material)Materials.Cassiterite, (boolean)true, (Block)GT5RBlocks.ORECHID, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "chalcopyrite"), (int)2000, (Material)Materials.Chalcopyrite, (boolean)true, (Block)GT5RBlocks.ALPINE_CATCHFLY, (ResourceKey[])new ResourceKey[]{Level.f_46428_, JAMD_MINING}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "naquadah"), (int)10000, (Material)Materials.Naquadah, (boolean)true, (ResourceKey[])new ResourceKey[]{BE_MARS, AA_MARS}));
        ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "adamantine"), (int)10000, (Material)Materials.Adamantine, (boolean)true, (ResourceKey[])new ResourceKey[]{BE_MARS, AA_MARS}));
        if (SpaceModRegistrar.INSTANCE.isEnabled()) {
            ev.bedrockOre(BedrockVein.create((ResourceLocation)new ResourceLocation("gt5r", "desh"), (int)2000, (Material)SpaceModRegistrar.Desh, (boolean)true, (ResourceKey[])new ResourceKey[]{BE_MARS, AA_MARS}));
        }
    }

    private static void initTwilightForestOres(GTWorldGenEvent event) {
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "coal_twilight")).withMaterial(Materials.Coal).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "lignite_twilight")).withMaterial(Materials.Lignite).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "salt_twilight")).withMaterial(Materials.Salt).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "sylvite_twilight")).withMaterial(Materials.Sylvite).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "bauxite_twilight")).withMaterial(Materials.Bauxite).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "oil_shale_twilight")).withMaterial(Materials.OilShale).withMaterialType(GTMaterialTypes.ORE_STONE).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "milky_quartz_twilight")).withMaterial(Materials.MilkyQuartz).withSize(50).withWeight(1).atHeight(-16, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "sulfur_twilight")).withMaterial(Materials.Sulfur).withSize(16).withProbability(100).atHeight(-32, -24).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "apatite_twilight")).withMaterial(Materials.Apatite).withSize(16).withProbability(50).atHeight(-8, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "ruby_twilight")).withMaterial(Materials.Ruby).withSize(12).withProbability(100).atHeight(8, 22).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "amber_twilight")).withMaterial(Materials.Amber).withSize(12).withProbability(100).atHeight(8, 22).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "amethyst_twilight")).withMaterial(Materials.Amethyst).withSize(12).withProbability(100).atHeight(8, 22).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "galena_twilight")).withMaterial(Materials.Galena).withSize(24).withProbability(25).atHeight(-24, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "tetrahedrite_twilight")).withMaterial(Materials.Tetrahedrite).withSize(24).withProbability(25).atHeight(-24, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "cassiterite_twilight")).withMaterial(Materials.Cassiterite).withSize(24).withProbability(25).atHeight(-24, 0).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "sheldonite_twilight")).withMaterial(Materials.Sheldonite).withSize(6).withProbability(100).atHeight(8, 22).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "pentlandite_twilight")).withMaterial(Materials.Pentlandite).withSize(16).withProbability(25).atHeight(-24, -8).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "scheelite_twilight")).withMaterial(Materials.Scheelite).withSize(12).withProbability(25).atHeight(-24, -8).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "rutile_twilight")).withMaterial(Materials.Rutile).withSize(6).withProbability(25).atHeight(-24, -8).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "bastnasite_twilight")).withMaterial(Materials.Bastnasite).withSize(16).withProbability(100).atHeight(8, 22).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "graphite_twilight")).withMaterial(Materials.Graphite).withSize(6).withProbability(50).atHeight(-32, -24).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
        event.vanillaOre(new VanillaVeinBuilder(new ResourceLocation("gt5r", "pitchblende_twilight")).withMaterial(Materials.Pitchblende).withSize(16).withProbability(100).atHeight(-24, -16).inDimensions(new ResourceKey[]{TWILIGHT_FOREST}).buildMaterial());
    }

    private static void initSmallOres(GTWorldGenEvent event) {
        List<ResourceKey<Level>> mars = List.of(BE_MARS, AA_MARS);
        List<ResourceKey<Level>> moon = List.of(BE_MOON, AA_MOON);
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("copper")).withMaterial(Materials.Copper).withAmountPerChunk(32).atHeight(16, 126).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_, Level.f_46430_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("tin")).withMaterial(Materials.Tin).withAmountPerChunk(32).atHeight(16, 126).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_, Level.f_46430_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("bismuth")).withMaterial(Materials.Bismuth).withAmountPerChunk(8).atHeight(76, 196).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("coal")).withMaterial(Materials.Coal).withAmountPerChunk(24).atHeight(16, 126).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("iron")).withMaterial(Materials.Iron).withAmountPerChunk(16).atHeight(16, 61).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_, Level.f_46430_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("lead")).withMaterial(Materials.Lead).withAmountPerChunk(16).atHeight(16, 61).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_, Level.f_46430_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("zinc")).withMaterial(Materials.Zinc).withAmountPerChunk(12).atHeight(16, 96).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_, Level.f_46430_}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("gold")).withMaterial(Materials.Gold).withAmountPerChunk(8).atHeight(-34, 16).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("silver")).withMaterial(Materials.Silver).withAmountPerChunk(8).atHeight(-34, 16).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("nickel")).withMaterial(Materials.Nickel).withAmountPerChunk(8).atHeight(-34, 16).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("gold_nether_end")).withMaterial(Materials.Gold).withAmountPerChunk(8).atHeight(20, 40).inDimensions(new ResourceKey[]{Level.f_46429_, Level.f_46430_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("silver_nether_end")).withMaterial(Materials.Silver).withAmountPerChunk(8).atHeight(20, 40).inDimensions(new ResourceKey[]{Level.f_46429_, Level.f_46430_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("nickel_nether_end")).withMaterial(Materials.Nickel).withAmountPerChunk(8).atHeight(20, 40).inDimensions(new ResourceKey[]{Level.f_46429_, Level.f_46430_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("lapis")).withMaterial(Materials.Lapis).withAmountPerChunk(4).atHeight(-34, 16).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("diamond")).withMaterial(Materials.Diamond).withAmountPerChunk(3).atHeight(-59, -52).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(moon).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("diamond_nether")).withMaterial(Materials.Diamond).withAmountPerChunk(3).atHeight(5, 10).inDimensions(new ResourceKey[]{Level.f_46429_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("emerald")).withMaterial(Materials.Emerald).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("ruby")).withMaterial(Materials.Ruby).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("sapphire")).withMaterial(Materials.Sapphire).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("green_sapphire")).withMaterial(Materials.GreenSapphire).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("olivine")).withMaterial(Materials.Olivine).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("topaz")).withMaterial(Materials.Topaz).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("tanzanite")).withMaterial(Materials.Tanzanite).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("amethyst")).withMaterial(Materials.Amethyst).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("opal")).withMaterial(Materials.Opal).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("jade")).withMaterial(Materials.Jade).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("blue_topaz")).withMaterial(Materials.BlueTopaz).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("amber")).withMaterial(Materials.Amber).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("red_garnet")).withMaterial(Materials.RedGarnet).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("yellow_garnet")).withMaterial(Materials.YellowGarnet).withAmountPerChunk(2).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING, Level.f_46429_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("redstone")).withMaterial(Materials.Redstone).withAmountPerChunk(8).atHeight(-59, -34).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).inDimensions(mars).inDimensions(moon).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("redstone_nether")).withMaterial(Materials.Redstone).withAmountPerChunk(8).atHeight(5, 20).inDimension(Level.f_46429_).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("chromite")).withMaterial(Materials.Chromite).withAmountPerChunk(8).atHeight(20, 50).inDimensions(new ResourceKey[]{Level.f_46430_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("platinum")).withMaterial(Materials.Platinum).withAmountPerChunk(8).atHeight(20, 40).inDimensions(new ResourceKey[]{Level.f_46430_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("iridium")).withMaterial(Materials.Iridium).withAmountPerChunk(8).atHeight(20, 40).inDimensions(new ResourceKey[]{Level.f_46430_}).inDimensions(mars).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("quartz")).withMaterial(Materials.Quartz).withAmountPerChunk(64).atHeight(30, 120).inDimensions(new ResourceKey[]{Level.f_46429_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("saltpeter")).withMaterial(Materials.Saltpeter).withAmountPerChunk(8).atHeight(10, 60).inDimensions(new ResourceKey[]{Level.f_46429_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("sulfur")).withMaterial(Materials.Sulfur).withAmountPerChunk(32).atHeight(5, 60).inDimensions(new ResourceKey[]{Level.f_46429_}).buildMaterial());
        event.smallOre(new SmallOreBuilder(WorldGenLoader.id("sulfur_overworld")).withMaterial(Materials.Sulfur).withAmountPerChunk(8).atHeight(-59, -34).inDimensions(new ResourceKey[]{Level.f_46428_, JAMD_MINING}).buildMaterial());
    }

    private static void initStoneVeins(GTWorldGenEvent ev) {
        List<ResourceKey<Level>> overworld = List.of(Level.f_46428_, JAMD_MINING);
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("black_granite")).withStone(GTCoreBlocks.BLACK_GRANITE).withWeight(1).maxY(0, GTCoreBlocks.SHALE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("red_granite")).withStone(GTCoreBlocks.RED_GRANITE).withWeight(1).maxY(0, VanillaStoneTypes.GRANITE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("komatiite")).withStone(GTCoreBlocks.KOMATIITE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("basalt")).withStone(GTCoreBlocks.BASALT).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("marble")).withStone(GTCoreBlocks.MARBLE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("limestone")).withStone(GTCoreBlocks.LIMESTONE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("green_schist")).withStone(GTCoreBlocks.GREEN_SCHIST).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("blue_schist")).withStone(GTCoreBlocks.BLUE_SCHIST).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("kimberlite")).withStone(GTCoreBlocks.KIMBERLITE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("quartzite")).withStone(GTCoreBlocks.QUARTZITE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("shale")).withStone(GTCoreBlocks.SHALE).withWeight(1).minY(0, GTCoreBlocks.BLACK_GRANITE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("slate")).withStone(GTCoreBlocks.SLATE).withWeight(1).minY(0, VanillaStoneTypes.DEEPSLATE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("deepslate")).withStone(VanillaStoneTypes.DEEPSLATE).withWeight(1).maxY(0, GTCoreBlocks.SLATE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("granite")).withStone(VanillaStoneTypes.GRANITE).withWeight(1).minY(0, GTCoreBlocks.RED_GRANITE.getState().m_60734_()).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("diorite")).withStone(VanillaStoneTypes.DIORITE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("andesite")).withStone(VanillaStoneTypes.ANDESITE).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("tuff")).withStone(VanillaStoneTypes.TUFF).withWeight(1).inDimensions(overworld).buildVein());
        if (GT5RConfig.GT6_ORE_GEN.get()) {
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("kimberlite_2")).withStone(GTCoreBlocks.KIMBERLITE).withWeight(1).inDimensions(overworld).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("granite_ores")).withStone(VanillaStoneTypes.GRANITE).withWeight(1).minY(0, GTCoreBlocks.RED_GRANITE.getState().m_60734_()).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.BlueTopaz, 283500L, -24, 0).addFilteredBiome(BiomeTags.f_207602_).addFilteredBiome(BiomeTags.f_207603_).addFilteredBiome(BiomeTags.f_207604_), new StoneLayerOre(Materials.Topaz, 283500L, -8, 16).addFilteredBiome(Biomes.f_186757_).addFilteredBiome(Biomes.f_48182_)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("granite_ores_2")).withStone(VanillaStoneTypes.GRANITE).withWeight(1).minY(0, GTCoreBlocks.RED_GRANITE.getState().m_60734_()).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Apatite, 2268000L, 32, 64), new StoneLayerOre(Materials.Phosphate, 756000L, 36, 60), new StoneLayerOre(Materials.TricalciumPhosphate, 756000L, 40, 56)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("diorite_ores")).withStone(VanillaStoneTypes.DIORITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Sapphire, 283500L, -24, 0).addFilteredBiome(BiomeTags.f_207603_).addFilteredBiome(BiomeTags.f_207602_).addFilteredBiome(BiomeTags.f_207604_), new StoneLayerOre(Materials.GreenSapphire, 283500L, -8, 16).addFilteredBiome(BiomeTags.f_207610_), new StoneLayerOre(Materials.Ruby, 283500L, -8, 16).addFilteredBiome(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("is_desert"))).addFilteredBiome(Biomes.f_48203_)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("diorite_ores_2")).withStone(VanillaStoneTypes.DIORITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Garnierite, 2268000L, 16, 48), new StoneLayerOre(Materials.Pentlandite, 2268000L, 24, 56), new StoneLayerOre(Materials.Cobaltite, 2268000L, 32, 64), new StoneLayerOre(Materials.Amethyst, 283500L, 24, 48).addFilteredBiome(BiomeTags.f_207609_)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("andesite_ores")).withStone(VanillaStoneTypes.ANDESITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Gold, 1512000L, -64, -32), new StoneLayerOre(Materials.Gold, 2268000L, 32, 64).addFilteredBiome(Biomes.f_48159_).addFilteredBiome(Biomes.f_48194_)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("tuff_ores")).withStone(VanillaStoneTypes.TUFF).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Magnetite, 4536000L, -16, 84), new StoneLayerOre(Materials.Hematite, 3024000L, -16, 64), new StoneLayerOre(Materials.VanadiumMagnetite, 283500L, -16, 16)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("black_granite_ores")).withStone(GTCoreBlocks.BLACK_GRANITE).withWeight(1).maxY(0, GTCoreBlocks.SHALE.getState().m_60734_()).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Sheldonite, 567000L, -64, -48), new StoneLayerOre(Materials.Sperrylite, 567000L, -64, -48), new StoneLayerOre(Materials.Iridium, 283500L, -64, -56), new StoneLayerOre(Materials.Emerald, 283500L, -40, -16)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("red_granite_ores")).withStone(GTCoreBlocks.RED_GRANITE).withWeight(1).maxY(0, VanillaStoneTypes.GRANITE.getState().m_60734_()).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Pitchblende, 567000L, -32, 0), new StoneLayerOre(Materials.Uraninite, 567000L, -32, 0), new StoneLayerOre(Materials.Tantalite, 1134000L, -32, 0)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("komatiite_ores")).withStone(GTCoreBlocks.KOMATIITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Magnesite, 1134000L, -54, -9), new StoneLayerOre(Materials.Cinnabar, 1512000L, -64, -19), new StoneLayerOre(Materials.Redstone, 2268000L, -54, -9), new StoneLayerOre(Materials.Pyrite, 1512000L, 5, 66)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("kimberlite_ores")).withStone(GTCoreBlocks.KIMBERLITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Diamond, 378000L, -64, -52)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("basalt_ores")).withStone(GTCoreBlocks.BASALT).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Olivine, 567000L, -48, -16), new StoneLayerOre(Materials.Uvarovite, 567000L, -40, -8), new StoneLayerOre(Materials.Grossular, 567000L, -32, 0), new StoneLayerOre(Materials.Chromite, 2268000L, -16, 16)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("basalt_ores_2")).withStone(GTCoreBlocks.BASALT).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Bastnasite, 756000L, 24, 32), new StoneLayerOre(Materials.Monazite, 567000L, 24, 32), new StoneLayerOre(Materials.Manganese, 2268000L, 16, 48)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("marble_ores")).withStone(GTCoreBlocks.MARBLE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Cassiterite, 1134000L, 20, 120), new StoneLayerOre(Materials.Tin, 1134000L, 10, 100), new StoneLayerOre(Materials.Sphalerite, 2268000L, 10, 50), new StoneLayerOre(Materials.Chalcopyrite, 2268000L, 0, 40), new StoneLayerOre(Materials.Pyrite, 1512000L, 0, 50)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("limestone_ores")).withStone(GTCoreBlocks.LIMESTONE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Stibnite, 756000L, 10, 30), new StoneLayerOre(Materials.Galena, 2268000L, 30, 120), new StoneLayerOre(Materials.Lead, 1134000L, 50, 70)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("limestone_ores_2")).withStone(GTCoreBlocks.LIMESTONE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Pyrite, 1134000L, 0, 45), new StoneLayerOre(Materials.Galena, 2268000L, 5, 25), new StoneLayerOre(Materials.Galena, 2268000L, 80, 120), new StoneLayerOre(Materials.Wulfenite, 567000L, -34, -19), new StoneLayerOre(Materials.Powellite, 567000L, -29, -14), new StoneLayerOre(Materials.Molybdenite, 141750L, -34, -14), new StoneLayerOre(Materials.Tetrahedrite, 2268000L, 40, 100), new StoneLayerOre(Materials.Copper, 1134000L, 40, 100)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("limestone_ores_3")).withStone(GTCoreBlocks.LIMESTONE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Scheelite, 283500L, -64, -48), new StoneLayerOre(Materials.Tungstate, 283500L, -64, -48), new StoneLayerOre(Materials.YellowLimonite, 2268000L, -48, -16), new StoneLayerOre(Materials.BrownLimonite, 2268000L, -32, 0), new StoneLayerOre(Materials.Malachite, 1512000L, -48, 0)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("green_schist_ores")).withStone(GTCoreBlocks.GREEN_SCHIST).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Andradite, 567000L, -40, 8), new StoneLayerOre(Materials.Almandine, 567000L, -32, 0)}).buildVein());
            ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("blue_schist_ores")).withStone(GTCoreBlocks.BLUE_SCHIST).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Spessartine, 567000L, -40, 8), new StoneLayerOre(Materials.Pyrope, 567000L, -32, 0)}).buildVein());
            if (GTAPI.isModLoaded((String)"ae2")) {
                ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("quartzite_ores")).withStone(GTCoreBlocks.QUARTZITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.CertusQuartz, 1134000L, 16, 48), new StoneLayerOre(Materials.MilkyQuartz, 1134000L, 16, 48), new StoneLayerOre(Materials.Barite, 567000L, 0, 32)}).buildVein());
            } else {
                ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("quartzite_ores")).withStone(GTCoreBlocks.QUARTZITE).withWeight(1).inDimensions(overworld).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.MilkyQuartz, 1134000L, 16, 48), new StoneLayerOre(Materials.Barite, 567000L, 0, 32)}).buildVein());
            }
            ev.addCollisionBothSides(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Coal).asState(), GTCoreBlocks.SLATE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Amber, 4536000L, 30, 70).addFilteredBiome(BiomeTags.f_207603_).addFilteredBiome(BiomeTags.f_207602_).addFilteredBiome(BiomeTags.f_207604_), new StoneLayerOre(Materials.Amber, 2268000L, 30, 70).addFilteredBiome(BiomeTags.f_207605_)});
            ev.addCollisionBothSides(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Lignite).asState(), GTCoreBlocks.SLATE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Amber, 4536000L, 30, 70).addFilteredBiome(BiomeTags.f_207603_).addFilteredBiome(BiomeTags.f_207602_).addFilteredBiome(BiomeTags.f_207604_), new StoneLayerOre(Materials.Amber, 2268000L, 30, 70).addFilteredBiome(BiomeTags.f_207605_)});
            ev.addCollisionBothSides(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.OilShale).asState(), GTCoreBlocks.SLATE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Amber, 4536000L, 30, 70).addFilteredBiome(BiomeTags.f_207603_).addFilteredBiome(BiomeTags.f_207602_).addFilteredBiome(BiomeTags.f_207604_), new StoneLayerOre(Materials.Amber, 2268000L, 30, 70).addFilteredBiome(BiomeTags.f_207605_)});
            ev.addCollisionBothSides(GTCoreBlocks.BLACK_GRANITE.getState(), GTCoreBlocks.MARBLE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Lapis, 2268000L, 0, 48), new StoneLayerOre(Materials.Sodalite, 1134000L, 0, 48), new StoneLayerOre(Materials.Lazurite, 1134000L, 0, 48), new StoneLayerOre(Materials.Pyrite, 1134000L, 0, 48)});
            ev.addCollisionTopBottom(GTCoreBlocks.BLACK_GRANITE.getState(), GTCoreBlocks.BASALT.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Diamond, 283500L, -64, -32), new StoneLayerOre(Materials.Graphite, 2268000L, -64, -32)});
            ev.addCollisionBothSides(GTCoreBlocks.BLACK_GRANITE.getState(), VanillaStoneTypes.GRANITE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Zircon, 756000L, 0, 32)});
            ev.addCollisionBothSides(GTCoreBlocks.BLACK_GRANITE.getState(), GTCoreBlocks.RED_GRANITE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Zircon, 756000L, 0, 32)});
        }
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("coal")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Coal).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("lignite")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Lignite).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("salt")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Salt).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("sylvite")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Sylvite).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("bauxite")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Bauxite).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.stoneLayer(new StoneLayerBuilder(WorldGenLoader.id("oil_shale")).withStone(((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.OilShale).asState()).withWeight(1).inDimensions(overworld).buildVein());
        ev.addCollisionBothSides(GTCoreBlocks.BASALT.getState(), GTCoreBlocks.LIMESTONE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Ilmenite, 2268000L, -64, 0), new StoneLayerOre(Materials.Rutile, 1512000L, -64, 0)});
    }

    private static void initOreVeins(GTWorldGenEvent ev) {
        ArrayList<Object> overworld = new ArrayList<Object>();
        if (!GTAPI.isModLoaded((String)"tfc") && !GT5RConfig.GT6_ORE_GEN.get()) {
            overworld.add(Level.f_46428_);
        }
        if (!GT5RConfig.GT6_ORE_GEN.get()) {
            overworld.add(JAMD_MINING);
        }
        List<ResourceKey<Level>> mars = List.of(BE_MARS, AA_MARS);
        List<ResourceKey<Level>> moon = List.of(BE_MOON, AA_MOON);
        ev.vein(new VeinBuilder(WorldGenLoader.id("gold")).asOreVein(-4, 26, 160, 3, 32, Materials.Magnetite, Materials.Magnetite, Materials.VanadiumMagnetite, Materials.Gold, new ResourceKey[0]).inDimensions(moon).inDimensions(mars).inDimensions(overworld).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("iron")).asOreVein(-14, 51, 120, 4, 24, Materials.BrownLimonite, Materials.YellowLimonite, Materials.Hematite, Materials.Malachite, new ResourceKey[0]).inDimensions(overworld).inDimension(Level.f_46429_).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("cassiterite")).asOreVein(6, 126, 50, 5, 24, Materials.Tin, Materials.Tin, Materials.Cassiterite, Materials.Tin, new ResourceKey[0]).inDimensions(overworld).inDimension(Level.f_46430_).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("tetrahedrite")).asOreVein(51, 131, 70, 4, 24, Materials.Tetrahedrite, Materials.Tetrahedrite, Materials.Copper, Materials.Stibnite, new ResourceKey[0]).inDimensions(overworld).inDimension(Level.f_46429_).inDimensions(moon).inDimensions(mars).buildVein());
        Material sporadic = !GTLibConfig.STONE_LAYERS.get() ? Materials.Calcite : Materials.Alumina;
        ev.vein(new VeinBuilder(WorldGenLoader.id("magnetite")).asOreVein(-14, 91, 160, 3, 32, Materials.Magnetite, Materials.Magnetite, Materials.Iron, Materials.VanadiumMagnetite, new ResourceKey[0]).inDimensions(overworld).inDimension(Level.f_46429_).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("copper_nether")).asOreVein(10, 30, 80, 4, 24, Materials.Chalcopyrite, Materials.Iron, Materials.Pyrite, Materials.Copper, new ResourceKey[0]).inDimension(Level.f_46429_).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("copper")).asOreVein(-30, 0, 80, 4, 24, Materials.Chalcopyrite, Materials.Iron, Materials.Pyrite, Materials.Copper, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("salts")).asOreVein(51, 66, 50, 3, 24, Materials.Sylvite, Materials.Salt, Materials.Lepidolite, Materials.Spodumene, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("redstone")).asOreVein(-54, -9, 60, 3, 24, Materials.Redstone, Materials.Redstone, Materials.Ruby, Materials.Cinnabar, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("pitchblend")).asOreVein(-54, -9, 20, 3, 20, Materials.Pitchblende, Materials.Pitchblende, Materials.Uraninite, Materials.Uraninite, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("soapstone")).asOreVein(-54, -9, 40, 3, 16, Materials.Soapstone, Materials.Talc, Materials.Glauconite, Materials.Pentlandite, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("nickel")).asOreVein(11, 56, 40, 3, 16, Materials.Garnierite, Materials.Nickel, Materials.Cobaltite, Materials.Pentlandite, new ResourceKey[0]).inDimensions(overworld).inDimensions(new ResourceKey[]{Level.f_46429_, Level.f_46430_}).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("platinum")).asOreVein(-24, -9, 5, 3, 16, Materials.Sheldonite, Materials.Sperrylite, Materials.Platinum, Materials.Iridium, new ResourceKey[0]).inDimensions(overworld).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("monazite")).asOreVein(-44, -14, 30, 3, 16, Materials.Bastnasite, Materials.Bastnasite, Materials.Monazite, Materials.Neodymium, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("molybdenum")).asOreVein(-44, 1, 5, 3, 16, Materials.Wulfenite, Materials.Molybdenite, Materials.Molybdenum, Materials.Powellite, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("tungstate")).asOreVein(-44, 1, 10, 3, 16, Materials.Scheelite, Materials.Scheelite, Materials.Tungstate, Materials.Lithium, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("sapphire")).asOreVein(-54, -9, 60, 3, 16, Materials.Almandine, Materials.Pyrope, Materials.Sapphire, Materials.GreenSapphire, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("manganese")).asOreVein(-44, -29, 20, 3, 16, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).buildVein());
        Material third = Materials.CertusQuartz.enabled ? Materials.CertusQuartz : Materials.Barite;
        ev.vein(new VeinBuilder(WorldGenLoader.id("quartz")).asOreVein(6, 66, 60, 3, 16, Materials.MilkyQuartz, Materials.Barite, third, third, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("diamond")).asOreVein(-59, -48, 40, 2, 16, Materials.Graphite, Materials.Graphite, Materials.Diamond, Materials.Coal, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("diamond_nether")).asOreVein(5, 10, 40, 2, 16, Materials.Graphite, Materials.Graphite, Materials.Diamond, Materials.Coal, new ResourceKey[0]).inDimension(Level.f_46429_).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("olivine")).asOreVein(-54, -9, 60, 3, 16, Materials.Bentonite, Materials.Magnesite, Materials.Olivine, Materials.Glauconite, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("apatite")).asOreVein(-4, 41, 60, 3, 16, Materials.Apatite, Materials.Apatite, Materials.TricalciumPhosphate, Materials.Phosphate, new ResourceKey[0]).inDimensions(overworld).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("galena")).asOreVein(6, 51, 40, 5, 16, Materials.Galena, Materials.Galena, Materials.Silver, Materials.Lead, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("lapis")).asOreVein(-44, 1, 40, 5, 16, Materials.Lazurite, Materials.Sodalite, Materials.Lapis, sporadic, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("beryllium")).asOreVein(-59, -21, 30, 3, 16, Materials.Beryllium, Materials.Beryllium, Materials.Emerald, Materials.Thorium, new ResourceKey[0]).inDimensions(overworld).inDimensions(moon).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("naquadah")).asOreVein(10, 60, 10, 5, 32, Materials.Naquadah, Materials.Naquadah, Materials.Naquadah, Materials.Naquadah, new ResourceKey[0]).inDimension(Level.f_46430_).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("nether_quartz")).asOreVein(40, 80, 80, 5, 24, Materials.Quartz, Materials.Quartz, Materials.Quartz, Materials.Quartz, new ResourceKey[]{Level.f_46429_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("sulfur")).asOreVein(5, 20, 100, 5, 24, Materials.Sulfur, Materials.Sulfur, Materials.Pyrite, Materials.Sphalerite, new ResourceKey[0]).inDimension(Level.f_46429_).inDimensions(mars).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("redstone_nether")).asOreVein(10, 40, 60, 3, 24, Materials.Redstone, Materials.Redstone, Materials.Ruby, Materials.Cinnabar, new ResourceKey[]{Level.f_46429_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("platinum_end")).asOreVein(40, 50, 5, 3, 16, Materials.Sheldonite, Materials.Sperrylite, Materials.Platinum, Materials.Iridium, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("molybdenum_end")).asOreVein(20, 50, 5, 3, 16, Materials.Wulfenite, Materials.Molybdenite, Materials.Molybdenum, Materials.Powellite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("tungstate_end")).asOreVein(20, 50, 10, 3, 16, Materials.Scheelite, Materials.Scheelite, Materials.Tungstate, Materials.Lithium, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("manganese_end")).asOreVein(20, 30, 20, 3, 16, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("olivine_end")).asOreVein(10, 40, 60, 3, 16, Materials.Bentonite, Materials.Magnesite, Materials.Olivine, Materials.Glauconite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("lapis_end")).asOreVein(20, 50, 40, 5, 16, Materials.Lazurite, Materials.Sodalite, Materials.Lapis, sporadic, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new VeinBuilder(WorldGenLoader.id("beryllium_end")).asOreVein(5, 30, 30, 3, 16, Materials.Beryllium, Materials.Beryllium, Materials.Emerald, Materials.Thorium, new ResourceKey[]{Level.f_46430_}).buildVein());
        if (GT5RConfig.GT6_ORE_GEN.get()) {
            return;
        }
        ArrayList<Object> overworldTFCStoneLayers = new ArrayList<Object>();
        if (!GTAPI.isModLoaded((String)"tfc") && !GT5RConfig.DEFAULT_STONE_LAYERS.get()) {
            overworldTFCStoneLayers.add(Level.f_46428_);
        }
        if (!GT5RConfig.DEFAULT_STONE_LAYERS.get()) {
            overworldTFCStoneLayers.add(JAMD_MINING);
        }
        if (!overworldTFCStoneLayers.isEmpty()) {
            ev.vein(new VeinBuilder(WorldGenLoader.id("bauxite")).asOreVein(-14, 46, 80, 4, 24, Materials.Bauxite, Materials.Bauxite, Materials.Alumina, Materials.Ilmenite, new ResourceKey[0]).inDimensions(overworldTFCStoneLayers).inDimensions(moon).inDimensions(mars).buildVein());
            ev.vein(new VeinBuilder(WorldGenLoader.id("oilshale")).asOreVein(-14, 31, 80, 6, 32, Materials.OilShale, Materials.OilShale, Materials.OilShale, Materials.OilShale, new ResourceKey[0]).inDimensions(overworldTFCStoneLayers).buildVein());
            ev.vein(new VeinBuilder(WorldGenLoader.id("lignite")).asOreVein(0, 200, 160, 8, 32, Materials.Lignite, Materials.Lignite, Materials.Lignite, Materials.Coal, new ResourceKey[0]).inDimensions(overworldTFCStoneLayers).buildVein());
            ev.vein(new VeinBuilder(WorldGenLoader.id("coal")).asOreVein(0, 200, 80, 6, 32, Materials.Coal, Materials.Coal, Materials.Coal, Materials.Lignite, new ResourceKey[0]).inDimensions(overworldTFCStoneLayers).buildVein());
        }
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("gt5r", id);
    }
}

