/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemBreederRod
extends ItemBasic<ItemBreederRod>
implements IItemReactorRod,
IMaterialObject {
    private final Material material;
    private final Supplier<Item> enrichedRod;
    private final int loss;
    private final long needed;

    public ItemBreederRod(String domain, Material material, Supplier<Item> enrichedRod, int loss, long needed) {
        super(domain, material.getId() + "_breeder_rod", new Item.Properties().m_41487_(16).m_41491_(Ref.TAB_ITEMS));
        this.material = material;
        this.enrichedRod = enrichedRod;
        this.loss = loss;
        this.needed = needed;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.breeder_rod.enriched", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.1", (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.2", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.1", (Object[])new Object[0]).m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.3", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.breeder_rod.loss", (Object[])new Object[0]).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.4", (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.5", (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.6", (Object[])new Object[]{this.enrichedRod.get().m_7968_().m_41786_().m_6881_().m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
        long needed = stack.m_41783_() != null && stack.m_41783_().m_128441_("neededNeutrons") ? stack.m_41783_().m_128454_("neededNeutrons") : this.needed;
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.7", (Object[])new Object[]{Utils.literal((String)("" + needed)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.breeder_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.breeder_rod.8", (Object[])new Object[]{Utils.literal((String)("" + this.loss)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.breeder_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.AQUA));
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture("gt5r", "item/basic/nuclear_fuel_rod"), new Texture("gt5r", "item/basic/empty_nuclear_fuel_rod")};
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 0 && this.material != Material.NULL) {
            return this.material.getRGB();
        }
        return IItemReactorRod.super.getItemColor(stack, block, i);
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public boolean isReactorRod(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isModerated(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return false;
    }

    @Override
    public void updateModeration(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
    }

    @Override
    public int getReactorRodNeutronEmission(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        long needed;
        reactor.heatHandler.ifPresent(h -> h.insertInternal(reactor.oNeutronCounts[slot] / 2, false));
        long l = needed = stack.m_41783_() != null && stack.m_41783_().m_128441_("neededNeutrons") ? stack.m_41783_().m_128454_("neededNeutrons") : this.needed;
        if ((needed -= (long)reactor.oNeutronCounts[slot]) <= 0L) {
            reactor.setRod(slot, new ItemStack((ItemLike)this.enrichedRod.get()));
        } else {
            stack.m_41784_().m_128356_("neededNeutrons", needed);
        }
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack, int neutrons, boolean moderated) {
        if (!moderated && neutrons > this.loss) {
            int n = slot;
            reactor.mNeutronCounts[n] = reactor.mNeutronCounts[n] + (neutrons - this.loss);
        }
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }
}

