/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.integration.jei.OreProcessingCategory;
import org.gtreimagined.gt5r.integration.xei.OreByProduct;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;

@JeiPlugin
public class GT5RJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("gt5r", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (GTAPI.isModLoaded((String)"roughlyenoughitems")) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new OreProcessingCategory()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.MACERATOR.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.ORE_WASHER.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.CENTRIFUGE.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.THERMAL_CENTRIFUGE.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.BATH.getItem(Tier.NONE)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.ELECTROMAGNETIC_SEPARATOR.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)GT5RMachines.SIFTER.getItem(Tier.LV)), new RecipeType[]{OreProcessingCategory.ORE_BYPRODUCTS});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList oreByProducts = new ArrayList();
        GTMaterialTypes.ORE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE})) {
                return;
            }
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.BATH_PERSULFATE}) || m.has(new IMaterialTag[]{GT5RMaterialTags.BATH_MERCURY})) {
                if (m.has(new IMaterialTag[]{GT5RMaterialTags.BATH_MERCURY})) {
                    oreByProducts.add(new OreByProduct((Material)m, OreByProduct.BathingMode.MERCURY));
                }
                if (m.has(new IMaterialTag[]{GT5RMaterialTags.BATH_PERSULFATE})) {
                    oreByProducts.add(new OreByProduct((Material)m, OreByProduct.BathingMode.PERSULFATE));
                }
            } else {
                oreByProducts.add(new OreByProduct((Material)m, OreByProduct.BathingMode.NONE));
            }
        });
        registration.addRecipes(OreProcessingCategory.ORE_BYPRODUCTS, oreByProducts);
    }
}

