/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.forge.tfc;

import java.util.function.BiConsumer;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.forge.tfc.MachineRecipes;
import org.gtreimagined.gt5r.integration.forge.tfc.datagen.TFCBlockTagProvider;
import org.gtreimagined.gt5r.integration.forge.tfc.datagen.TFCItemTagProvider;
import org.gtreimagined.gt5r.integration.forge.tfc.datagen.TFCLangProvider;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTMod;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTFluidTagProvider;
import org.gtreimagined.gtlib.event.GTLoaderEvent;
import org.gtreimagined.gtlib.event.GTProvidersEvent;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeFluid;
import org.gtreimagined.gtlib.material.TextureSet;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.loader.IRecipeRegistrate;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourBlockTilling;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourLogStripping;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourVanillaShovel;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;

public class TFCRegistrar
extends GTMod {
    public static Material[] array;

    public TFCRegistrar() {
        if (this.isEnabled()) {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
            MinecraftForge.EVENT_BUS.addListener(this::registerRecipeLoaders);
            GTLibDynamics.clientProvider((String)"gt5r", () -> new TFCLangProvider("gt5r", "TFC en_us Lang", "en_us"));
        }
    }

    public String getId() {
        return "tfc";
    }

    public void onRegistrationEvent(RegistrationEvent event, Dist side) {
        if (event == RegistrationEvent.DATA_INIT) {
            array = new Material[]{Materials.Bauxite, Materials.Cobaltite, Materials.Galena, Materials.Uraninite, Materials.VanadiumMagnetite, Materials.BrownLimonite, Materials.Hematite, Materials.Sheldonite, Materials.Sperrylite};
            Helpers.mapOfKeys(Rock.class, rock -> {
                Material material = Material.get((String)rock.name().toLowerCase());
                if (material == Material.NULL) {
                    material = (Material)GTAPI.register(Material.class, (IGTObject)new Material("gt5r", rock.name().toLowerCase(), rock.color().f_76396_, TextureSet.NONE, new String[0]));
                    material.flags(new IMaterialTag[]{GTMaterialTypes.DUST});
                }
                GTAPI.register(StoneType.class, (IGTObject)new StoneType("gt5r", "raw_" + rock.name().toLowerCase(), material, new Texture("tfc", "block/rock/raw/" + rock.name().toLowerCase()), SoundType.f_56742_, false).setStateSupplier(() -> ((Block)rock.getBlock(Rock.BlockType.RAW).get()).m_49966_()).setHardnessAndResistance(rock.category().hardness(6.5f), 10.0f).setHarvestLevel(1));
                GTAPI.register(StoneType.class, (IGTObject)new StoneType("gt5r", rock.name().toLowerCase() + "_gravel", material, new Texture("tfc", "block/rock/gravel/" + rock.name().toLowerCase()), SoundType.f_56739_, false).setSandLike(true).setHardnessAndResistance(rock.category().hardness(2.0f)).setStateSupplier(() -> ((Block)rock.getBlock(Rock.BlockType.GRAVEL).get()).m_49966_()).setHarvestLevel(1).setRequiresTool(true));
                return true;
            });
            Helpers.mapOfKeys(SandBlockType.class, sand -> {
                Material material = Material.get((String)(sand.name().toLowerCase() + "_sand"));
                if (material == Material.NULL) {
                    material = (Material)GTAPI.register(Material.class, (IGTObject)new Material("gt5r", sand.name().toLowerCase() + "_sand", sand.getDustColor(), TextureSet.NONE, new String[0]));
                    material.flags(new IMaterialTag[]{GTMaterialTypes.DUST});
                }
                ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new StoneType("gt5r", sand.name().toLowerCase() + "_sand", material, new Texture("tfc", "block/sand/" + sand.name().toLowerCase()), SoundType.f_56746_, false))).setSandLike(true).setRequiresTool(true).setFallingDustColor(sand.getDustColor()).setStateSupplier(() -> RegistryUtils.getBlockFromId((String)"tfc", (String)("sand/" + sand.name().toLowerCase())).m_49966_());
                GTAPI.register(StoneType.class, (IGTObject)new StoneType("gt5r", sand.name().toLowerCase() + "_raw_sandstone", material, new Texture("tfc", "block/sandstone/bottom/" + sand.name().toLowerCase()), SoundType.f_56746_, false).setStateSupplier(() -> RegistryUtils.getBlockFromId((String)"tfc", (String)("raw_sandstone/" + sand.name().toLowerCase())).m_49966_()));
                return true;
            });
            GTMaterialTypes.LIQUID.set((m, i) -> {
                if (m == null || !GTMaterialTypes.LIQUID.allowGen(m)) {
                    return MaterialTypeFluid.getEmptyFluidAndLog((MaterialType)GTMaterialTypes.LIQUID, (IGTObject[])new IGTObject[]{m});
                }
                if (m.getId().equals("water")) {
                    return new FluidStack((Fluid)Fluids.f_76193_, i);
                }
                if (m.getId().equals("lava")) {
                    return new FluidStack((Fluid)Fluids.f_76195_, i);
                }
                if (m == Materials.SaltWater) {
                    return new FluidStack((Fluid)TFCFluids.SALT_WATER.getSource(), i);
                }
                GTFluid fluid = (GTFluid)GTAPI.get(GTFluid.class, (String)(GTMaterialTypes.LIQUID.getId() + "_" + m.getId()));
                if (fluid == null) {
                    throw new IllegalStateException("Tried to get null fluid");
                }
                return new FluidStack((Fluid)fluid.getFluid(), i);
            });
            Helpers.mapOfKeys(Wood.class, wood -> {
                Block log = RegistryUtils.getBlockFromId((String)"tfc", (String)("wood/log/" + wood.name().toLowerCase()));
                Block log_stripped = RegistryUtils.getBlockFromId((String)"tfc", (String)("wood/stripped_log/" + wood.name().toLowerCase()));
                BehaviourLogStripping.addStrippedBlock((Block)log, (Block)log_stripped);
                return true;
            });
            Helpers.mapOfKeys(SoilBlockType.class, soil -> {
                switch (soil) {
                    case DIRT: 
                    case GRASS: 
                    case CLAY: 
                    case CLAY_GRASS: {
                        for (SoilBlockType.Variant vary : SoilBlockType.Variant.values()) {
                            Block dirt = RegistryUtils.getBlockFromId((String)"tfc", (String)(soil.name().toLowerCase() + "/" + vary.name().toLowerCase()));
                            Block farmland = RegistryUtils.getBlockFromId((String)"tfc", (String)("farmland/" + vary.name().toLowerCase()));
                            BehaviourBlockTilling.addStrippedBlock((Block)dirt, (Block)farmland);
                        }
                        break;
                    }
                    case ROOTED_DIRT: {
                        for (SoilBlockType.Variant vary : SoilBlockType.Variant.values()) {
                            Block rootdirt = RegistryUtils.getBlockFromId((String)"tfc", (String)(soil.name().toLowerCase() + "/" + vary.name().toLowerCase()));
                            Block dirt = RegistryUtils.getBlockFromId((String)"tfc", (String)("dirt/" + vary.name().toLowerCase()));
                            BehaviourBlockTilling.addStrippedBlock((Block)rootdirt, (Block)dirt);
                        }
                        break;
                    }
                }
                return true;
            });
            Helpers.mapOfKeys(SoilBlockType.class, path -> {
                if (path == SoilBlockType.GRASS_PATH) {
                    for (SoilBlockType.Variant vary : SoilBlockType.Variant.values()) {
                        Block grasstype = RegistryUtils.getBlockFromId((String)"tfc", (String)("grass/" + vary.name().toLowerCase()));
                        Block pathtype = RegistryUtils.getBlockFromId((String)"tfc", (String)("grass_path/" + vary.name().toLowerCase()));
                        BehaviourVanillaShovel.addStrippedBlock((Block)grasstype, (Block)pathtype);
                    }
                }
                return true;
            });
        }
    }

    public int getPriority() {
        return 0;
    }

    public void registerRecipeLoaders(GTLoaderEvent event) {
        BiConsumer<String, IRecipeRegistrate.IRecipeLoader> loader = (a, b) -> event.registrat.add("gt5r", a, b);
        loader.accept("tfc_machine_recipes", MachineRecipes::init);
    }

    @SubscribeEvent
    public void onProviders(GTProvidersEvent ev) {
        ev.addProvider(() -> new GTFluidTagProvider("tfc", "TFC Fluid Tags", false){

            protected void processTags(String domain) {
                super.processTags(domain);
                this.tag(TagUtils.getForgelikeFluidTag((String)"salt_water")).add((Object)TFCFluids.SALT_WATER.getSource());
            }
        });
        GTBlockTagProvider[] blockTagProviders = new GTBlockTagProvider[]{new TFCBlockTagProvider("tfc", "TFC Block Tags", false)};
        ev.addProvider(() -> new TFCItemTagProvider("tfc", "TFC Item Tags", false, blockTagProviders[0]));
        ev.addProvider(() -> blockTagProviders[0]);
    }

    public boolean isEnabled() {
        return GTAPI.isModLoaded((String)"tfc");
    }
}

