/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.data;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityAssemblyLine;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityBasicAssemblyLine;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityBedrockDrill;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityCokeOven;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityCombustionEngine;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityDistillationTower;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityElectricBlastFurnace;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityFusionReactor;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityImplosionCompressor;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeAutoclave;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeBath;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeBoiler;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeCentrifuge;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeChemicalReactor;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeElectrolyzer;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeHeatExchanger;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeMacerator;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeOreWasher;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeSifter;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeTurbine;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLongDistancePipeEndpoint;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityMultiSmelter;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityOilCrackingUnit;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityOilDrillingRig;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityOreMiningRig;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityPrimitiveBlastFurnace;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityProcessingArray;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityPyrolysisOven;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityTreeGrowthSimulator;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityVacuumFreezer;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityAssembler;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityAutocrafter;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityBath;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityBuffer;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityCoalBoiler;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityCropHarvester;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityFluxTransformer;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityHighCapacityInputHatch;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityHighCapacityOutputHatch;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityHull;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityIUpgradedBatchMachine;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityInputBus;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityInputHatch;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityItemFilter;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityLavaBoiler;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityMacerator;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityPrinter;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityPump;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityRockBreaker;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityScanner;
import org.gtreimagined.gt5r.blockentity.single.BlockEntitySeismicProspector;
import org.gtreimagined.gt5r.blockentity.single.BlockEntitySolarBoiler;
import org.gtreimagined.gt5r.blockentity.single.BlockEntitySolarPanel;
import org.gtreimagined.gt5r.blockentity.single.BlockEntitySteamTurbine;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityTypeFilter;
import org.gtreimagined.gt5r.blockentity.single.bridge.BlockEntityInventoryBridge;
import org.gtreimagined.gt5r.blockentity.single.bridge.BlockEntityInventoryTankBridge;
import org.gtreimagined.gt5r.blockentity.single.bridge.BlockEntityTankBridge;
import org.gtreimagined.gt5r.blockentity.single.bridge.BlockEntityUniversalBridge;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityInventoryExtender;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityInventoryTankExtender;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityTankExtender;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityUniversalExtender;
import org.gtreimagined.gt5r.blockentity.single.miniportals.BlockEntityMiniEndPortal;
import org.gtreimagined.gt5r.blockentity.single.miniportals.BlockEntityMiniJAMDPortal;
import org.gtreimagined.gt5r.blockentity.single.miniportals.BlockEntityMiniNetherPortal;
import org.gtreimagined.gt5r.blockentity.single.miniportals.BlockEntityMiniTwilightPortal;
import org.gtreimagined.gt5r.client.GT5RModelManager;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RSounds;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.data.Textures;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gt5r.machine.BridgeMachine;
import org.gtreimagined.gt5r.machine.ExtenderMachine;
import org.gtreimagined.gt5r.machine.HeatExchangerMachine;
import org.gtreimagined.gt5r.machine.MiniPortalMachine;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreCovers;
import org.gtreimagined.gtcore.machine.DrumMachine;
import org.gtreimagined.gtcore.machine.MultiblockTankMachine;
import org.gtreimagined.gtcore.machine.SteamMachine;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityBatteryBuffer;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityDigitalTransformer;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityTransformer;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.GeneratorMachine;
import org.gtreimagined.gtlib.machine.types.HatchMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.machine.types.MultiMachine;
import org.gtreimagined.gtlib.machine.types.TankMachine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Dir;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class GT5RMachines {
    public static BasicMachine HULL = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "hull").setTiers(Tier.getAllElectric())).setOverlayTextures(Textures.STATE_IGNORANT_TIER_SPECIFIC_OVERLAY_HANDLER)).setNoOutputCover()).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityHull::new)).addTooltipInfo((machine, stack, world, tooltip, flag) -> {
        tooltip.remove(tooltip.size() - 1);
        tooltip.remove(tooltip.size() - 1);
        tooltip.add(Utils.translatable((String)"machine.voltage.in", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)(machine.getTier().getVoltage() + " (" + machine.getTier().getId().toUpperCase() + ")"))).m_130940_(ChatFormatting.GREEN));
        tooltip.add(Utils.translatable((String)"machine.voltage.out", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)(machine.getTier().getVoltage() + " (" + machine.getTier().getId().toUpperCase() + ")"))).m_130940_(ChatFormatting.GREEN));
        tooltip.add(Utils.translatable((String)"machine.power.capacity", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)String.valueOf(512L + machine.getTier().getVoltage() * 8L))).m_130940_(ChatFormatting.BLUE));
    });
    public static SteamMachine SOLID_FUEL_BOILER = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "solid_fuel_boiler").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).setMap(RecipeMaps.SOLID_FUEL_BOILERS, new Tier[0])).addFlags(new String[]{"gui", "steam", "item", "fluid", "cell"})).setBaseTexture(Textures.BRICKED_HANDLER)).setTile(BlockEntityCoalBoiler::new)).setNoOutputCover()).addTooltipInfo("tooltip.gt5r.boiler");
    public static SteamMachine LAVA_BOILER = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "lava_boiler").setTiers(new Tier[]{Tier.STEEL})).addFlags(new String[]{"gui", "steam", "item", "fluid"})).setBaseTexture(Textures.BRICKED_HANDLER)).setTile(BlockEntityLavaBoiler::new)).setNoOutputCover()).addTooltipInfo("tooltip.gt5r.boiler");
    public static SteamMachine SOLAR_BOILER = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "solar_boiler").setTiers(new Tier[]{Tier.BRONZE})).addFlags(new String[]{"gui", "steam", "item", "fluid"})).setBaseTexture(Textures.BRICKED_HANDLER)).setTile(BlockEntitySolarBoiler::new)).setAllowsFrontIO()).setNoOutputCover()).addTooltipInfo("tooltip.gt5r.boiler");
    public static SteamMachine STEAM_ALLOY_SMELTER = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_alloy_smelter").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setBaseTexture(Textures.BRICKED_HANDLER)).setSound(GT5RSounds.FURNACE, 0.6f)).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static SteamMachine STEAM_COMPRESSOR = (SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_compressor").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static SteamMachine STEAM_EXTRACTOR = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_extractor").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setSound(GT5RSounds.EXTRACTOR, 0.6f)).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static SteamMachine STEAM_FORGE_HAMMER = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_forge_hammer").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setOutputCover(GTCoreCovers.COVER_STEAM_VENT)).setSound(SoundEvents.f_11669_, 0.6f);
    public static SteamMachine STEAM_FURNACE = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_furnace").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setBaseTexture(Textures.BRICKED_HANDLER)).setSound(GT5RSounds.FURNACE, 0.6f)).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static SteamMachine STEAM_MACERATOR = (SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_macerator").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).setMap(RecipeMaps.MACERATOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setOutputCover(GTCoreCovers.COVER_STEAM_VENT)).setSound(GT5RSounds.MACERATOR, 0.6f);
    public static SteamMachine STEAM_CUTTER = (SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_cutter").setEuMultiplier(1).setDurationMultiplier(2).setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static SteamMachine STEAM_SIFTER = (SteamMachine)((SteamMachine)((SteamMachine)new SteamMachine("gt5r", "steam_sifter").setTiers(new Tier[]{Tier.BRONZE, Tier.STEEL})).addFlags(new String[]{"gui", "item", "fluid"})).setOutputCover(GTCoreCovers.COVER_STEAM_VENT);
    public static BasicMultiMachine<?> COKE_OVEN = (BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)new BasicMultiMachine("gt5r", "coke_oven").setTiers(new Tier[]{Tier.NONE})).setMap(RecipeMaps.COKE_OVEN, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityCokeOven::new);
    public static BasicMultiMachine<?> PRIMITIVE_BLAST_FURNACE = (BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)new BasicMultiMachine("gt5r", "primitive_blast_furnace").setTiers(new Tier[]{Tier.NONE})).setMap(RecipeMaps.PRIMITIVE_BLAST_FURNACE, new Tier[0])).addFlags(new String[]{"gui", "item"})).setTile(BlockEntityPrimitiveBlastFurnace::new);
    public static BasicMachine ALLOY_SMELTER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "alloy_smelter").setMap(RecipeMaps.ALLOY_SMELTER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.FURNACE, 0.6f);
    public static BasicMachine ARC_FURNACE = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "arc_furnace").setMap(RecipeMaps.ARC_FURNACE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setSound(GT5RSounds.FURNACE, 0.6f)).setAmps(3);
    public static BasicMachine ASSEMBLER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "assembler").setMap(RecipeMaps.ASSEMBLER, new Tier[0])).setTile(BlockEntityAssembler::new)).addFlags(new String[]{"gui", "item", "fluid"})).setCustomModel();
    public static BasicMachine AUTOCLAVE = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "autoclave").setMap(RecipeMaps.AUTOCLAVE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine AUTOCRAFTER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "autocrafter").addFlags(new String[]{"gui", "item", "recipe"})).setTile(BlockEntityAutocrafter::new);
    public static BasicMachine BENDER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "bender").setMap(RecipeMaps.BENDER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine CANNER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "canner").setMap(RecipeMaps.CANNER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine CENTRIFUGE = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "centrifuge").setMap(RecipeMaps.CENTRIFUGE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine BATH = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "bath").setTiers(new Tier[]{Tier.NONE})).removeFlags(new String[]{"eu"})).setMap(RecipeMaps.BATH, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityBath::new)).setBaseTexture(new Texture("gt5r", "block/machine/base/hv"));
    public static BasicMachine DEHYDRATOR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "dehydrator").setMap(RecipeMaps.DEHYDRATOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityIUpgradedBatchMachine::new)).addTooltipInfo((machine, stack, world, tooltip, flag) -> tooltip.add(Utils.translatable((String)"machine.upgraded_batch.parallel", (Object[])new Object[]{1 << machine.getTier().getIntegerId() - 1})));
    public static BasicMachine CHEMICAL_REACTOR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "chemical_reactor").setMap(RecipeMaps.CHEMICAL_REACTOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setRendersContainedLiquids(true)).setCustomModel();
    public static BasicMachine CIRCUIT_ASSEMBLER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "circuit_assembler").setTiers(Tier.getStandardWithIV())).setMap(RecipeMaps.CIRCUIT_ASSEMBLER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine COMPRESSOR = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "compressor").setMap(RecipeMaps.COMPRESSOR, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine CRYSTALLIZATION_CHAMBER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "crystallization_chamber").setMap(RecipeMaps.CRYSTALLIZATION_CHAMBER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setAmps(3);
    public static BasicMachine CUTTER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "cutter").setMap(RecipeMaps.CUTTER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine DISASSEMBLER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "disassembler").setMap(RecipeMaps.DISASSEMBLER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setCustomModel();
    public static BasicMachine DISTILLERY = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "distillery").setMap(RecipeMaps.DISTILLERY, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setCustomModel()).setRendersContainedLiquids(true)).setSound(GT5RSounds.EXTRACTOR, 0.6f);
    public static BasicMachine ELECTRIC_OVEN = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electric_oven").setMap(RecipeMaps.ELECTRIC_OVEN, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.FURNACE, 0.6f);
    public static BasicMachine ELECTROLYZER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electrolyzer").setMap(RecipeMaps.ELECTROLYZER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setSound(GT5RSounds.MAGNETIZER, 0.6f);
    public static BasicMachine ELECTROMAGNETIC_SEPARATOR = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electromagnetic_separator").setMap(RecipeMaps.ELECTROMAGNETIC_SEPARATOR, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine EXTRACTOR = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "extractor").setMap(RecipeMaps.EXTRACTOR, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.EXTRACTOR, 0.6f);
    public static BasicMachine EXTRUDER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "extruder").setMap(RecipeMaps.EXTRUDER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setCustomModel();
    public static BasicMachine FERMENTER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "fermenter").setMap(RecipeMaps.FERMENTER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setCustomModel()).setRendersContainedLiquids(true);
    public static BasicMachine FLUID_CANNER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "fluid_canner").setMap(RecipeMaps.FLUID_CANNER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setSound(GT5RSounds.EXTRACTOR, 0.6f);
    public static BasicMachine FLUID_PRESS = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "fluid_press").setMap(RecipeMaps.FLUID_PRESS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine FLUID_HEATER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "fluid_heater").setMap(RecipeMaps.FLUID_HEATER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine FLUID_SOLIDIFIER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "fluid_solidifier").setMap(RecipeMaps.FLUID_SOLIDIFYER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setSound(GT5RSounds.EXTRACTOR, 0.6f);
    public static BasicMachine FORGE_HAMMER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "forge_hammer").setMap(RecipeMaps.FORGE_HAMMER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(SoundEvents.f_11669_, 0.6f);
    public static BasicMachine FORMING_PRESS = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "forming_press").setMap(RecipeMaps.FORMING_PRESS, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine FURNACE = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "furnace").setMap(RecipeMaps.ELECTRIC_FURNACE, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.FURNACE, 0.6f);
    public static BasicMachine LASER_ENGRAVER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "laser_engraver").setMap(RecipeMaps.LASER_ENGRAVER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.MAGNETIZER, 0.6f);
    public static BasicMachine LATHE = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "lathe").setMap(RecipeMaps.LATHE, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine MACERATOR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "macerator").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV})).setMap(RecipeMaps.PULVERIZER, new Tier[0])).setTile(BlockEntityMacerator::new)).addTooltipInfo("tooltip.macerator.0")).setTierSpecificLang()).setCustomModel()).addFlags(new String[]{"gui", "item"})).setSound(GT5RSounds.MACERATOR, 0.6f);
    public static BasicMachine MASS_FABRICATOR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "mass_fabricator").setTiers(Tier.getStandardWithIV())).setMap(RecipeMaps.MASS_FABRICATOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setNoOverclockCost(true);
    public static BasicMachine MIXER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "mixer").setMap(RecipeMaps.MIXER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine ORE_WASHER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "ore_washer").setMap(RecipeMaps.ORE_WASHER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine PACKAGER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "packager").setMap(RecipeMaps.PACKAGER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine POLARIZER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "polarizer").setMap(RecipeMaps.POLARIZER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine PRINTER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "printer").setTiers(new Tier[]{Tier.LV})).setMap(RecipeMaps.PRINTING, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityPrinter::new);
    public static BasicMachine ROASTER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "roaster").setMap(RecipeMaps.ROASTER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setAmps(3)).setTile(BlockEntityIUpgradedBatchMachine::new)).addTooltipInfo((machine, stack, world, tooltip, flag) -> tooltip.add(Utils.translatable((String)"machine.upgraded_batch.parallel", (Object[])new Object[]{1 << machine.getTier().getIntegerId() - 1})));
    public static BasicMachine RECYCLER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "recycler").setMap(RecipeMaps.RECYCLER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine REPLICATOR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "replicator").setTiers(Tier.getStandardWithIV())).setMap(RecipeMaps.REPLICATOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setNoOverclockCost(true);
    public static BasicMachine ROCK_BREAKER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "rock_breaker").setMap(RecipeMaps.ROCK_BREAKER, new Tier[0])).addFlags(new String[]{"gui", "item"})).setTile(BlockEntityRockBreaker::new);
    public static BasicMachine SCANNER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "scanner").setTiers(Tier.getStandardWithIV())).setMap(RecipeMaps.SCANNER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setTile(BlockEntityScanner::new)).setSound(GT5RSounds.MAGNETIZER, 0.6f);
    public static BasicMachine SEISMIC_PROSPECTOR = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "seismic_prospector").setTiers(new Tier[]{Tier.LV, Tier.EV})).setTile(BlockEntitySeismicProspector::new)).setOutputCover(ICover.emptyFactory);
    public static BasicMachine SIFTER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "sifter").setMap(RecipeMaps.SIFTER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine SMELTER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "smelter").setMap(RecipeMaps.SMELTER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"});
    public static BasicMachine THERMAL_CENTRIFUGE = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "thermal_centrifuge").setMap(RecipeMaps.THERMAL_CENTRIFUGE, new Tier[0])).addFlags(new String[]{"gui", "item"})).setAmps(2);
    public static BasicMachine UNPACKAGER = (BasicMachine)((BasicMachine)new BasicMachine("gt5r", "unpackager").setMap(RecipeMaps.UNPACKAGER, new Tier[0])).addFlags(new String[]{"gui", "item"});
    public static BasicMachine WIRE_MILL = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "wire_mill").setMap(RecipeMaps.WIRE_MILL, new Tier[0])).addFlags(new String[]{"gui", "item"})).setCustomModel();
    public static BasicMachine BATTERY_BUFFER_SIXTEEN = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "16x_battery_buffer").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV, Tier.UHV})).addFlags(new String[]{"gui", "eu", "item"})).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setNoOutputCover()).setTile(BlockEntityBatteryBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO();
    public static BasicMachine BATTERY_BUFFER_EIGHT = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "8x_battery_buffer").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV, Tier.UHV})).addFlags(new String[]{"gui", "eu", "item"})).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setNoOutputCover()).setTile(BlockEntityBatteryBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO();
    public static BasicMachine BATTERY_BUFFER_FOUR = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "4x_battery_buffer").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV, Tier.UHV})).addFlags(new String[]{"gui", "eu", "item"})).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setNoOutputCover()).setTile(BlockEntityBatteryBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO();
    public static BasicMachine BATTERY_BUFFER_ONE = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "1x_battery_buffer").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV, Tier.UHV})).addFlags(new String[]{"gui", "eu", "item"})).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setNoOutputCover()).setTile(BlockEntityBatteryBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO();
    public static BasicMachine ELECTRIC_ITEM_FILTER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electric_item_filter").setTiers(Tier.getStandardWithIV())).addFlags(new String[]{"gui", "eu", "item"})).setTile(BlockEntityItemFilter::new)).setNoOutputCover()).setAllowsFrontCovers()).setAllowsFrontIO()).setVerticalFacingAllowed(true)).setOverlayTextures(Textures.LEFT_RIGHT_HANDLER);
    public static BasicMachine ELECTRIC_TYPE_FILTER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electric_type_filter").setTiers(Tier.getStandardWithIV())).addFlags(new String[]{"gui", "eu", "item"})).setTile(BlockEntityTypeFilter::new)).setNoOutputCover()).setAllowsFrontCovers()).setAllowsFrontIO()).setVerticalFacingAllowed(true)).setOverlayTextures(Textures.LEFT_RIGHT_HANDLER);
    public static BasicMachine SUPER_BUFFER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "super_buffer").setTiers(Tier.getStandardWithIV())).addFlags(new String[]{"gui", "eu", "item"})).setTile(BlockEntityBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO()).setNoOutputCover()).setAllowsFrontCovers()).setOverlayTextures(Textures.LEFT_RIGHT_HANDLER);
    public static BasicMachine CHEST_BUFFER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "chest_buffer").setTiers(Tier.getStandardWithIV())).addFlags(new String[]{"gui", "eu", "item"})).setTile(BlockEntityBuffer::new)).setVerticalFacingAllowed(true)).setAllowsFrontIO()).setNoOutputCover()).setAllowsFrontCovers()).setOverlayTextures(Textures.LEFT_RIGHT_HANDLER);
    public static BasicMachine INVENTORY_BRIDGE = (BasicMachine)((BasicMachine)((BasicMachine)new BridgeMachine("gt5r", "inventory_bridge").addFlags(new String[]{"item"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityInventoryBridge::new);
    public static BasicMachine TANK_BRIDGE = (BasicMachine)((BasicMachine)((BasicMachine)new BridgeMachine("gt5r", "tank_bridge").addFlags(new String[]{"fluid"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityTankBridge::new);
    public static BasicMachine INVENTORY_TANK_BRIDGE = (BasicMachine)((BasicMachine)((BasicMachine)new BridgeMachine("gt5r", "inventory_tank_bridge").addFlags(new String[]{"item", "fluid"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityInventoryTankBridge::new);
    public static BasicMachine UNIVERSAL_BRIDGE = (BasicMachine)((BasicMachine)((BasicMachine)new BridgeMachine("gt5r", "universal_bridge").addFlags(new String[]{"item", "fluid"})).setBaseTexture(new Texture("gt5r", "block/machine/base/universal_bridge"))).setTile(BlockEntityUniversalBridge::new);
    public static BasicMachine INVENTORY_EXTENDER = (BasicMachine)((BasicMachine)((BasicMachine)new ExtenderMachine("gt5r", "inventory_extender").addFlags(new String[]{"item"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityInventoryExtender::new);
    public static BasicMachine TANK_EXTENDER = (BasicMachine)((BasicMachine)((BasicMachine)new ExtenderMachine("gt5r", "tank_extender").addFlags(new String[]{"fluid"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityTankExtender::new);
    public static BasicMachine INVENTORY_TANK_EXTENDER = (BasicMachine)((BasicMachine)((BasicMachine)new ExtenderMachine("gt5r", "inventory_tank_extender").addFlags(new String[]{"item", "fluid"})).removeFlags(new String[]{"eu"})).setTile(BlockEntityInventoryTankExtender::new);
    public static BasicMachine UNIVERSAL_EXTENDER = (BasicMachine)((BasicMachine)((BasicMachine)new ExtenderMachine("gt5r", "universal_extender").addFlags(new String[]{"item", "fluid"})).setBaseTexture(new Texture("gt5r", "block/machine/base/universal_bridge"))).setTile(BlockEntityUniversalExtender::new);
    public static DrumMachine BRONZE_DRUM = GTCoreBlocks.createDrum((Material)Materials.Bronze, (int)16000);
    public static DrumMachine STEEL_DRUM = GTCoreBlocks.createDrum((Material)Materials.Steel, (int)48000);
    public static DrumMachine INVAR_DRUM = GTCoreBlocks.createDrum((Material)Materials.Invar, (int)32000);
    public static DrumMachine STAINLESS_DRUM = GTCoreBlocks.createDrum((Material)Materials.StainlessSteel, (int)64000).acidProof();
    public static DrumMachine TITANIUM_DRUM = GTCoreBlocks.createDrum((Material)Materials.Titanium, (int)128000);
    public static DrumMachine NETHERRITE_DRUM = GTCoreBlocks.createDrum((Material)Materials.Netherite, (int)128000).acidProof();
    public static DrumMachine TUNGSTENSTEEL_DRUM = GTCoreBlocks.createDrum((Material)Materials.TungstenSteel, (int)256000);
    public static DrumMachine TUNGSTEN_DRUM = GTCoreBlocks.createDrum((Material)Materials.Tungsten, (int)256000);
    public static DrumMachine ADAMANTIUM = GTCoreBlocks.createDrum((Material)Materials.Adamantium, (int)4096000).acidProof();
    public static MultiblockTankMachine WOOD_TANK;
    public static MultiblockTankMachine[] STEEL_TANKS;
    public static MultiblockTankMachine[] INVAR_TANKS;
    public static MultiblockTankMachine[] STAINLESS_STEEL_TANKS;
    public static MultiblockTankMachine[] TITANIUM_TANKS;
    public static MultiblockTankMachine[] NETHERITE_TANKS;
    public static MultiblockTankMachine[] TUNGSTENSTEEL_TANKS;
    public static MultiblockTankMachine[] TUNGSTEN_TANKS;
    public static MultiblockTankMachine[] ADAMANTIUM_TANKS;
    public static BasicMachine TRANSFORMER;
    public static BasicMachine ADJUSTABLE_TRANSFORMER;
    public static BasicMachine FLUX_TRANSFORMER;
    public static GeneratorMachine COMBUSTION_GENERATOR;
    public static GeneratorMachine SEMIFLUID_GENERATOR;
    public static GeneratorMachine GAS_GENERATOR;
    public static GeneratorMachine STEAM_GENERATOR;
    public static GeneratorMachine MAGIC_ENERGY_CONVERTER;
    public static GeneratorMachine MAGIC_ENERGY_ABSORBER;
    public static GeneratorMachine SOLAR_PANEL;
    public static BasicMachine NUCLEAR_REACTOR_CORE;
    public static BasicMachine INVAR_SMALL_HEAT_EXCHANGER;
    public static BasicMachine TUNGSTEN_SMALL_HEAT_EXCHANGER;
    public static BasicMachine TUNGSTENSTEEL_SMALL_HEAT_EXCHANGER;
    public static MultiMachine ASSEMBLY_LINE;
    public static MultiMachine AUTOCRAFTER_ASSEMBLY_LINE;
    public static MultiMachine BEDROCK_DRILL;
    public static MultiMachine BLAST_FURNACE;
    public static MultiMachine COMBUSTION_ENGINE;
    public static MultiMachine CRACKING_UNIT;
    public static MultiMachine DISTLLATION_TOWER;
    public static MultiMachine CRYO_DISTLLATION_TOWER;
    public static MultiMachine FUSION_REACTOR;
    public static MultiMachine LARGE_HEAT_EXCHANGER;
    public static MultiMachine IMPLOSION_COMPRESSOR;
    public static MultiMachine LARGE_AUTOCLAVE;
    public static MultiMachine LARGE_BATHING_VAT;
    public static MultiMachine LARGE_BOILER;
    public static MultiMachine LARGE_CENTRIFUGE;
    public static MultiMachine LARGE_CHEMICAL_REACTOR;
    public static MultiMachine LARGE_ELECTROLYZER;
    public static MultiMachine LARGE_PULVERIZER;
    public static MultiMachine LARGE_ORE_WASHER;
    public static MultiMachine LARGE_SIFTER;
    public static MultiMachine LARGE_TURBINE;
    public static MultiMachine MULTI_SMELTER;
    public static MultiMachine OIL_DRILLING_RIG;
    public static MultiMachine ORE_MINING_RIG;
    public static MultiMachine PROCESSING_ARRAY;
    public static MultiMachine PYROLYSE_OVEN;
    public static MultiMachine TREE_GROWTH_SIMULATOR;
    public static MultiMachine VACUUM_FREEZER;
    public static BasicMultiMachine<?> LONG_DISTANCE_FLUID_ENDPOINT;
    public static BasicMultiMachine<?> LONG_DISTANCE_ITEM_ENDPOINT;
    public static BasicMultiMachine<?> LONG_DISTANCE_TRANSFORMER_ENDPOINT;
    public static HatchMachine DYNAMO_HATCH;
    public static HatchMachine ENERGY_HATCH;
    public static HatchMachine INPUT_HATCH;
    public static HatchMachine OUTPUT_HATCH;
    public static HatchMachine INPUT_BUS;
    public static HatchMachine OUTPUT_BUS;
    public static HatchMachine HIGH_CAPACITY_INPUT_HATCH;
    public static HatchMachine HIGH_CAPACITY_OUTPUT_HATCH;
    public static HatchMachine SECONDARY_INPUT_HATCH;
    public static HatchMachine SECONDARY_OUTPUT_HATCH;
    public static HatchMachine MUFFLER_HATCH;
    public static TankMachine QUANTUM_TANK;
    public static BasicMachine PUMP;
    public static BasicMachine CROP_HARVESTER;
    public static BasicMachine MINIATURE_NETHER_PORTAL;
    public static BasicMachine MINIATURE_END_PORTAL;
    public static BasicMachine MINIATURE_TWILIGHT_PORTAL;
    @Nullable
    public static BasicMachine MINIATURE_JAMD_PORTAL;

    public static void initTanks() {
        WOOD_TANK = new MultiblockTankMachine("gt5r", Materials.Wood, true, 432000, () -> GT5RBlocks.WOOD_WALL).maxHeat(350);
        STEEL_TANKS = GT5RMachines.createTankMachine(Materials.Steel, 3);
        INVAR_TANKS = GT5RMachines.createTankMachine(Materials.Invar, 2);
        STAINLESS_STEEL_TANKS = GT5RMachines.createTankMachine(Materials.StainlessSteel, 4);
        TITANIUM_TANKS = GT5RMachines.createTankMachine(Materials.Titanium, 8);
        NETHERITE_TANKS = GT5RMachines.createTankMachine(Materials.Netherite, 8);
        TUNGSTENSTEEL_TANKS = GT5RMachines.createTankMachine(Materials.TungstenSteel, 16);
        TUNGSTEN_TANKS = GT5RMachines.createTankMachine(Materials.Tungsten, 16);
        ADAMANTIUM_TANKS = GT5RMachines.createTankMachine(Materials.Adamantium, 256);
    }

    private static MultiblockTankMachine[] createTankMachine(Material material, int multiplier) {
        Supplier<Block> casing = () -> (Block)GT5Reimagined.get(BlockColoredWall.class, material.getId() + "_wall");
        MultiblockTankMachine[] multiblockTankMachines = new MultiblockTankMachine[]{new MultiblockTankMachine("gt5r", material, true, 432 * multiplier * 1000, casing).gasProof(), new MultiblockTankMachine("gt5r", material, false, 2000 * multiplier * 1000, casing).gasProof()};
        if (material == Materials.StainlessSteel || material == Materials.Netherite) {
            multiblockTankMachines[0].acidProof();
            multiblockTankMachines[1].acidProof();
        }
        return multiblockTankMachines;
    }

    public static void init() {
        GTAPI.registerJEICategoryWorkstation(RecipeMaps.ALLOY_SMELTER, (Machine)MULTI_SMELTER, (Tier)Tier.HV);
        GTLibXEIPlugin.addWorkstations((ResourceLocation)new ResourceLocation("crafting"), l -> {
            l.addAll(AUTOCRAFTER.getTiers().stream().map(t -> AUTOCRAFTER.getItem(t)).toList());
            l.add(AUTOCRAFTER_ASSEMBLY_LINE.getItem(Tier.HV));
        });
        if (GTAPI.isModLoaded((String)"jamd")) {
            MINIATURE_JAMD_PORTAL = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new MiniPortalMachine("gt5r", "miniature_jamd_portal").setBaseTexture(new Texture("jamd", "block/mine_portal_block"))).setOverlayTextures(Textures.MINI_NETHER_PORTAL)).setBlock((machine, tier) -> new BlockMachine(machine, tier, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_().m_60955_()))).setTile(BlockEntityMiniJAMDPortal::new);
        }
        GTAPI.registerJEICategoryWorkstation(RecipeMaps.PULVERIZER, (Machine)STEAM_MACERATOR, (Tier)Tier.BRONZE);
        GTAPI.registerJEICategoryWorkstation(RecipeMaps.PULVERIZER, (Machine)STEAM_MACERATOR, (Tier)Tier.STEEL);
        STEAM_ALLOY_SMELTER.setMap(RecipeMaps.ALLOY_SMELTER, new Tier[0]);
        STEAM_COMPRESSOR.setMap(RecipeMaps.COMPRESSOR, new Tier[0]);
        STEAM_EXTRACTOR.setMap(RecipeMaps.EXTRACTOR, new Tier[0]);
        STEAM_FORGE_HAMMER.setMap(RecipeMaps.FORGE_HAMMER, new Tier[0]);
        STEAM_FURNACE.setMap(RecipeMaps.ELECTRIC_FURNACE, new Tier[0]);
        STEAM_CUTTER.setMap(RecipeMaps.CUTTER, new Tier[0]);
        STEAM_SIFTER.setMap(RecipeMaps.SIFTER, new Tier[0]);
    }

    private static int getBlockColorNuclear(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, @Nullable BlockEntityMachine<?> machine, int i) {
        if (i > 0 && i < 9 && world != null && pos != null && machine != null) {
            int slot;
            int n = slot = i > 4 ? i - 5 : i - 1;
            if (machine instanceof BlockEntityNuclearReactorCore) {
                Item item;
                BlockEntityNuclearReactorCore core = (BlockEntityNuclearReactorCore)machine;
                if (i < 5) {
                    boolean on = core.getMachineState() != MachineState.DISABLED && (core.mode & Ref.B[slot]) == 0;
                    return on ? -1 : Materials.Lead.getRGB();
                }
                ItemStack rod = core.getRod(slot);
                if (!rod.m_41619_() && (item = rod.m_41720_()) instanceof IItemReactorRod) {
                    IItemReactorRod reactorRod = (IItemReactorRod)item;
                    return reactorRod.getItemColor(rod, state.m_60734_(), 0);
                }
            }
        }
        if (i == 0) {
            return Materials.Lead.getRGB();
        }
        return -1;
    }

    private static void getFluidHatchTooltips(BlockMachine machine, ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Utils.translatable((String)("tooltip.gt5r." + (machine.getId().contains("secondary") ? "secondary_" : "") + (machine.getId().contains("input") ? "input" : "output") + "_hatch"), (Object[])new Object[0]));
        int multiplier = machine.getId().contains("high_capacity") ? 32 : 8;
        tooltip.add((Component)Utils.translatable((String)"gtlib.tooltip.capacity", (Object[])new Object[]{multiplier * 1000 * (machine.getTier().getIntegerId() + 1) + "L"}));
    }

    private static void getItemHatchTooltips(BlockMachine machine, ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Utils.translatable((String)("tooltip.gt5r." + (machine.getId().contains("input") ? "input" : "output") + "_bus"), (Object[])new Object[0]));
        int stacks = machine.getTier() == Tier.ULV ? 1 : (machine.getTier() == Tier.LV ? 4 : (machine.getTier() == Tier.MV ? 9 : 16));
        tooltip.add((Component)Utils.translatable((String)"gtlib.tooltip.capacity", (Object[])new Object[]{stacks + " stacks"}));
    }

    static {
        TRANSFORMER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "transformer").addFlags(new String[]{"eu"})).setTiers(new Tier[]{Tier.ULV, Tier.LV, Tier.MV, Tier.HV, Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV})).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setTile((v, pos, state) -> new BlockEntityTransformer((Machine)v, pos, state, 1))).setNoOutputCover()).setAllowsFrontIO()).setVerticalFacingAllowed(true)).addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            tooltip.remove(tooltip.size() - 1);
            tooltip.remove(tooltip.size() - 1);
            Tier upper = Tier.getTier((long)(machine.getTier().getVoltage() * 4L));
            tooltip.add(Utils.translatable((String)"machine.transformer.voltage_info", (Object[])new Object[]{Utils.literal((String)upper.getId().toUpperCase()), Utils.literal((String)machine.getTier().getId().toUpperCase())}));
            tooltip.add(Utils.translatable((String)"machine.voltage.in", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)(upper.getVoltage() + " (" + upper.getId().toUpperCase() + ")"))).m_130940_(ChatFormatting.GREEN));
            tooltip.add(Utils.translatable((String)"machine.voltage.out", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)(machine.getTier().getVoltage() + " (" + machine.getTier().getId().toUpperCase() + ")"))).m_130940_(ChatFormatting.GREEN));
            tooltip.add(Utils.translatable((String)"generic.amp", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)String.valueOf(4)).m_130940_(ChatFormatting.YELLOW)));
            tooltip.add(Utils.translatable((String)"machine.power.capacity", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)String.valueOf(512L + machine.getTier().getVoltage() * 8L))).m_130940_(ChatFormatting.BLUE));
        });
        ADJUSTABLE_TRANSFORMER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "adjustable_transformer").setTiers(new Tier[]{Tier.EV, Tier.IV})).addFlags(new String[]{"gui", "eu"})).setTile(BlockEntityDigitalTransformer::new)).setNoOutputCover()).setAllowsFrontIO();
        FLUX_TRANSFORMER = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "flux_transformer").setTiers(Tier.getAllElectric())).addFlags(new String[]{"eu", "fe"})).setTile(BlockEntityFluxTransformer::new)).setNoOutputCover()).setAllowsFrontIO()).setOverlayTextures(Textures.STATE_IGNORANT_TIER_SPECIFIC_OVERLAY_HANDLER);
        COMBUSTION_GENERATOR = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "combustion_generator").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV})).setMap(RecipeMaps.COMBUSTION_FUELS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "cell"})).setAllowsFrontIO()).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER);
        SEMIFLUID_GENERATOR = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "semifluid_generator").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV})).setMap(RecipeMaps.SEMI_FUELS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "cell"})).setAllowsFrontIO()).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER);
        GAS_GENERATOR = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "gas_turbine").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV})).setMap(RecipeMaps.GAS_FUELS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "cell"})).setAllowsFrontIO()).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setCustomModel();
        STEAM_GENERATOR = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "steam_turbine").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV})).setMap(RecipeMaps.STEAM_FUELS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "cell"})).setTile(BlockEntitySteamTurbine::new)).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setEfficiency(t -> 4 - t.getIntegerId() + 6)).setAllowsFrontIO()).setCustomModel();
        MAGIC_ENERGY_CONVERTER = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "magic_energy_converter").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV})).setMap(RecipeMaps.MAGIC_FUELS, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "cell"})).setAllowsFrontIO()).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER);
        MAGIC_ENERGY_ABSORBER = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "magic_energy_absorber").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV})).addFlags(new String[]{"gui", "item"})).setAllowsFrontIO()).setOverlayTextures(Textures.TIER_SPECIFIC_OVERLAY_HANDLER)).setEfficiency(t -> 100 - 10 * (5 - t.getIntegerId()));
        SOLAR_PANEL = (GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)((GeneratorMachine)new GeneratorMachine("gt5r", "solar_panel").setTiers(new Tier[]{Tier.NONE, Tier.ULV, Tier.LV})).addFlags(new String[]{"gui"})).removeFlags(new String[]{"coverable"})).setCustomShape(Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0))).setItemModelParent(new ResourceLocation("gt5r", "block/preset/solar_panel"))).setVerticalFacingAllowed(false)).setTile(BlockEntitySolarPanel::new)).setCustomModel()).addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            if (machine.getTier() == Tier.NONE) {
                tooltip.add(Utils.translatable((String)"machine.voltage.out", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)"1")).m_130940_(ChatFormatting.GREEN));
                tooltip.add(Utils.translatable((String)"machine.power.capacity", (Object[])new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal((String)"80").m_130940_(ChatFormatting.BLUE)));
            }
        });
        NUCLEAR_REACTOR_CORE = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "nuclear_reactor_core").setSecondaryOutputCover(GT5RCovers.COVER_REACTOR_OUTPUT_SECONDARY)).setSecondaryOutputDir(Dir.BACK)).removeFlags(new String[]{"eu"})).setTiers(new Tier[]{Tier.NONE})).addFlags(new String[]{"gui", "item", "fluid", "unculled"})).setRendersContainedLiquids(false)).setCustomModel()).setOverlayTextures(Textures.REACTOR_CORE_OVERLAY_HANDLER)).setBaseTexture(Textures.REACTOR_CORE_BASE_HANDLER)).setModelLoader(GT5RModelManager.LOADER_REACTOR)).setTile(BlockEntityNuclearReactorCore::new)).setBlockColorHandler(GT5RMachines::getBlockColorNuclear)).setItemColorHandler((stack, block, i) -> i == 0 ? Materials.Lead.getRGB() : -1)).setAllowsFrontCovers()).setAllowsFrontIO()).setNoTextureRotation(true)).setOutputCover(GT5RCovers.COVER_REACTOR_OUTPUT)).setOutputDir(Dir.FORWARD)).setAllowsOutputCoversOnFacing(true);
        INVAR_SMALL_HEAT_EXCHANGER = new HeatExchangerMachine("gt5r", "invar_small_heat_exchanger", 16);
        TUNGSTEN_SMALL_HEAT_EXCHANGER = new HeatExchangerMachine("gt5r", "tungsten_small_heat_exchanger", 128);
        TUNGSTENSTEEL_SMALL_HEAT_EXCHANGER = new HeatExchangerMachine("gt5r", "tungstensteel_small_heat_exchanger", 128).setEfficiency(9000);
        ASSEMBLY_LINE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "assembly_line").setTiers(new Tier[]{Tier.IV})).setMap(RecipeMaps.ASSEMBLY_LINE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).setTile(BlockEntityAssemblyLine::new)).setTextureBlock((BlockBasic)GT5RBlocks.SOLID_STEEL_CASING);
        AUTOCRAFTER_ASSEMBLY_LINE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "autocrafter_assembly_line").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.ASSEMBLER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).setTile(BlockEntityBasicAssemblyLine::new)).setTextureBlock((BlockBasic)GT5RBlocks.SOLID_STEEL_CASING);
        BEDROCK_DRILL = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "bedrock_drill").setTiers(new Tier[]{Tier.EV})).setMap(RecipeMaps.BEDROCK_DRILL, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(12)).setTile(BlockEntityBedrockDrill::new)).setTextureBlock((BlockBasic)GT5RBlocks.TITANIUM_CASING);
        BLAST_FURNACE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "electric_blast_furnace").setTiers(new Tier[]{Tier.LV})).setMap(RecipeMaps.E_BLAST_FURNACE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(11)).setTile(BlockEntityElectricBlastFurnace::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.HEAT_PROOF_CASING);
        COMBUSTION_ENGINE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "combustion_engine").setTiers(new Tier[]{Tier.EV})).setMap(RecipeMaps.COMBUSTION_FUELS, new Tier[0])).addFlags(new String[]{"gui", "fluid", "eu", "generator"})).addStructureTooltip(13)).setTile(BlockEntityCombustionEngine::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.TITANIUM_CASING);
        CRACKING_UNIT = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "cracking_unit").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.CRACKING, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(9)).setTile(BlockEntityOilCrackingUnit::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.STAINLESS_STEEL_CASING);
        DISTLLATION_TOWER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "distillation_tower").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.DISTILLATION, new Tier[0])).addStructureTooltip(8)).addFlags(new String[]{"gui", "item", "fluid", "eu"})).setTile(BlockEntityDistillationTower::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.STAINLESS_STEEL_CASING);
        CRYO_DISTLLATION_TOWER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "cryo_distillation_tower").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.CRYO_DISTILLATION, new Tier[0])).addStructureTooltip(8)).addFlags(new String[]{"gui", "item", "fluid", "eu"})).setTile(BlockEntityDistillationTower::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.FROST_PROOF_CASING);
        FUSION_REACTOR = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "fusion_control_computer").setTiers(new Tier[]{Tier.LUV})).setMap(RecipeMaps.FUSION, new Tier[0])).addFlags(new String[]{"gui", "fluid", "item", "eu"})).addStructureTooltip(7)).setTile(BlockEntityFusionReactor::new)).setTextureBlock((BlockBasic)GT5RBlocks.FUSION_CASING);
        LARGE_HEAT_EXCHANGER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_heat_exchanger").setTiers(new Tier[]{Tier.NONE})).setMap(RecipeMaps.HEAT_EXCHANGER, new Tier[0])).addFlags(new String[]{"gui", "fluid", "item", "heat"})).addStructureTooltip(8)).setTile(BlockEntityLargeHeatExchanger::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.TITANIUM_CASING);
        IMPLOSION_COMPRESSOR = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "implosion_compressor").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.IMPLOSION_COMPRESSOR, new Tier[0])).addFlags(new String[]{"gui", "item", "eu"})).addStructureTooltip(7)).setTile(BlockEntityImplosionCompressor::new)).setTextureBlock((BlockBasic)GT5RBlocks.SOLID_STEEL_CASING);
        LARGE_AUTOCLAVE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_autoclave").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.AUTOCLAVE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(9)).setTile(BlockEntityLargeAutoclave::new)).setTextureBlock((BlockBasic)GT5RBlocks.STAINLESS_STEEL_CASING);
        LARGE_BATHING_VAT = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_bathing_vat").setTiers(new Tier[]{Tier.NONE})).setMap(RecipeMaps.BATH, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).addStructureTooltip(8)).setTile(BlockEntityLargeBath::new)).setTextureBlock((BlockBasic)GT5RBlocks.STAINLESS_STEEL_WALL)).setBlockColorHandler((state, world, pos, machine, i) -> i == 0 ? Materials.StainlessSteel.getRGB() : -1)).setItemColorHandler((stack, block, i) -> i == 0 ? Materials.StainlessSteel.getRGB() : -1);
        LARGE_BOILER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_boiler").setTiers(new Tier[]{Tier.LV, Tier.MV, Tier.HV, Tier.EV})).addFlags(new String[]{"gui", "item", "fluid"})).setMap(RecipeMaps.LARGE_BOILERS, new Tier[0])).setTile(BlockEntityLargeBoiler::new)).setCustomModel()).setTierSpecificLang()).addStructureTooltip(13, (machine, stack, world, flag, i) -> {
            if (i == 1) {
                double total;
                double d = machine.getTier() == Tier.LV ? 32000.0 : (machine.getTier() == Tier.MV ? 36000.0 : (total = machine.getTier() == Tier.HV ? 41600.0 : 48000.0));
                double production = machine.getTier() == Tier.LV ? 16000.0 : (machine.getTier() == Tier.MV ? 24000.0 : (machine.getTier() == Tier.HV ? 32000.0 : 40000.0));
                return new Object[]{total, production};
            }
            if (i >= 4 && i < 7) {
                String prefix;
                String tier = machine.getTier() == Tier.LV ? "bronze" : (machine.getTier() == Tier.MV ? "steel" : (machine.getTier() == Tier.HV ? "titanium" : "tungstensteel"));
                String string = prefix = i == 5 && tier.equals("steel") ? "solid_" : "";
                String suffix = i == 5 && tier.equals("bronze") ? "plated_brick_" : (i == 4 ? "firebox_" : (i == 6 ? "pipe_" : ""));
                return new Object[]{Utils.translatable((String)GT5Reimagined.get(BlockCasing.class, prefix + tier + "_" + suffix + "casing").m_7705_(), (Object[])new Object[0])};
            }
            if (i == 12) {
                double seconds = machine.getTier() == Tier.LV ? 31.25 : (machine.getTier() == Tier.MV ? 47.67 : (machine.getTier() == Tier.HV ? 62.5 : 125.0));
                return new Object[]{seconds};
            }
            return new Object[0];
        });
        LARGE_CENTRIFUGE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_centrifuge").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.CENTRIFUGE, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(7)).setTile(BlockEntityLargeCentrifuge::new)).setTextureBlock((BlockBasic)GT5RBlocks.TUNGSTENSTEEL_CASING);
        LARGE_CHEMICAL_REACTOR = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_chemical_reactor").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.CHEMICAL_REACTOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(10)).setTile(BlockEntityLargeChemicalReactor::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.CHEMICALLY_INERT_CASING);
        LARGE_ELECTROLYZER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_electrolyzer").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.ELECTROLYZER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(9)).setTile(BlockEntityLargeElectrolyzer::new)).setTextureBlock((BlockBasic)GT5RBlocks.STAINLESS_STEEL_CASING);
        LARGE_PULVERIZER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_pulverizer").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.PULVERIZER, new Tier[0])).addFlags(new String[]{"gui", "item", "eu"})).addStructureTooltip(8)).setTile(BlockEntityLargeMacerator::new)).setTextureBlock((BlockBasic)GT5RBlocks.TUNGSTENSTEEL_WALL)).setBlockColorHandler((state, world, pos, machine, i) -> i == 0 ? Materials.TungstenSteel.getRGB() : -1)).setItemColorHandler((stack, block, i) -> i == 0 ? Materials.TungstenSteel.getRGB() : -1);
        LARGE_ORE_WASHER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_ore_washer").setTiers(new Tier[]{Tier.EV})).setMap(RecipeMaps.ORE_WASHER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(9)).setTile(BlockEntityLargeOreWasher::new)).setTextureBlock((BlockBasic)GT5RBlocks.TITANIUM_WALL)).setBlockColorHandler((state, world, pos, machine, i) -> i == 0 ? Materials.Titanium.getRGB() : -1)).setItemColorHandler((stack, block, i) -> i == 0 ? Materials.Titanium.getRGB() : -1);
        LARGE_SIFTER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_sifter").setTiers(new Tier[]{Tier.EV})).setMap(RecipeMaps.SIFTER, new Tier[0])).addFlags(new String[]{"gui", "item", "eu"})).addStructureTooltip(8)).setTile(BlockEntityLargeSifter::new)).setTextureBlock((BlockBasic)GT5RBlocks.TITANIUM_CASING);
        LARGE_TURBINE = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "large_turbine").setTiers(new Tier[]{Tier.HV, Tier.EV, Tier.IV})).setMap(RecipeMaps.STEAM_FUELS, new Tier[]{Tier.HV})).setMap(RecipeMaps.HP_STEAM_FUELS, new Tier[]{Tier.IV})).setMap(RecipeMaps.GAS_FUELS, new Tier[]{Tier.EV})).addFlags(new String[]{"gui", "item", "fluid", "eu", "generator"})).setTile(BlockEntityLargeTurbine::new)).setCustomModel(Textures.TURBINE)).setTierSpecificLang()).addStructureTooltip(8, (machine, stack, world, flag, i) -> {
            if (i == 0) {
                return new Object[]{machine.getDisplayName(new ItemStack((ItemLike)machine))};
            }
            if (i == 5) {
                String tier = machine.getTier() == Tier.HV ? "steel" : (machine.getTier() == Tier.EV ? "stainless_steel" : "titanium");
                return new Object[]{Utils.translatable((String)GT5Reimagined.get(BlockCasing.class, tier + "_turbine_casing").m_7705_(), (Object[])new Object[0])};
            }
            if (i == 7) {
                String amount = machine.getTier() == Tier.HV ? "105-1680" : "210-3360";
                return new Object[]{amount};
            }
            return new Object[0];
        });
        MULTI_SMELTER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "multi_smelter").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.ELECTRIC_FURNACE, new Tier[0])).addFlags(new String[]{"gui", "item", "eu"})).addStructureTooltip(10)).setTile(BlockEntityMultiSmelter::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.HEAT_PROOF_CASING);
        OIL_DRILLING_RIG = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "oil_drilling_rig").setTiers(new Tier[]{Tier.MV})).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(9)).setTile(BlockEntityOilDrillingRig::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.SOLID_STEEL_CASING);
        ORE_MINING_RIG = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "ore_mining_rig").setTiers(new Tier[]{Tier.EV})).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(11)).setTile(BlockEntityOreMiningRig::new)).setTextureBlock((BlockBasic)GT5RBlocks.SOLID_STEEL_CASING);
        PROCESSING_ARRAY = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "processing_array").setTiers(new Tier[]{Tier.EV})).addFlags(new String[]{"gui", "item", "fluid", "eu", "recipe"})).addStructureTooltip(8)).setTile(BlockEntityProcessingArray::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.TUNGSTENSTEEL_CASING);
        PYROLYSE_OVEN = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "pyrolyse_oven").setTiers(new Tier[]{Tier.MV})).setMap(RecipeMaps.PYROLYSE_OVEN, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(12)).setTile(BlockEntityPyrolysisOven::new)).setCustomModel()).setTextureBlock((BlockBasic)GT5RBlocks.CASING_ULV);
        TREE_GROWTH_SIMULATOR = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "tree_growth_simulator").setTiers(new Tier[]{Tier.LV})).setMap(RecipeMaps.TREE_GROWTH_SIMULATOR, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(12)).setTile(BlockEntityTreeGrowthSimulator::new)).setTextureBlock((BlockBasic)GT5RBlocks.PLASTIC_CASING);
        VACUUM_FREEZER = (MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)((MultiMachine)new MultiMachine("gt5r", "vacuum_freezer").setTiers(new Tier[]{Tier.HV})).setMap(RecipeMaps.VACUUM_FREEZER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid", "eu"})).addStructureTooltip(7)).setTile(BlockEntityVacuumFreezer::new)).setTextureBlock((BlockBasic)GT5RBlocks.FROST_PROOF_CASING);
        LONG_DISTANCE_FLUID_ENDPOINT = (BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)new BasicMultiMachine("gt5r", "long_distance_fluid_endpoint").setAllowsFrontIO()).setVerticalFacingAllowed(true)).setTiers(new Tier[]{Tier.NONE})).addFlags(new String[]{"fluid"})).setTile(BlockEntityLongDistancePipeEndpoint::new);
        LONG_DISTANCE_ITEM_ENDPOINT = (BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)new BasicMultiMachine("gt5r", "long_distance_item_endpoint").setAllowsFrontIO()).setVerticalFacingAllowed(true)).setTiers(new Tier[]{Tier.NONE})).addFlags(new String[]{"item"})).setTile(BlockEntityLongDistancePipeEndpoint::new);
        LONG_DISTANCE_TRANSFORMER_ENDPOINT = (BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)((BasicMultiMachine)new BasicMultiMachine("gt5r", "long_distance_transformer_endpoint").setAllowsFrontIO()).setVerticalFacingAllowed(true)).setTiers(new Tier[]{Tier.EV, Tier.IV, Tier.LUV, Tier.ZPM, Tier.UV})).addFlags(new String[]{"eu"})).setTile(BlockEntityLongDistancePipeEndpoint::new)).setOverlayTextures(Textures.STATE_IGNORANT_TIER_SPECIFIC_OVERLAY_HANDLER)).setBaseTexture((m, tier, state) -> new Texture[]{tier.getBaseTexture(m.getDomain())});
        DYNAMO_HATCH = (HatchMachine)((HatchMachine)new HatchMachine("gt5r", "dynamo_hatch", GT5RCovers.COVER_DYNAMO_COLORED, "dynamo").addFlags(new String[]{"eu"})).setOverlayTextures(Textures.HATCH_OVERLAY_HANDLER);
        ENERGY_HATCH = (HatchMachine)((HatchMachine)new HatchMachine("gt5r", "energy_hatch", GT5RCovers.COVER_ENERGY_COLORED, "energy").addFlags(new String[]{"eu"})).setOverlayTextures(Textures.HATCH_OVERLAY_HANDLER);
        INPUT_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "input_hatch", Data.COVERINPUT, "fluid_input").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips)).setTile(BlockEntityInputHatch::new);
        OUTPUT_HATCH = (HatchMachine)((HatchMachine)new HatchMachine("gt5r", "output_hatch", Data.COVEROUTPUT, "fluid_output").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips);
        INPUT_BUS = (HatchMachine)((HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "input_bus", Data.COVERINPUT, "item_input").setTiers(new Tier[]{Tier.ULV, Tier.LV, Tier.MV, Tier.HV, Tier.EV})).addFlags(new String[]{"gui", "item"})).addTooltipInfo(GT5RMachines::getItemHatchTooltips)).setTile(BlockEntityInputBus::new);
        OUTPUT_BUS = (HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "output_bus", Data.COVEROUTPUT, "item_output").setTiers(new Tier[]{Tier.ULV, Tier.LV, Tier.MV, Tier.HV, Tier.EV})).addFlags(new String[]{"gui", "item"})).addTooltipInfo(GT5RMachines::getItemHatchTooltips);
        HIGH_CAPACITY_INPUT_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "high_capacity_input_hatch", Data.COVERINPUT, "fluid_input").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips)).setOverlayTextures(INPUT_HATCH.getOverlayTextures())).setTile(BlockEntityHighCapacityInputHatch::new);
        HIGH_CAPACITY_OUTPUT_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "high_capacity_output_hatch", Data.COVEROUTPUT, "fluid_output").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips)).setOverlayTextures(OUTPUT_HATCH.getOverlayTextures())).setTile(BlockEntityHighCapacityOutputHatch::new);
        SECONDARY_INPUT_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "secondary_input_hatch", Data.COVERINPUT, "secondary_fluid_input").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips)).setOverlayTextures(INPUT_HATCH.getOverlayTextures());
        SECONDARY_OUTPUT_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "secondary_output_hatch", Data.COVEROUTPUT, "secondary_fluid_output").addFlags(new String[]{"gui", "fluid", "cell"})).addTooltipInfo(GT5RMachines::getFluidHatchTooltips)).setOverlayTextures(OUTPUT_HATCH.getOverlayTextures());
        MUFFLER_HATCH = (HatchMachine)((HatchMachine)((HatchMachine)new HatchMachine("gt5r", "muffler_hatch", Data.COVERMUFFLER, "muffler").setTiers(new Tier[]{Tier.LV})).addFlags(new String[]{"gui", "item"})).setClientTicking();
        QUANTUM_TANK = (TankMachine)((TankMachine)((TankMachine)new TankMachine("gt5r", "quantum_tank", t -> (int)(1602000.0 * Math.pow(6.0, t.getIntegerId() - 1))).setTiers(Tier.getStandardWithIV())).addFlags(new String[]{"basic", "gui", "cell"})).setAllowsFrontCovers();
        PUMP = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "electric_pump").addFlags(new String[]{"fluid"})).setVerticalFacingAllowed(true)).setTile(BlockEntityPump::new)).setNoOutputCover();
        CROP_HARVESTER = (BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gt5r", "crop_harvester").setTiers(new Tier[]{Tier.LV})).addFlags(new String[]{"gui", "item"})).setTile(BlockEntityCropHarvester::new);
        MINIATURE_NETHER_PORTAL = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new MiniPortalMachine("gt5r", "miniature_nether_portal").setBaseTexture(new Texture("block/obsidian"))).setOverlayTextures(Textures.MINI_NETHER_PORTAL)).setBlock((machine, tier) -> new BlockMachine(machine, tier, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_().m_60955_()))).setTile(BlockEntityMiniNetherPortal::new);
        MINIATURE_END_PORTAL = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new MiniPortalMachine("gt5r", "miniature_end_portal").setBaseTexture(new Texture("block/end_portal_frame_top"))).setOverlayTextures(Textures.MINI_END_PORTAL)).setBlock((machine, tier) -> new BlockMachine(machine, tier, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(3.0f, 9.0f).m_60918_(SoundType.f_56742_).m_60999_().m_60955_()))).setTile(BlockEntityMiniEndPortal::new);
        MINIATURE_TWILIGHT_PORTAL = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new MiniPortalMachine("gt5r", "miniature_twilight_portal").setBaseTexture(new Texture("block/grass_block_top"))).setOverlayTextures(Textures.MINI_TWILIGHT_PORTAL)).setBlock((machine, tier) -> new BlockMachine(machine, tier, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_().m_60955_()))).setTile(BlockEntityMiniTwilightPortal::new)).setBlockColorHandler((state, world, pos, machine, i) -> {
            if (machine != null && i == 1 && machine.getMachineState() != MachineState.ACTIVE) {
                Biome biome = (Biome)machine.m_58904_().m_204166_(pos).m_203334_();
                return biome.m_47560_();
            }
            return i == 0 ? 65280 : -1;
        })).setItemColorHandler((stack, block, i) -> i == 0 ? 65280 : -1);
        MINIATURE_JAMD_PORTAL = null;
    }
}

