/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverAirVent
extends BaseCover {
    public static String ID = "air_vent";

    public CoverAirVent(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public String getDomain() {
        return "gt5r";
    }

    public void onUpdate() {
        BlockEntity tile = this.handler.getTile();
        if (tile == null) {
            return;
        }
        if (tile.m_58904_().f_46443_) {
            return;
        }
        Level level = tile.m_58904_();
        Optional cap = Optional.empty();
        if (tile instanceof BlockEntityFluidPipe) {
            BlockEntityFluidPipe pipe = (BlockEntityFluidPipe)tile;
            cap = pipe.getPipeCapHolder().side(this.side).resolve();
        } else if (tile instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tile;
            cap = machine.fluidHandler.map(FluidHandler::getInputTanks);
        }
        BlockPos offset = tile.m_58899_().m_142300_(this.side);
        BlockState state = level.m_8055_(offset);
        if (state.m_60795_() && cap.isPresent() && level.m_46467_() % 360L == 30L + 60L * (long)this.side.m_122411_()) {
            if (level.m_46472_() == Level.f_46428_) {
                ((IFluidHandler)cap.get()).fill(Materials.Air.getGas(64000), IFluidHandler.FluidAction.EXECUTE);
            } else if (level.m_46472_() == Level.f_46429_) {
                ((IFluidHandler)cap.get()).fill(Materials.NetherAir.getGas(64000), IFluidHandler.FluidAction.EXECUTE);
            } else if (level.m_46472_() == Level.f_46430_) {
                ((IFluidHandler)cap.get()).fill(Materials.EnderAir.getGas(64000), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public String getId() {
        return ID;
    }

    protected String getRenderId() {
        return ID;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverAirVent.getBasicModel();
    }
}

