/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.machine.HeatExchangerMachine;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.DefaultHeatHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntitySmallHeatExchanger
extends BlockEntityMachine<BlockEntitySmallHeatExchanger> {
    boolean hadNoWater = false;
    int rate;
    int efficiency;
    int steamHeat = 0;

    public BlockEntitySmallHeatExchanger(HeatExchangerMachine type, BlockPos pos, BlockState state, final int rate, final int efficiency) {
        super((Machine)type, pos, state);
        this.rate = rate;
        this.efficiency = efficiency;
        this.heatHandler.set(() -> new DefaultHeatHandler((BlockEntityBase)this, Integer.MAX_VALUE, 80, 0));
        this.recipeHandler.set(() -> new ParallelRecipeHandler<BlockEntitySmallHeatExchanger>(this, 1){

            protected boolean validateRecipe(IRecipe r) {
                return super.validateRecipe(r) && !r.getTags().contains("large_heat_exchanged_only");
            }

            protected boolean canRecipeContinue() {
                return super.canRecipeContinue() && BlockEntitySmallHeatExchanger.this.heatHandler.map(h -> h.getHeat() < rate * 2).orElse(false) != false;
            }

            @Override
            protected int maxSimultaneousRecipes() {
                if (this.activeRecipe != null) {
                    return (int)Math.max(1L, (long)rate / this.activeRecipe.getTotalPower());
                }
                return super.maxSimultaneousRecipes();
            }

            public boolean consumeResourceForRecipe(boolean simulate) {
                if (this.activeRecipe == null) {
                    return false;
                }
                if (this.currentProgress > 0 || simulate) {
                    return true;
                }
                if (!this.consumedResources && this.shouldConsumeResources()) {
                    this.consumeInputs();
                }
                long totalPower = CodeUtils.units((long)this.activeRecipe.getTotalPower(), (long)10000L, (long)efficiency, (boolean)false) * (long)this.concurrentRecipes;
                return ((BlockEntitySmallHeatExchanger)this.tile).heatHandler.map(e -> (long)e.insertInternal((int)totalPower, simulate) >= totalPower).orElse(false);
            }

            public boolean accepts(FluidStack stack) {
                return super.accepts(stack) || stack.getFluid() == Materials.Water.getLiquid() || stack.getFluid() == Materials.DistilledWater.getLiquid();
            }
        });
        this.fluidHandler.set(() -> new SmallHeatExchangerFluidHandler(this));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.heatHandler.ifPresent(h -> {
            if (h.getHeat() > 0) {
                int tempRate = Math.min(h.getHeat(), this.rate);
                this.steamHeat += tempRate;
                h.extractInternal(tempRate, false);
            }
        });
        if (level.m_46467_() % 20L == 0L) {
            this.fluidHandler.ifPresent(f -> {
                if (this.steamHeat >= 80) {
                    FluidTank waterTank;
                    int max = this.rate * 20 / 80;
                    int heatMultiplier = Math.min(max, this.steamHeat / 80);
                    int waterToExtract = 0;
                    int waterTankId = f.getInputTanks().getFirstAvailableTank(Materials.DistilledWater.getLiquid(1), true);
                    if (waterTankId < 0) {
                        waterTankId = f.getInputTanks().getFirstAvailableTank(Materials.Water.getLiquid(1), true);
                    }
                    if ((waterTank = waterTankId < 0 ? null : f.getInputTanks().getTank(waterTankId)) != null) {
                        waterToExtract = Math.min(heatMultiplier, waterTank.getFluid().getAmount());
                    }
                    if (waterToExtract > 0) {
                        if (this.hadNoWater) {
                            Utils.createExplosion((Level)this.f_58857_, (BlockPos)this.f_58858_, (float)6.0f, (Explosion.BlockInteraction)Explosion.BlockInteraction.DESTROY);
                            return;
                        }
                        Material steam = Materials.Steam;
                        int waterMultiplier = 160;
                        int steamToAdd = waterToExtract * waterMultiplier;
                        long inserted = f.getOutputTanks().fill(steam.getGas(steamToAdd), IFluidHandler.FluidAction.SIMULATE);
                        int successfulSteam = (int)(inserted / 160L);
                        if (successfulSteam >= 1) {
                            waterToExtract = Math.min(waterToExtract, successfulSteam);
                            waterTank.drain(Utils.ca((int)waterToExtract, (FluidStack)waterTank.getFluid()), IFluidHandler.FluidAction.EXECUTE);
                            f.getOutputTanks().fill(steam.getGas(waterToExtract * waterMultiplier), IFluidHandler.FluidAction.EXECUTE);
                            this.steamHeat -= waterToExtract * 80;
                        }
                        this.hadNoWater = false;
                    } else {
                        this.hadNoWater = true;
                    }
                }
            });
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.steamHeat = tag.m_128451_("steamHeat");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("steamHeat", this.steamHeat);
    }

    public static class SmallHeatExchangerFluidHandler
    extends MachineFluidHandler<BlockEntitySmallHeatExchanger> {
        public SmallHeatExchangerFluidHandler(BlockEntitySmallHeatExchanger tile) {
            super((BlockEntityMachine)tile);
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_IN, b -> {
                b.tank(this::acceptsRecipe, 1000);
                b.tank(this::acceptWater, 4000);
                return b;
            }));
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_OUT, b -> {
                b.tank(f -> !f.getFluid().m_205067_(GTCoreTags.STEAM), 1000);
                b.tank(f -> f.getFluid().m_205067_(GTCoreTags.STEAM), 16000);
                return b;
            }));
        }

        public boolean acceptsRecipe(FluidStack stack) {
            return ((BlockEntitySmallHeatExchanger)this.tile).recipeHandler.map(t -> {
                IRecipeMap map = t.getRecipeMap();
                return map == null || map.acceptsFluid(stack);
            }).orElse(true);
        }

        public boolean acceptWater(FluidStack stack) {
            return stack.getFluid() == Materials.Water.getLiquid() || stack.getFluid() == Materials.DistilledWater.getLiquid();
        }

        public boolean canFluidBeAutoOutput(FluidStack fluid) {
            return fluid.getFluid() != Materials.Steam.getGas();
        }
    }
}

