/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityGenerator;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.item.ItemFluidCell;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityMagicEnergyConverter
extends BlockEntityGenerator<BlockEntityMagicEnergyConverter> {
    long leftoverToInsert;

    public BlockEntityMagicEnergyConverter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityMagicEnergyConverter>(this){

            protected boolean consumeGeneratorResources(boolean simulate) {
                int tFluidAmountToUse;
                FluidStack mFluid;
                MachineEnergyHandler handler = (MachineEnergyHandler)((BlockEntityMagicEnergyConverter)this.tile).energyHandler.orElse(null);
                if (handler == null) {
                    return false;
                }
                if (BlockEntityMagicEnergyConverter.this.leftoverToInsert > 0L) {
                    long inserted = handler.insertInternal(BlockEntityMagicEnergyConverter.this.leftoverToInsert, simulate);
                    if (inserted > 0L) {
                        if (!simulate) {
                            BlockEntityMagicEnergyConverter.this.leftoverToInsert -= inserted;
                        }
                        return true;
                    }
                    return false;
                }
                int toConsume = this.consumedFluidPerOperation(this.activeRecipe);
                long toInsert = this.calculateGeneratorProduction(this.activeRecipe);
                if (this.activeRecipe.hasInputItems()) {
                    // empty if block
                }
                if ((mFluid = ((BlockEntityMagicEnergyConverter)this.tile).fluidHandler.map(f -> f.getInputTanks().getTank(0).getFluid()).orElse(FluidStack.EMPTY)).isEmpty()) {
                    return false;
                }
                int fluidAmount = mFluid.getAmount();
                if (toInsert > 0L && toConsume > 0 && fluidAmount > toConsume && (tFluidAmountToUse = (int)Math.min((long)(fluidAmount / toConsume), (handler.getCapacity() - handler.getEnergy()) / toInsert)) > 0 && handler.insertInternal((long)tFluidAmountToUse * toInsert, true) == (long)tFluidAmountToUse * toInsert) {
                    if (((BlockEntityMagicEnergyConverter)this.tile).m_58904_().m_46467_() % 10L == 0L && !simulate) {
                        handler.insertInternal((long)tFluidAmountToUse * toInsert, false);
                        ((BlockEntityMagicEnergyConverter)this.tile).fluidHandler.ifPresent(f -> f.drainInput(Utils.ca((int)(tFluidAmountToUse * toConsume), (FluidStack)mFluid), IFluidHandler.FluidAction.EXECUTE));
                    }
                    return true;
                }
                return false;
            }

            public int consumedFluidPerOperation(IRecipe r) {
                if (r.hasInputItems()) {
                    return 1;
                }
                return super.consumedFluidPerOperation(r);
            }

            public boolean accepts(ItemStack stack) {
                return super.accepts(stack) || stack.m_41720_() instanceof ItemFluidCell;
            }
        });
        this.itemHandler.set(() -> new MachineItemHandler<BlockEntityMagicEnergyConverter>(this){

            public ITrackedHandler getCellInputHandler() {
                return super.getInputHandler();
            }

            public ITrackedHandler getCellOutputHandler() {
                return super.getOutputHandler();
            }

            public ITrackedHandler getHandler(SlotType<?> type) {
                if (type == SlotType.CELL_IN) {
                    type = SlotType.IT_IN;
                }
                if (type == SlotType.CELL_OUT) {
                    type = SlotType.IT_OUT;
                }
                return super.getHandler(type);
            }
        });
    }

    private long euFromItem(ItemStack tStack) {
        if (tStack.m_41619_()) {
            return 0L;
        }
        if (!tStack.m_41793_()) {
            return 0L;
        }
        long tEU = 0L;
        Map tMap = EnchantmentHelper.m_44831_((ItemStack)tStack);
        for (Map.Entry e : tMap.entrySet()) {
            Enchantment ench = (Enchantment)e.getKey();
            Integer tLevel = (Integer)e.getValue();
            tEU += 1000000L * (long)tLevel.intValue() / (long)ench.m_6586_() / (long)ench.m_44699_().m_44716_();
        }
        return tEU;
    }
}

