/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityLimitedOutput;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.gui.ButtonOverlays;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockEntityItemFilter
extends BlockEntityLimitedOutput<BlockEntityItemFilter>
implements IFilterableHandler {
    boolean blacklist = false;
    boolean nbt = true;
    boolean outputRedstone = false;
    boolean invertRedstone = false;
    boolean emitEnergy = false;

    public BlockEntityItemFilter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntityItemFilter>(this, 0L, this.getMachineTier().getVoltage() * 66L, this.getMachineTier().getVoltage(), this.getMachineTier().getVoltage(), 1, 1){

                public boolean canOutput(Direction direction) {
                    return super.canOutput(direction) && direction == ((BlockEntityItemFilter)this.tile).getFacing().m_122424_() && ((BlockEntityItemFilter)this.tile).emitEnergy;
                }
            });
        }
    }

    @Override
    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == GT5RItems.DataStick) {
            if (stack.m_41737_("displaySlots") == null) {
                this.itemHandler.ifPresent(i -> {
                    CompoundTag displaySlots = (CompoundTag)i.getHandler(SlotType.DISPLAY_SETTABLE).serializeNBT();
                    displaySlots.m_128359_("machineType", this.getMachineType().getLoc().toString());
                    stack.m_41784_().m_128365_("displaySlots", (Tag)displaySlots);
                });
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_12490_, SoundSource.BLOCKS, 10.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            CompoundTag displaySlots = stack.m_41737_("displaySlots");
            if (!displaySlots.m_128456_() && displaySlots.m_128461_("machineType").equals(this.getMachineType().getLoc().toString())) {
                this.itemHandler.ifPresent(i -> i.getHandler(SlotType.DISPLAY_SETTABLE).deserializeNBT((Tag)displaySlots));
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_12490_, SoundSource.BLOCKS, 10.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        if (slotType == SlotType.STORAGE) {
            boolean hasItem = this.itemHandler.map(h -> {
                ObjectArrayList list = new ObjectArrayList();
                ITrackedHandler outputs = h.getHandler(SlotType.DISPLAY_SETTABLE);
                for (int i = 0; i < outputs.getSlots(); ++i) {
                    ItemStack slotStack = outputs.getStackInSlot(i);
                    if (slotStack.m_41619_() || slotStack.m_41720_() != stack.m_41720_() || this.nbt && !Objects.equals(slotStack.m_41783_(), stack.m_41783_())) continue;
                    list.add(slotStack.m_41777_().m_41720_());
                }
                return list.isEmpty() == this.blacklist;
            }).orElse(false);
            return hasItem;
        }
        return true;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            int[] data = ((GuiEvents.GuiEvent)event).data;
            switch (data[1]) {
                case 0: {
                    this.emitEnergy = !this.emitEnergy;
                    playerEntity.m_6352_((Component)Utils.literal((String)(this.emitEnergy ? "Emit energy to output side" : "Don't emit energy")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                    break;
                }
                case 1: {
                    this.outputRedstone = !this.outputRedstone;
                    playerEntity.m_6352_((Component)Utils.literal((String)(this.outputRedstone ? "Emit redstone if slots contain something" : "Don't emit redstone")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                    break;
                }
                case 2: {
                    this.invertRedstone = !this.invertRedstone;
                    playerEntity.m_6352_((Component)Utils.literal((String)((this.invertRedstone ? "I" : "Don't i") + "nvert redstone")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                    break;
                }
                case 3: {
                    this.blacklist = !this.blacklist;
                    playerEntity.m_6352_((Component)Utils.literal((String)((this.blacklist ? "I" : "Don't i") + "nvert filter")), playerEntity.m_142081_());
                    break;
                }
                case 4: {
                    this.nbt = !this.nbt;
                    playerEntity.m_6352_((Component)Utils.literal((String)(this.nbt ? "NBT has to match" : "Ignore NBT")), playerEntity.m_142081_());
                }
            }
        }
    }

    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addSwitchButton(8, 63, 16, 16, ButtonOverlays.ENERGY_OFF, ButtonOverlays.ENERGY_ON, h -> ((BlockEntityItemFilter)h).emitEnergy, true);
        instance.addSwitchButton(26, 63, 16, 16, ButtonOverlays.REDSTONE_CONTROL_OFF, ButtonOverlays.REDSTONE_CONTROL_ON, h -> ((BlockEntityItemFilter)h).outputRedstone, true);
        instance.addSwitchButton(44, 63, 16, 16, ButtonOverlays.INVERT_REDSTONE_OFF, ButtonOverlays.INVERT_REDSTONE_ON, h -> ((BlockEntityItemFilter)h).invertRedstone, true);
        instance.addSwitchButton(62, 63, 16, 16, ButtonOverlays.BLACKLIST_OFF, ButtonOverlays.BLACKLIST_ON, h -> ((BlockEntityItemFilter)h).blacklist, true);
        instance.addSwitchButton(80, 63, 16, 16, ButtonOverlays.NBT_OFF, ButtonOverlays.NBT_ON, h -> ((BlockEntityItemFilter)h).nbt, true);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getCover(this.getFacing().m_122424_()).isEmpty()) {
            this.processItemOutput();
        }
    }

    public void onMachineEvent(IMachineEvent event, Object ... data) {
        super.onMachineEvent(event, data);
        if ((event == SlotType.IT_OUT || event == SlotType.IT_IN) && this.outputRedstone && !this.m_58904_().m_5776_()) {
            this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
        }
    }

    protected boolean processItemOutput() {
        Direction outputDir = this.getFacing().m_122424_();
        BlockEntity adjTile = this.getCachedBlockEntity(outputDir);
        if (adjTile == null) {
            return false;
        }
        boolean[] booleans = new boolean[]{false};
        adjTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputDir.m_122424_()).ifPresent(adjHandler -> {
            booleans[0] = this.itemHandler.map(h -> this.transferItems((IItemHandler)h.getHandler(SlotType.STORAGE), (IItemHandler)adjHandler, true)).orElse(false);
        });
        return booleans[0];
    }

    public int getWeakRedstonePower(Direction facing) {
        if (this.outputRedstone) {
            int[] redstone = new int[]{this.itemHandler.map(i -> {
                for (int slot = 0; slot < i.getHandler(SlotType.STORAGE).getSlots(); ++slot) {
                    ItemStack stack = i.getHandler(SlotType.STORAGE).getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    return this.invertRedstone ? 0 : 15;
                }
                return this.invertRedstone ? 15 : 0;
            }).orElse(0)};
            if (redstone[0] > 0) {
                return redstone[0];
            }
        }
        return super.getWeakRedstonePower(facing);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        CompoundTag tag1;
        if (tag.m_128441_("it") && (tag1 = tag.m_128469_("it")).m_128441_("filterable")) {
            CompoundTag filterable = tag1.m_128469_("filterable");
            tag1.m_128365_(SlotType.STORAGE.getId(), (Tag)filterable);
        }
        super.m_142466_(tag);
        this.blacklist = tag.m_128471_("blacklist");
        this.nbt = tag.m_128471_("nbt");
        this.outputRedstone = tag.m_128471_("outputRedstone");
        this.invertRedstone = tag.m_128471_("invertRedstone");
        this.emitEnergy = tag.m_128471_("emitEnergy");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("blacklist", this.blacklist);
        tag.m_128379_("nbt", this.nbt);
        tag.m_128379_("outputRedstone", this.outputRedstone);
        tag.m_128379_("invertRedstone", this.invertRedstone);
        tag.m_128379_("emitEnergy", this.emitEnergy);
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public boolean isEmitEnergy() {
        return this.emitEnergy;
    }

    public boolean isInvertRedstone() {
        return this.invertRedstone;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public boolean isOutputRedstone() {
        return this.outputRedstone;
    }
}

