/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityLimitedOutput;
import org.gtreimagined.gt5r.gui.ButtonOverlays;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityBuffer
extends BlockEntityLimitedOutput<BlockEntityBuffer> {
    boolean emitEnergy = false;
    boolean outputRedstone = false;
    boolean invertRedstone = false;

    public BlockEntityBuffer(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntityBuffer>(this, 0L, this.getMachineTier().getVoltage() * 66L, this.getMachineTier().getVoltage(), this.getMachineTier().getVoltage(), 1, 1){

                public boolean canOutput(Direction direction) {
                    return super.canOutput(direction) && direction == ((BlockEntityBuffer)this.tile).getFacing().m_122424_() && ((BlockEntityBuffer)this.tile).emitEnergy;
                }
            });
        }
    }

    public int getWeakRedstonePower(Direction facing) {
        if (this.outputRedstone) {
            int[] redstone = new int[]{this.itemHandler.map(i -> {
                for (int slot = 0; slot < i.getHandler(SlotType.STORAGE).getSlots(); ++slot) {
                    ItemStack stack = i.getHandler(SlotType.STORAGE).getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    return this.invertRedstone ? 0 : 15;
                }
                return this.invertRedstone ? 15 : 0;
            }).orElse(0)};
            if (redstone[0] > 0) {
                return redstone[0];
            }
        }
        return super.getWeakRedstonePower(facing);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getCover(this.getFacing().m_122424_()).isEmpty()) {
            this.processItemOutput();
        }
        this.itemHandler.ifPresent(h -> Utils.tryCondenseInventory((IItemHandlerModifiable)h.getHandler(SlotType.STORAGE)));
    }

    protected boolean processItemOutput() {
        Direction outputDir = this.getFacing().m_122424_();
        BlockEntity adjTile = this.getCachedBlockEntity(outputDir);
        if (adjTile == null) {
            return false;
        }
        boolean[] booleans = new boolean[]{false};
        adjTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputDir.m_122424_()).ifPresent(adjHandler -> {
            booleans[0] = this.itemHandler.map(h -> this.transferItems((IItemHandler)h.getHandler(SlotType.STORAGE), (IItemHandler)adjHandler, true)).orElse(false);
        });
        return booleans[0];
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("outputRedstone", this.outputRedstone);
        tag.m_128379_("invertRedstone", this.invertRedstone);
        tag.m_128379_("emitEnergy", this.emitEnergy);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.outputRedstone = tag.m_128471_("outputRedstone");
        this.invertRedstone = tag.m_128471_("invertRedstone");
        this.emitEnergy = tag.m_128471_("emitEnergy");
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            int[] data = ((GuiEvents.GuiEvent)event).data;
            switch (data[1]) {
                case 0: {
                    this.emitEnergy = !this.emitEnergy;
                    playerEntity.m_6352_((Component)Utils.literal((String)(this.emitEnergy ? "Emit energy to output side" : "Don't emit energy")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                    break;
                }
                case 1: {
                    this.outputRedstone = !this.outputRedstone;
                    playerEntity.m_6352_((Component)Utils.literal((String)(this.outputRedstone ? "Emit redstone if slots contain something" : "Don't emit redstone")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                    break;
                }
                case 2: {
                    this.invertRedstone = !this.invertRedstone;
                    playerEntity.m_6352_((Component)Utils.literal((String)((this.invertRedstone ? "I" : "Don't i") + "nvert redstone")), playerEntity.m_142081_());
                    this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
                }
            }
        }
    }

    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addSwitchButton(8, 63, 16, 16, ButtonOverlays.ENERGY_OFF, ButtonOverlays.ENERGY_ON, h -> ((BlockEntityBuffer)h).emitEnergy, true);
        instance.addSwitchButton(26, 63, 16, 16, ButtonOverlays.REDSTONE_CONTROL_OFF, ButtonOverlays.REDSTONE_CONTROL_ON, h -> ((BlockEntityBuffer)h).outputRedstone, true);
        instance.addSwitchButton(44, 63, 16, 16, ButtonOverlays.INVERT_REDSTONE_OFF, ButtonOverlays.INVERT_REDSTONE_ON, h -> ((BlockEntityBuffer)h).invertRedstone, true);
    }
}

