/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityBath
extends BlockEntityMachine<BlockEntityBath> {
    public BlockEntityBath(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityBath>(this){

            public IRecipe findRecipe() {
                IRecipe recipe = super.findRecipe();
                if (recipe == null) {
                    ITrackedHandler container = ((MachineItemHandler)BlockEntityBath.this.itemHandler.get()).getInputHandler();
                    ItemStack input = container != null ? container.getStackInSlot(0) : ItemStack.f_41583_;
                    ResourceLocation id = RegistryUtils.getIdFromItem((Item)input.m_41720_());
                    FluidStack fluidInput = BlockEntityBath.this.fluidHandler.map(f -> f.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                    if (!fluidInput.isEmpty()) {
                        if (input.m_41720_() == Items.f_42265_) {
                            DyeColor color = BlockEntityBath.this.fromFluid(fluidInput);
                            if (color != null && fluidInput.getAmount() >= 72) {
                                ItemStack output = new ItemStack((ItemLike)RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(color.m_41065_() + "_shulker_box")));
                                output.m_41751_(input.m_41783_());
                                return RecipeMaps.BATH.RB().recipeMapOnly().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)input.m_41777_())}).fi(new FluidStack[]{Utils.ca((int)72, (FluidStack)fluidInput)}).io(new ItemStack[]{output}).add(color.m_41065_() + "_shulker_box", 64L);
                            }
                        } else if (id.m_135815_().contains("_shulker_box") && id.m_135827_().equals("minecraft") && fluidInput.isFluidEqual(Materials.Chlorine.getGas(50)) && fluidInput.getAmount() >= 50) {
                            ItemStack output = new ItemStack((ItemLike)Items.f_42265_);
                            output.m_41751_(input.m_41783_());
                            return RecipeMaps.BATH.RB().recipeMapOnly().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)input.m_41777_())}).fi(new FluidStack[]{Materials.Chlorine.getGas(50)}).io(new ItemStack[]{output}).add("shulker_box", 64L);
                        }
                    }
                }
                return recipe;
            }

            public boolean accepts(ItemStack stack) {
                ResourceLocation id = RegistryUtils.getIdFromItem((Item)stack.m_41720_());
                return super.accepts(stack) || id.m_135815_().contains("shulker_box") && id.m_135827_().equals("minecraft");
            }

            public CompoundTag serialize() {
                CompoundTag nbt = super.serialize();
                if (this.activeRecipe != null) {
                    nbt.m_128359_("activeRecipe", this.activeRecipe.toJson().toString());
                }
                if (this.lastRecipe != null) {
                    nbt.m_128359_("lastRecipe", this.lastRecipe.toJson().toString());
                }
                return nbt;
            }

            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                if (nbt.m_128441_("activeRecipe")) {
                    this.activeRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("AR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("activeRecipe")));
                }
                if (nbt.m_128441_("lastRecipe")) {
                    this.lastRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("LR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("lastRecipe")));
                }
            }
        });
    }

    private DyeColor fromFluid(FluidStack f) {
        for (DyeColor color : DyeColor.values()) {
            if (!f.getFluid().m_205067_(TagUtils.getFluidTag((ResourceLocation)new ResourceLocation("gt5r", color.m_41065_() + "_dye")))) continue;
            return color;
        }
        return null;
    }
}

