/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityDrillingRigBase;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.worldgen.OilSpoutEntry;
import org.gtreimagined.gt5r.worldgen.OilSpoutSavedData;
import org.gtreimagined.gtlib.capability.machine.MultiMachineEnergyHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityOilDrillingRig
extends BlockEntityDrillingRigBase<BlockEntityOilDrillingRig> {
    int progress = 0;
    OilSpoutEntry oilEntry = null;
    int outputTicker = 0;

    public BlockEntityOilDrillingRig(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void run(Level level, BlockPos pos, BlockState state) {
        if (this.oilEntry == null) {
            this.oilEntry = OilSpoutSavedData.getOrCreate((ServerLevel)level).getFluidVeinWorldEntry(SectionPos.m_123171_((int)this.miningPos.m_123341_()), SectionPos.m_123171_((int)this.miningPos.m_123343_()));
        }
        if (this.oilEntry.getFluid() == null) {
            return;
        }
        FluidStack fluidHolder = new FluidStack(this.oilEntry.getFluid().fluid(), this.oilEntry.getCurrentYield());
        if (this.outputTicker > 0) {
            --this.outputTicker;
            return;
        }
        if (this.progress == 0 && !this.fluidHandler.map(f -> f.fillOutput(fluidHolder, IFluidHandler.FluidAction.SIMULATE) == this.oilEntry.getCurrentYield()).orElse(false).booleanValue()) {
            this.outputTicker = 40;
            this.setMachineState(MachineState.IDLE);
            return;
        }
        this.setActive();
        this.energyHandler.ifPresent(e -> e.extractEu((long)this.euPerTick, false));
        if (++this.progress == this.cycle) {
            this.progress = 0;
            if (this.fluidHandler.map(f -> f.fillOutput(fluidHolder, IFluidHandler.FluidAction.SIMULATE) == this.oilEntry.getCurrentYield()).orElse(false).booleanValue()) {
                this.fluidHandler.ifPresent(f -> f.fillOutput(fluidHolder, IFluidHandler.FluidAction.EXECUTE));
                this.onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
                this.oilEntry.decreaseLevel();
            }
        }
    }

    @Override
    protected BlockEntityDrillingRigBase.MineResult mineBelowBlock(Level level, BlockPos pos, boolean dropBlock, ItemStack item) {
        BlockState belowBlockState;
        boolean flag;
        boolean miningPipe;
        BlockState blockstate = level.m_8055_(pos);
        BlockState aboveBlockState = level.m_8055_(pos.m_7494_());
        if (aboveBlockState.m_60734_() != GT5RBlocks.MINING_PIPE && pos.m_123342_() + 1 != this.m_58899_().m_123342_()) {
            this.resetMiningPos();
            return BlockEntityDrillingRigBase.MineResult.PIPE_BROKEN;
        }
        if (blockstate.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return BlockEntityDrillingRigBase.MineResult.FOUND_OBSTRUCTION;
        }
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
        }
        boolean bl = miningPipe = blockstate.m_60734_() == GT5RBlocks.MINING_PIPE || blockstate.m_60734_() == GT5RBlocks.MINING_PIPE_THIN;
        if (!miningPipe && !this.mineBlock(level, pos, dropBlock, item)) {
            return BlockEntityDrillingRigBase.MineResult.FOUND_OBSTRUCTION;
        }
        boolean bl2 = flag = blockstate.m_60734_() == GT5RBlocks.MINING_PIPE || level.m_6933_(pos, GT5RBlocks.MINING_PIPE.m_49966_(), 3, 512);
        if (flag && pos.m_123342_() + 1 < this.m_58899_().m_123342_()) {
            level.m_7731_(pos.m_7494_(), GT5RBlocks.MINING_PIPE_THIN.m_49966_(), 11);
        }
        if ((belowBlockState = level.m_8055_(pos.m_7495_())).m_60734_() == Blocks.f_50752_ || belowBlockState.m_60734_() == Blocks.f_50626_) {
            return miningPipe ? BlockEntityDrillingRigBase.MineResult.FOUND_BOTTOM_MINING_PIPE : BlockEntityDrillingRigBase.MineResult.FOUND_BOTTOM;
        }
        return miningPipe ? BlockEntityDrillingRigBase.MineResult.FOUND_MINING_PIPE : BlockEntityDrillingRigBase.MineResult.FOUND_MINEABLE;
    }

    public void afterStructureFormed() {
        super.afterStructureFormed();
        this.energyHandler.ifPresent(e -> {
            int tier = ((MultiMachineEnergyHandler)e).getAccumulatedPower().getIntegerId();
            this.euPerTick = 3 * (1 << (tier << 1));
            this.cycle = (int)(160.0 * (tier == 0 ? 2.0 : Math.pow(0.5, tier - 1)));
        });
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("progress");
    }

    public WidgetSupplier getInfoWidget() {
        return OilInfoWidget.build().setPos(10, 10);
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        OilInfoWidget oilInfoWidget = (OilInfoWidget)instance;
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            return 16;
        }
        if (instance.drawActiveInfo()) {
            if (oilInfoWidget.foundBottom) {
                renderer.m_92883_(stack, "Progress: " + instance.currentProgress + "/" + instance.maxProgress, (float)left, (float)(top + 8), 0xFAFAFF);
                return 16;
            }
            if (oilInfoWidget.stopped && oilInfoWidget.currentPos != null) {
                renderer.m_92883_(stack, "Can't mine at: " + String.valueOf(oilInfoWidget.currentPos), (float)left, (float)(top + 8), 0xFAFAFF);
                renderer.m_92883_(stack, "Y: " + oilInfoWidget.currentPos.m_123342_(), (float)left, (float)(top + 16), 0xFAFAFF);
                return 24;
            }
            if (oilInfoWidget.currentPos != null) {
                renderer.m_92883_(stack, "Mining Position at: ", (float)left, (float)(top + 8), 0xFAFAFF);
                renderer.m_92883_(stack, "Y: " + oilInfoWidget.currentPos.m_123342_(), (float)left, (float)(top + 16), 0xFAFAFF);
                return 24;
            }
        }
        return 8;
    }

    public static class OilInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        BlockPos currentPos;
        boolean stopped;
        boolean foundBottom;

        protected OilInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            BlockEntityOilDrillingRig m = (BlockEntityOilDrillingRig)this.gui.handler;
            this.gui.syncLong(() -> m.miningPos.m_121878_(), l -> {
                this.currentPos = BlockPos.m_122022_((long)l);
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncBoolean(() -> m.stopped, s -> {
                this.stopped = s;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncBoolean(() -> m.foundBottom, b -> {
                this.foundBottom = b;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.progress, i -> {
                this.currentProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.cycle, i -> {
                this.maxProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return OilInfoWidget.builder((a, b) -> new OilInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

