/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtcore.item.ItemSelectorTag;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.machine.DefaultHeatHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineFluidHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityLargeHeatExchanger
extends BlockEntityMultiMachine<BlockEntityLargeHeatExchanger>
implements IFilterableHandler {
    int superheatedThreshold = Integer.MAX_VALUE;
    int efficiency = 1000;
    int dryHeatCounter = 0;
    int dryHeatMaximum = 100;
    boolean fullOfSteam = false;

    public BlockEntityLargeHeatExchanger(Machine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatHandler.set(() -> new DefaultHeatHandler((BlockEntityBase)this, Integer.MAX_VALUE, 80, 0));
        this.fluidHandler.set(() -> new MultiMachineFluidHandler<BlockEntityLargeHeatExchanger>(this){

            protected int compareOutputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
                return ((BlockEntityMachine)a.getTile()).m_58899_().m_123342_() == ((BlockEntityLargeHeatExchanger)this.tile).m_58899_().m_123342_() ? -1 : 1;
            }

            protected int compareInputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
                return ((BlockEntityMachine)a.getTile()).m_58899_().m_123342_() == ((BlockEntityLargeHeatExchanger)this.tile).m_58899_().m_123342_() + 3 ? -1 : 1;
            }
        });
        this.recipeHandler.set(() -> new ParallelRecipeHandler<BlockEntityLargeHeatExchanger>(this, 1){

            protected boolean validateRecipe(IRecipe r) {
                return super.validateRecipe(r) && !r.getTags().contains("small_heat_exchanged_only");
            }

            @Override
            protected int maxSimultaneousRecipes() {
                if (this.activeRecipe != null) {
                    int base = 100;
                    long totalHu = this.activeRecipe.getTotalPower();
                    if (totalHu == 0L) {
                        return 0;
                    }
                    double ratio = 80.0 / (double)totalHu;
                    int totalRecipes = (int)((double)base * ratio);
                    return Math.max(1, totalRecipes);
                }
                return super.maxSimultaneousRecipes();
            }

            protected boolean canRecipeContinue() {
                return super.canRecipeContinue() && BlockEntityLargeHeatExchanger.this.heatHandler.map(h -> (long)h.getHeat() + this.activeRecipe.getTotalPower() <= (long)h.getHeatCap()).orElse(false) != false && !BlockEntityLargeHeatExchanger.this.fullOfSteam;
            }

            @Override
            public boolean canOutput() {
                return !((BlockEntityLargeHeatExchanger)this.tile).fluidHandler.isPresent() || !this.activeRecipe.hasOutputFluids() || ((BlockEntityLargeHeatExchanger)this.tile).fluidHandler.map(t -> t.getOutputTanks() != null && t.getOutputTanks().getTanks() > 1 && t.getOutputTanks().getTank(0).fill(Utils.ca((int)(this.activeRecipe.getOutputFluids()[0].getAmount() * this.concurrentRecipes), (FluidStack)this.activeRecipe.getOutputFluids()[0]), IFluidHandler.FluidAction.SIMULATE) == this.activeRecipe.getOutputFluids()[0].getAmount() * this.concurrentRecipes).orElse(false) != false;
            }

            public boolean consumeResourceForRecipe(boolean simulate) {
                return true;
            }

            @Override
            protected void addOutputs() {
                for (int i = 0; i < this.concurrentRecipes; ++i) {
                    if (this.activeRecipe.hasOutputItems()) {
                        ((BlockEntityLargeHeatExchanger)this.tile).itemHandler.ifPresent(h -> {
                            ItemStack[] out = this.activeRecipe.getOutputItems(true);
                            if (h.canOutputsFit(out)) {
                                h.addOutputs(out);
                            } else {
                                h.addOutputs(this.activeRecipe.getFlatOutputItems());
                            }
                        });
                    }
                    if (this.activeRecipe.hasOutputFluids()) {
                        ((BlockEntityLargeHeatExchanger)this.tile).fluidHandler.ifPresent(h -> {
                            if (h.getOutputTanks() == null) {
                                return;
                            }
                            h.getOutputTanks().getTank(0).fill(this.activeRecipe.getOutputFluids()[0].copy(), IFluidHandler.FluidAction.EXECUTE);
                        });
                    }
                    BlockEntityLargeHeatExchanger.this.heatHandler.ifPresent(h -> h.insert((int)this.activeRecipe.getPower(), false));
                }
                if (this.activeRecipe.hasOutputItems()) {
                    ((BlockEntityLargeHeatExchanger)this.tile).onMachineEvent((IMachineEvent)MachineEvent.ITEMS_OUTPUTTED, new Object[0]);
                }
                if (this.activeRecipe.hasOutputFluids()) {
                    ((BlockEntityLargeHeatExchanger)this.tile).onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
                }
            }

            @Override
            protected boolean consumeSingleInput(boolean simulate) {
                boolean flag = true;
                if (!((BlockEntityLargeHeatExchanger)this.tile).hadFirstTick()) {
                    return true;
                }
                List[] itemInputs = new List[]{new ArrayList()};
                List[] fluidInputs = new List[]{new ArrayList()};
                if (this.activeRecipe.hasInputItems()) {
                    flag &= ((BlockEntityLargeHeatExchanger)this.tile).itemHandler.map(h -> {
                        itemInputs[0] = h.consumeInputs(this.activeRecipe, simulate);
                        return !itemInputs[0].isEmpty();
                    }).orElse(true).booleanValue();
                }
                if (this.activeRecipe.hasInputFluids()) {
                    flag &= ((BlockEntityLargeHeatExchanger)this.tile).fluidHandler.map(h -> {
                        fluidInputs[0] = ((FluidIngredient)this.activeRecipe.getInputFluids().get(0)).drain((IFluidHandler)h.getInputTanks().getTank(0), simulate);
                        return !fluidInputs[0].isEmpty();
                    }).orElse(true).booleanValue();
                }
                if (!simulate) {
                    if (flag) {
                        this.consumedResources = true;
                    }
                    this.itemInputs = itemInputs[0];
                    this.fluidInputs = fluidInputs[0];
                }
                return flag;
            }
        });
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.onMachineEvent((IMachineEvent)SlotType.STORAGE, new Object[0]);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (level.m_46467_() % 20L == 0L && this.getMachineState() != MachineState.DISABLED) {
            this.fluidHandler.ifPresent(f -> this.heatHandler.ifPresent(h -> {
                if (h.getHeat() >= 80) {
                    int heatMultiplier = h.getHeat() / 80;
                    if (f.getInputTanks() == null) {
                        return;
                    }
                    FluidTank waterTank = f.getInputTanks().getTank(1);
                    if (waterTank != null && waterTank.getFluidInTank(0).isFluidEqual(Materials.DistilledWater.getLiquid(1))) {
                        if (waterTank.drain(Materials.DistilledWater.getLiquid(heatMultiplier = Math.min(heatMultiplier, waterTank.getFluidAmount())), IFluidHandler.FluidAction.SIMULATE).getAmount() == heatMultiplier) {
                            if (f.getOutputTanks() != null && f.getOutputTanks().getTanks() >= 2) {
                                Material steam = Materials.Steam;
                                if (h.getHeat() >= this.superheatedThreshold) {
                                    steam = Materials.SuperheatedSteam;
                                }
                                float tEfficiency = steam == Materials.Steam ? 1.0f : (float)this.efficiency / 1000.0f;
                                int waterMultiplier = steam == Materials.Steam ? 160 : 80;
                                int steamToAdd = (int)((float)(heatMultiplier * waterMultiplier) * tEfficiency);
                                long inserted = f.getOutputTanks().getTank(1).fill(steam.getGas(steamToAdd), IFluidHandler.FluidAction.SIMULATE);
                                if (inserted >= 1L) {
                                    heatMultiplier = Math.min(heatMultiplier, (int)((float)inserted / tEfficiency));
                                    f.drainInput(Materials.DistilledWater.getLiquid(heatMultiplier), IFluidHandler.FluidAction.EXECUTE);
                                    f.getOutputTanks().getTank(1).fill(steam.getGas(steamToAdd), IFluidHandler.FluidAction.EXECUTE);
                                    h.extractInternal(heatMultiplier * 80, false);
                                    this.fullOfSteam = false;
                                } else {
                                    this.fullOfSteam = true;
                                }
                            }
                            this.dryHeatCounter = 0;
                        } else {
                            ++this.dryHeatCounter;
                        }
                    } else {
                        ++this.dryHeatCounter;
                    }
                }
            }));
            if (this.dryHeatCounter >= this.dryHeatMaximum) {
                this.explodeMultiblock();
            }
        }
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        if (slotType == SlotType.STORAGE) {
            return stack.m_41720_() instanceof ItemSelectorTag;
        }
        return true;
    }

    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == SlotType.STORAGE) {
            ItemStack circuit = this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
            Item item = circuit.m_41720_();
            if (item instanceof ItemSelectorTag) {
                ItemSelectorTag circuit1 = (ItemSelectorTag)item;
                this.superheatedThreshold = 80000 - circuit1.circuitId * 3000;
                this.efficiency = 1000 - circuit1.circuitId * 15;
            } else {
                this.superheatedThreshold = Integer.MAX_VALUE;
                this.efficiency = 1000;
            }
        }
        super.onMachineEvent(event, data);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("efficiency", this.efficiency);
        tag.m_128379_("fullOfSteam", this.fullOfSteam);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.efficiency = tag.m_128451_("efficiency");
        this.fullOfSteam = tag.m_128471_("fullOfSteam");
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int size = super.drawInfo(instance, stack, renderer, left, top);
        renderer.m_92883_(stack, "Heat: " + ((HeatInfoWidget)instance).heat, (float)left, (float)(top + size), 0xFAFAFF);
        return size + 8;
    }

    public WidgetSupplier getInfoWidget() {
        return HeatInfoWidget.build().setPos(10, 10);
    }

    public static class HeatInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        public int heat;

        protected HeatInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public static WidgetSupplier build() {
            return HeatInfoWidget.builder((a, b) -> new HeatInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }

        public void init() {
            super.init();
            BlockEntityLargeHeatExchanger m = (BlockEntityLargeHeatExchanger)this.gui.handler;
            this.gui.syncInt(() -> m.heatHandler.map(DefaultHeatHandler::getHeat).orElse(0), a -> {
                this.heat = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }
}

