/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;

public class BlockEntityCombustionEngine
extends BlockEntityMultiMachine<BlockEntityCombustionEngine> {
    long lastEu = 0L;
    long lastConsumption = 0L;
    int startup = 0;

    public BlockEntityCombustionEngine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityCombustionEngine>(this){
            int lubeTicker;
            {
                this.lubeTicker = 0;
            }

            protected boolean consumeGeneratorResources(boolean simulate) {
                int lubeConsume;
                boolean boostEU = BlockEntityCombustionEngine.this.fluidHandler.map(f -> f.drainInput(Materials.Oxygen.getGas(2), IFluidHandler.FluidAction.SIMULATE).getAmount() == 2).orElse(false);
                int fuelConsumption = (int)(boostEU ? 4096L / this.activeRecipe.getPower() : 2048L / this.activeRecipe.getPower());
                int n = lubeConsume = boostEU ? 2 : 1;
                if ((this.lubeTicker == 72 || simulate) && !BlockEntityCombustionEngine.this.fluidHandler.map(f -> f.drainInput(Materials.Lubricant.getLiquid(lubeConsume), IFluidHandler.FluidAction.SIMULATE).getAmount() == lubeConsume).orElse(false).booleanValue()) {
                    if (!simulate && BlockEntityCombustionEngine.this.startup > 0) {
                        BlockEntityCombustionEngine.this.startup = 0;
                    }
                    return false;
                }
                int toConsume = fuelConsumption * ((FluidIngredient)this.activeRecipe.getInputFluids().get(0)).getAmount();
                if (BlockEntityCombustionEngine.this.fluidHandler.map(f -> !f.consumeAndReturnInputs(List.of(((FluidIngredient)this.activeRecipe.getInputFluids().get(0)).copy(toConsume)), simulate).isEmpty()).orElse(false).booleanValue()) {
                    if (!simulate) {
                        if (BlockEntityCombustionEngine.this.startup > 100) {
                            BlockEntityCombustionEngine.this.startup = 100;
                        }
                        BlockEntityCombustionEngine.this.fluidHandler.ifPresent(f -> {
                            f.drainInput(Materials.Oxygen.getGas(2), IFluidHandler.FluidAction.EXECUTE);
                            if (this.lubeTicker == 72) {
                                f.drainInput(Materials.Lubricant.getLiquid(lubeConsume), IFluidHandler.FluidAction.EXECUTE);
                            }
                        });
                        BlockEntityCombustionEngine.this.lastConsumption = toConsume;
                        long euPerTick = boostEU ? 6144L : 2048L;
                        BlockEntityCombustionEngine.this.lastEu = BlockEntityCombustionEngine.this.startup < 20 ? 0L : (long)((float)euPerTick * ((float)BlockEntityCombustionEngine.this.startup / 100.0f));
                        BlockEntityCombustionEngine.this.energyHandler.ifPresent(e -> {
                            e.insertInternal(BlockEntityCombustionEngine.this.lastEu, simulate);
                            if (BlockEntityCombustionEngine.this.lastEu > e.getOutputVoltage()) {
                                BlockEntityCombustionEngine.this.explodeMultiblock();
                            }
                        });
                        if (BlockEntityCombustionEngine.this.startup < 100) {
                            ++BlockEntityCombustionEngine.this.startup;
                        }
                        ++this.lubeTicker;
                        if (this.lubeTicker > 72) {
                            this.lubeTicker = 0;
                        }
                    }
                    return true;
                }
                if (!simulate && BlockEntityCombustionEngine.this.startup > 0) {
                    BlockEntityCombustionEngine.this.startup = 0;
                }
                return false;
            }

            protected boolean canRecipeContinue() {
                boolean canContinue = super.canRecipeContinue();
                boolean boostEU = BlockEntityCombustionEngine.this.fluidHandler.map(f -> f.drainInput(Materials.Oxygen.getGas(2), IFluidHandler.FluidAction.SIMULATE).getAmount() == 2).orElse(false);
                FluidIngredient ingredient = (FluidIngredient)this.activeRecipe.getInputFluids().get(0);
                int fuelConsumption = (int)(boostEU ? 4096L / this.activeRecipe.getPower() : 2048L / this.activeRecipe.getPower());
                FluidIngredient finalIngredient = ingredient = ingredient.copy(fuelConsumption);
                return canContinue && (!this.activeRecipe.hasInputFluids() || ((BlockEntityCombustionEngine)this.tile).fluidHandler.map(t -> !t.consumeAndReturnInputs(Collections.singletonList(finalIngredient), true).isEmpty()).orElse(false) != false);
            }

            protected boolean validateRecipe(IRecipe r) {
                boolean canContinue = super.validateRecipe(r);
                boolean boostEU = BlockEntityCombustionEngine.this.fluidHandler.map(f -> f.drainInput(Materials.Oxygen.getGas(2), IFluidHandler.FluidAction.SIMULATE).getAmount() == 2).orElse(false);
                FluidIngredient ingredient = (FluidIngredient)r.getInputFluids().get(0);
                int fuelConsumption = (int)(boostEU ? 4096L / r.getPower() : 2048L / r.getPower());
                FluidIngredient finalIngredient = ingredient = ingredient.copy(fuelConsumption);
                return canContinue && (!r.hasInputFluids() || ((BlockEntityCombustionEngine)this.tile).fluidHandler.map(t -> !t.consumeAndReturnInputs(Collections.singletonList(finalIngredient), true).isEmpty()).orElse(false) != false);
            }

            protected void recipeFailure() {
                super.recipeFailure();
                this.activeRecipe = null;
                this.checkRecipe();
            }

            public CompoundTag serialize() {
                CompoundTag nbt = super.serialize();
                nbt.m_128405_("startup", BlockEntityCombustionEngine.this.startup);
                nbt.m_128405_("lubeTicker", this.lubeTicker);
                return nbt;
            }

            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                BlockEntityCombustionEngine.this.startup = nbt.m_128451_("startup");
                this.lubeTicker = nbt.m_128451_("lubeTicker");
            }
        });
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        CombustionEngineWidget widget = (CombustionEngineWidget)instance;
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            return 16;
        }
        if (instance.drawActiveInfo()) {
            renderer.m_92883_(stack, "EU/t: " + widget.lastEU, (float)left, (float)(top + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "Startup progress: " + (float)widget.startup / 100.0f * 100.0f + "%", (float)left, (float)(top + 16), 0xFAFAFF);
            renderer.m_92883_(stack, "Current: " + widget.currentConsumption + " mb/t", (float)left, (float)(top + 24), 0xFAFAFF);
            return 32;
        }
        return 8;
    }

    public WidgetSupplier getInfoWidget() {
        return CombustionEngineWidget.build().setPos(10, 10);
    }

    public static class CombustionEngineWidget
    extends InfoRenderWidget.MultiRenderWidget {
        public long currentConsumption = 0L;
        public long lastEU = 0L;
        public int startup = 0;

        protected CombustionEngineWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            BlockEntityCombustionEngine turbine = (BlockEntityCombustionEngine)this.gui.handler;
            this.gui.syncLong(() -> turbine.lastEu, i -> {
                this.lastEU = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> turbine.startup, i -> {
                this.startup = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> turbine.lastConsumption, i -> {
                this.currentConsumption = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return CombustionEngineWidget.builder((a, b) -> new CombustionEngineWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

