/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.ore.StoneType;

public class GT5RRemapping {
    private static final Map<String, String> REMAPPING_MAP = new Object2ObjectArrayMap();

    public static void init() {
        GTRemapping.getBeRemappingFunctionList().add(r -> {
            if (r.m_135827_().equals("gregtech") || r.m_135827_().equals("gti")) {
                ResourceLocation r2 = new ResourceLocation("gt5r", r.m_135815_());
                if (GTRemapping.getBeRemappingMap().containsKey(r2)) {
                    return (ResourceLocation)GTRemapping.getBeRemappingMap().get(r2);
                }
                return r2;
            }
            return r;
        });
        Materials.Sylvite.getTypes().forEach(type -> {
            String id = type.getId() + "_sylvite";
            String oldId = type.getId() + "_rock_salt";
            if (type != GTMaterialTypes.ORE && type != GTMaterialTypes.SMALL_ORE) {
                GTRemapping.remap((ResourceLocation)new ResourceLocation("antimatter_shared", oldId), (ResourceLocation)new ResourceLocation("antimatter_shared", id));
            } else {
                GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(a -> GTRemapping.remap((ResourceLocation)new ResourceLocation("antimatter_shared", oldId + "_" + a.getId()), (ResourceLocation)new ResourceLocation("antimatter_shared", id + "_" + a.getId())));
            }
            if (type == GTMaterialTypes.BEARING_ROCK) {
                GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(a -> GTRemapping.remap((ResourceLocation)new ResourceLocation("antimatter_shared", "surface_rock_rock_salt_" + a.getId()), (ResourceLocation)new ResourceLocation("antimatter_shared", "surface_rock_sylvite_" + a.getId())));
            }
            if (type == GTMaterialTypes.ROCK) {
                GTRemapping.remap((ResourceLocation)new ResourceLocation("antimatter_shared", "surface_rock_rock_salt"), (ResourceLocation)new ResourceLocation("antimatter_shared", "surface_rock_sylvite"));
            }
        });
        for (CoverFactory cover : GTAPI.all(CoverFactory.class, (String)"gt5r")) {
            GTRemapping.remapCover((ResourceLocation)new ResourceLocation("gti", cover.getId()), (ResourceLocation)cover.getLoc());
        }
        for (int i = 0; i < 25; ++i) {
            GT5RRemapping.remapGTCore("int_circuit_" + i, "selector_tag_" + i);
        }
        GTRemapping.remapBlockEntity((ResourceLocation)new ResourceLocation("antimatter_shared", "fluid_pipe_polyethylene"), (ResourceLocation)new ResourceLocation("antimatter_shared", "fluid_pipe_plastic"));
        GT5RRemapping.remap("bath_hv", "bath");
        GT5RRemapping.remap("coke_oven_bronze", "coke_oven");
        GT5RRemapping.remap("primitive_blast_furnace_bronze", "primitive_blast_furnace");
        GT5RRemapping.remap("heat_exchanger_ev", "large_heat_exchanger");
        GTRemapping.remapMachine((String)"small_heat_exchanger", (Machine)GT5RMachines.INVAR_SMALL_HEAT_EXCHANGER);
        GTRemapping.remapMachine((String)"pyrolysis_oven", (Machine)GT5RMachines.PYROLYSE_OVEN);
        GTRemapping.remapBlockEntity((ResourceLocation)new ResourceLocation("gt5r", "heat_exchanger"), (ResourceLocation)new ResourceLocation("gt5r", "large_heat_exchanger"));
        GTRemapping.remapMachine((String)"item_input_hatch", (Machine)GT5RMachines.INPUT_BUS);
        GTRemapping.remapMachine((String)"item_output_hatch", (Machine)GT5RMachines.OUTPUT_BUS);
        GTRemapping.remapMachine((String)"fluid_input_hatch", (Machine)GT5RMachines.INPUT_HATCH);
        GTRemapping.remapMachine((String)"fluid_output_hatch", (Machine)GT5RMachines.OUTPUT_HATCH);
        GTRemapping.remapMachine((String)"coal_boiler", (Machine)GT5RMachines.SOLID_FUEL_BOILER);
        GTRemapping.remapMachine((String)"pulverizer", (Machine)GT5RMachines.MACERATOR);
        GTRemapping.remapMachine((String)"large_macerator", (Machine)GT5RMachines.LARGE_PULVERIZER);
        GTRemapping.remapMachine((String)"fluid_extractor", (Machine)GT5RMachines.FLUID_PRESS);
        GTRemapping.remapMachine((String)"hatch_item_input", (Machine)GT5RMachines.INPUT_BUS);
        GTRemapping.remapMachine((String)"hatch_item_output", (Machine)GT5RMachines.OUTPUT_BUS);
        GTRemapping.remapMachine((String)"hatch_fluid_input", (Machine)GT5RMachines.INPUT_HATCH);
        GTRemapping.remapMachine((String)"hatch_fluid_output", (Machine)GT5RMachines.OUTPUT_HATCH);
        GTRemapping.remapMachine((String)"hatch_energy", (Machine)GT5RMachines.ENERGY_HATCH);
        GTRemapping.remapMachine((String)"hatch_dynamo", (Machine)GT5RMachines.DYNAMO_HATCH);
        GTRemapping.remapMachine((String)"hatch_muffler", (Machine)GT5RMachines.MUFFLER_HATCH);
        GTRemapping.remapMachine((String)"steam_generator", (Machine)GT5RMachines.STEAM_GENERATOR);
        GTRemapping.remapMachine((String)"gas_generator", (Machine)GT5RMachines.GAS_GENERATOR);
        GTRemapping.remapMachine((String)"battery_buffer_one", (Machine)GT5RMachines.BATTERY_BUFFER_ONE);
        GTRemapping.remapMachine((String)"battery_buffer_four", (Machine)GT5RMachines.BATTERY_BUFFER_FOUR);
        GTRemapping.remapMachine((String)"battery_buffer_nine", (Machine)GT5RMachines.BATTERY_BUFFER_EIGHT);
        GT5RRemapping.remapGTCore("rubber_log", "rubber_log");
        GT5RRemapping.remapGTCore("rubber_leaves", "rubber_leaves");
        GT5RRemapping.remapGTCore("rubber_sapling", "rubber_sapling");
        GT5RRemapping.remapGTCore("circuit_basic", "basic_circuit");
        GT5RRemapping.remap("circuit_basic_electronic", "basic_circuit");
        GT5RRemapping.remap("basic_integrated_circuit", "basic_circuit");
        GT5RRemapping.remap("basic_electronic_circuit", "basic_circuit");
        GT5RRemapping.remap("good_integrated_circuit", "good_circuit");
        GT5RRemapping.remap("good_electronic_circuit", "good_circuit");
        GT5RRemapping.remap("circuit_good", "good_circuit");
        GT5RRemapping.remap("circuit_adv", "advanced_circuit");
        GT5RRemapping.remap("plant_ball", "plantball");
        GT5RRemapping.remap("circuit_nanoprocessor", "nanoprocessor");
        GT5RRemapping.remap("circuit_quantumprocessor", "quantumprocessor");
        GT5RRemapping.remap("circuit_energy_flow", "energy_flow_circuit");
        GT5RRemapping.remap("circuit_wetware", "wetware_circuit");
        GT5RRemapping.remap("vacuumtube", "vacuum_tube");
        GT5RRemapping.remap("adv_circuit_parts", "advanced_circuit_parts");
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gtcore", "glass_tube"), (ResourceLocation)new ResourceLocation("gt5r", "glass_tube"));
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gtcore", "coated_circuit_board"), (ResourceLocation)new ResourceLocation("gt5r", "coated_circuit_board"));
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gtcore", "epoxy_circuit_board"), (ResourceLocation)new ResourceLocation("gt5r", "epoxy_circuit_board"));
        GT5RRemapping.remapFromGTCore("empty_circuit_board", "empty_circuit_plate");
        GT5RRemapping.remapFromGTCore("copper_etched_wiring");
        GT5RRemapping.remapFromGTCore("basic_circuit_board", "copper_circuit_plate");
        GT5RRemapping.remapFromGTCore("gold_etched_wiring");
        GT5RRemapping.remapFromGTCore("advanced_circuit_board", "gold_circuit_plate");
        GT5RRemapping.remapFromGTCore("platinum_etched_wiring");
        GT5RRemapping.remapFromGTCore("complex_circuit_board", "platinum_circuit_plate");
        GT5RRemapping.remapFromGTCore("nand_chip", "basic_circuit_parts");
        GT5RRemapping.remapFromGTCore("advanced_circuit_parts");
        GT5RRemapping.remapFromGTCore("complex_circuit_parts");
        GT5RRemapping.remapFromGTCore("engraved_crystal_chip");
        GT5RRemapping.remapFromGTCore("engraved_lapotron_chip");
        GT5RRemapping.remapFromGTCore("processor_circuit_board");
        GT5RRemapping.remapFromGTCore("empty_processor_circuit_board");
        GT5RRemapping.remapFromGTCore("basic_circuit");
        GT5RRemapping.remapFromGTCore("good_circuit");
        GT5RRemapping.remapFromGTCore("advanced_circuit");
        GT5RRemapping.remapFromGTCore("complex_circuit");
        GT5RRemapping.remapFromGTCore("data_storage_circuit");
        GT5RRemapping.remapFromGTCore("data_control_circuit");
        GT5RRemapping.remapFromGTCore("energy_flow_circuit");
        GT5RRemapping.remapFromGTCore("data_orb");
        GT5RRemapping.remapGTCore("mold_plate", "plate_mold");
        GT5RRemapping.remapGTCore("mold_casing", "casing_mold");
        GT5RRemapping.remapGTCore("mold_gear", "gear_mold");
        GT5RRemapping.remapGTCore("mold_small_gear", "small_gear_mold");
        GT5RRemapping.remapGTCore("mold_coinage", "coinage_mold");
        GT5RRemapping.remapGTCore("mold_bottle", "bottle_mold");
        GT5RRemapping.remapGTCore("mold_ingot", "ingot_mold");
        GT5RRemapping.remapGTCore("mold_ball", "ball_mold");
        GT5RRemapping.remapGTCore("mold_block", "block_mold");
        GT5RRemapping.remapGTCore("mold_nugget", "nugget_mold");
        GT5RRemapping.remapGTCore("mold_anvil", "anvil_mold");
        GT5RRemapping.remapGTCore("shape_plate", "plate_shape");
        GT5RRemapping.remapGTCore("shape_casing", "casing_shape");
        GT5RRemapping.remapGTCore("shape_rod", "rod_shape");
        GT5RRemapping.remapGTCore("shape_bolt", "bolt_shape");
        GT5RRemapping.remapGTCore("shape_ring", "ring_shape");
        GT5RRemapping.remapGTCore("shape_cell", "cell_shape");
        GT5RRemapping.remapGTCore("shape_ingot", "ingot_shape");
        GT5RRemapping.remapGTCore("shape_wire", "wire_shape");
        GT5RRemapping.remapGTCore("shape_pipe_tiny", "tiny_pipe_shape");
        GT5RRemapping.remapGTCore("shape_pipe_small", "small_pipe_shape");
        GT5RRemapping.remapGTCore("shape_pipe_normal", "normal_pipe_shape");
        GT5RRemapping.remapGTCore("shape_pipe_large", "large_pipe_shape");
        GT5RRemapping.remapGTCore("shape_pipe_huge", "huge_pipe_shape");
        GT5RRemapping.remapGTCore("shape_head_sword", "sword_head_shape");
        GT5RRemapping.remapGTCore("shape_head_pickaxe", "pickaxe_head_shape");
        GT5RRemapping.remapGTCore("shape_head_shovel", "shovel_head_shape");
        GT5RRemapping.remapGTCore("shape_head_axe", "axe_head_shape");
        GT5RRemapping.remapGTCore("shape_head_hoe", "hoe_head_shape");
        GT5RRemapping.remapGTCore("shape_head_hammer", "hammer_head_shape");
        GT5RRemapping.remapGTCore("shape_head_file", "file_head_shape");
        GT5RRemapping.remapGTCore("shape_head_saw", "saw_head_shape");
        GT5RRemapping.remapGTCore("shape_block", "block_shape");
        GT5RRemapping.remapGTCore("shape_gear", "gear_shape");
        GT5RRemapping.remapGTCore("shape_gear_small", "small_gear_shape");
        GT5RRemapping.remapFromGTCore("raw_lapotron_crystal", "raw_lapotron_crystal");
        GT5RRemapping.remapFromGTCore("small_battery_hull", "small_battery_hull");
        GT5RRemapping.remapFromGTCore("medium_battery_hull", "medium_battery_hull");
        GT5RRemapping.remapFromGTCore("large_battery_hull", "large_battery_hull");
        GT5RRemapping.remapFromGTCore("small_mercury_battery", "small_mercury_battery");
        GT5RRemapping.remapFromGTCore("small_acid_battery", "small_acid_battery");
        GT5RRemapping.remapFromGTCore("small_cadmium_battery", "small_cadmium_battery");
        GT5RRemapping.remapFromGTCore("small_lithium_battery", "small_lithium_battery");
        GT5RRemapping.remapFromGTCore("small_sodium_battery", "small_sodium_battery");
        GT5RRemapping.remapFromGTCore("medium_mercury_battery", "medium_mercury_battery");
        GT5RRemapping.remapFromGTCore("medium_acid_battery", "medium_acid_battery");
        GT5RRemapping.remapFromGTCore("medium_cadmium_battery", "medium_cadmium_battery");
        GT5RRemapping.remapFromGTCore("medium_lithium_battery", "medium_lithium_battery");
        GT5RRemapping.remapFromGTCore("medium_sodium_battery", "medium_sodium_battery");
        GT5RRemapping.remapFromGTCore("large_mercury_battery", "large_mercury_battery");
        GT5RRemapping.remapFromGTCore("large_acid_battery", "large_acid_battery");
        GT5RRemapping.remapFromGTCore("large_cadmium_battery", "large_cadmium_battery");
        GT5RRemapping.remapFromGTCore("large_lithium_battery", "large_lithium_battery");
        GT5RRemapping.remapFromGTCore("large_sodium_battery", "large_sodium_battery");
        GT5RRemapping.remapFromGTCore("energy_crystal", "energy_crystal");
        GT5RRemapping.remapFromGTCore("lapotron_crystal", "lapotron_crystal");
        GT5RRemapping.remapFromGTCore("lapotronic_energy_orb", "lapotronic_energy_orb");
        GT5RRemapping.remapFromGTCore("lapotronic_energy_orb_cluster", "lapotronic_energy_orb_cluster");
        GT5RRemapping.remap("coil_cupronickel", "cupronickel_coil");
        GT5RRemapping.remap("coil_kanthal", "kanthal_coil");
        GT5RRemapping.remap("coil_nichrome", "nichrome_coil");
        GT5RRemapping.remap("coil_tungstensteel", "tungstensteel_coil");
        GT5RRemapping.remap("coil_hssg", "hssg_coil");
        GT5RRemapping.remap("coil_naquadah", "naquadah_coil");
        GT5RRemapping.remap("coil_naquadah_alloy", "naquadah_alloy_coil");
        GT5RRemapping.remap("coil_fusion", "fusion_coil");
        GT5RRemapping.remap("coil_superconductor", "superconductor_coil");
        GT5RRemapping.remap("casing_bronze", "bronze_casing");
        GT5RRemapping.remap("casing_bricked_bronze", "bricked_bronze_casing");
        GT5RRemapping.remap("casing_steel", "steel_casing");
        GT5RRemapping.remap("casing_bricked_steel", "bricked_steel_casing");
        GT5RRemapping.remap("casing_bronze_plated_brick", "bronze_plated_brick_casing");
        GT5RRemapping.remap("casing_solid_steel", "solid_steel_casing");
        GT5RRemapping.remap("casing_stainless_steel", "stainless_steel_casing");
        GT5RRemapping.remap("casing_titanium", "titanium_casing");
        GT5RRemapping.remap("casing_tungstensteel", "tungstensteel_casing");
        GT5RRemapping.remap("casing_heat_proof", "heat_proof_casing");
        GT5RRemapping.remap("casing_frost_proof", "frost_proof_casing");
        GT5RRemapping.remap("casing_radiation_proof", "radiation_proof_casing");
        GT5RRemapping.remap("casing_firebox_bronze", "bronze_firebox_casing");
        GT5RRemapping.remap("casing_firebox_steel", "steel_firebox_casing");
        GT5RRemapping.remap("casing_firebox_titanium", "titanium_firebox_casing");
        GT5RRemapping.remap("casing_firebox_tungstensteel", "tungstensteel_firebox_casing");
        GT5RRemapping.remap("casing_gearbox_bronze", "bronze_gearbox_casing");
        GT5RRemapping.remap("casing_gearbox_steel", "steel_gearbox_casing");
        GT5RRemapping.remap("casing_gearbox_titanium", "titanium_gearbox_casing");
        GT5RRemapping.remap("casing_gearbox_tungstensteel", "tungstensteel_gearbox_casing");
        GT5RRemapping.remap("casing_pipe_bronze", "bronze_pipe_casing");
        GT5RRemapping.remap("casing_pipe_steel", "steel_pipe_casing");
        GT5RRemapping.remap("casing_pipe_titanium", "titanium_pipe_casing");
        GT5RRemapping.remap("casing_pipe_tungstensteel", "tungstensteel_pipe_casing");
        GT5RRemapping.remap("casing_engine_intake", "engine_intake_casing");
        GT5RRemapping.remap("casing_turbine_1", "steel_turbine_casing");
        GT5RRemapping.remap("casing_turbine_2", "stainless_steel_turbine_casing");
        GT5RRemapping.remap("casing_turbine_3", "titanium_turbine_casing");
        GT5RRemapping.remap("casing_turbine_4", "tungstensteel_turbine_casing");
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gt5r", "monocrystalline_silicon_boule"), (ResourceLocation)new ResourceLocation("antimatter_shared", "boule_silicon"));
        GT5RRemapping.remap("cell_tin", "tin_cell");
        GT5RRemapping.remap("cell_steel", "steel_cell");
        GT5RRemapping.remap("cell_tungstensteel", "tungstensteel_cell");
        GTRemapping.remapCover((ResourceLocation)new ResourceLocation("gt5r", "steam_vent"), (ResourceLocation)new ResourceLocation("gtcore", "steam_vent"));
    }

    private static void remap(String oldId, String newId) {
        GTRemapping.remap((String)"gt5r", (String)oldId, (String)newId);
    }

    private static void remapGTCore(String oldId, String newId) {
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gt5r", oldId), (ResourceLocation)new ResourceLocation("gtcore", newId));
    }

    private static void remapFromGTCore(String oldId, String newId) {
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gtcore", oldId), (ResourceLocation)new ResourceLocation("gt5r", newId));
    }

    private static void remapFromGTCore(String id) {
        GTRemapping.remap((ResourceLocation)new ResourceLocation("gtcore", id), (ResourceLocation)new ResourceLocation("gt5r", id));
    }

    public static Map<String, String> getRemappingMap() {
        return REMAPPING_MAP;
    }
}

