/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.workers;

import com.ewyboy.worldstripper.json.StripListHandler;
import com.ewyboy.worldstripper.settings.Settings;
import com.ewyboy.worldstripper.stripclub.ModLogger;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.common.WorldWorkerManager;

public class StripWorker
implements WorldWorkerManager.IWorker {
    protected final BlockPos start;
    protected final int radiusX;
    protected final int radiusZ;
    private final int total;
    private final ServerLevel dim;
    private final Queue<BlockInWorld> queue;
    private final int notificationFrequency;
    private final int blockUpdateFlag;
    private final BlockState replacementBlock;
    private int lastNotification = 0;
    private long lastNotificationTime;
    private static float progress = 0.0f;

    public static float getProgress() {
        return progress;
    }

    public static void setProgress(float progress) {
        StripWorker.progress = progress;
    }

    public StripWorker(BlockPos start, int radiusX, int radiusZ, ServerLevel dim, int notificationFrequency, int blockUpdateFlag, BlockState replacementBlock) {
        this.start = start;
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.dim = dim;
        this.queue = this.stripQueue();
        this.total = this.queue.size();
        this.notificationFrequency = notificationFrequency != -1 ? notificationFrequency : Math.max((radiusX + radiusZ) / 2 / 10, 100);
        this.lastNotificationTime = System.currentTimeMillis();
        this.blockUpdateFlag = blockUpdateFlag;
        this.replacementBlock = replacementBlock;
    }

    private BlockInWorld blockInfo(BlockPos pos) {
        return new BlockInWorld((LevelReader)this.dim, pos, true);
    }

    private Queue<BlockInWorld> stripQueue() {
        LinkedList<BlockInWorld> queue = new LinkedList<BlockInWorld>();
        List<String> stripList = StripListHandler.stripList.getEntries();
        BlockPos neg = new BlockPos(this.start.m_123341_() - this.radiusX, ((Integer)Settings.SETTINGS.stripStopY.get()).intValue(), this.start.m_123343_() - this.radiusZ);
        BlockPos pos = new BlockPos(this.start.m_123341_() + this.radiusX, ((Integer)Settings.SETTINGS.stripStartY.get()).intValue(), this.start.m_123343_() + this.radiusZ);
        BlockPos.m_121990_((BlockPos)neg, (BlockPos)pos).filter(target -> this.blockInfo((BlockPos)target).m_61168_() != Blocks.f_50016_.m_49966_()).filter(target -> stripList.contains(Objects.requireNonNull(this.blockInfo((BlockPos)target).m_61168_().m_60734_().getRegistryName()).toString())).map(BlockPos::m_7949_).map(this::blockInfo).forEach(queue::add);
        ModLogger.info("Queue Size :: " + queue.size(), new Object[0]);
        return queue;
    }

    public boolean hasWork() {
        return !this.queue.isEmpty();
    }

    public boolean doWork() {
        BlockInWorld next;
        while ((next = this.queue.poll()) == null && !this.queue.isEmpty()) {
        }
        if (next != null) {
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotificationTime < System.currentTimeMillis() - 60000L) {
                StripWorker.setProgress((float)(this.total - this.queue.size()) / (float)this.total * 100.0f);
                this.lastNotification = 0;
                this.lastNotificationTime = System.currentTimeMillis();
            }
            this.dim.m_7731_(next.m_61176_(), this.replacementBlock, this.blockUpdateFlag);
        }
        if (this.queue.size() == 0) {
            StripWorker.setProgress(100.0f);
            return false;
        }
        return true;
    }
}

