/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.workers;

import com.ewyboy.worldstripper.settings.Settings;
import com.ewyboy.worldstripper.stripclub.StripperCache;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.WorldWorkerManager;

public class DressWorker
implements WorldWorkerManager.IWorker {
    protected final BlockPos start;
    protected final int radiusX;
    protected final int radiusZ;
    private final ServerLevel dim;
    private final Deque<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotificationTime;
    private final int blockUpdateFlag;

    public DressWorker(BlockPos start, int radiusX, int radiusZ, ServerLevel dim, int interval, int blockUpdateFlag) {
        this.start = start;
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.dim = dim;
        this.queue = this.dressQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max((radiusX + radiusZ) / 2 / 10, 100);
        this.lastNotificationTime = System.currentTimeMillis();
        this.blockUpdateFlag = blockUpdateFlag;
    }

    private Deque<BlockPos> dressQueue() {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockPos neg = new BlockPos(this.start.m_123341_() - this.radiusX, ((Integer)Settings.SETTINGS.stripStopY.get()).intValue(), this.start.m_123343_() - this.radiusZ);
        BlockPos pos = new BlockPos(this.start.m_123341_() + this.radiusX, ((Integer)Settings.SETTINGS.stripStartY.get()).intValue(), this.start.m_123343_() + this.radiusZ);
        BlockPos.m_121990_((BlockPos)neg, (BlockPos)pos).map(BlockPos::m_7949_).filter(StripperCache.hashedBlockCache::containsKey).forEach(queue::add);
        return queue;
    }

    private boolean isBlockCached(BlockPos next) {
        return StripperCache.hashedBlockCache.containsKey(next);
    }

    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    public boolean doWork() {
        BlockPos next;
        while (!((next = this.queue.pollLast()) != null && this.isBlockCached(next) || this.queue.isEmpty())) {
        }
        if (next != null) {
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotificationTime < System.currentTimeMillis() - 60000L) {
                this.lastNotification = 0;
                this.lastNotificationTime = System.currentTimeMillis();
            }
            this.dim.m_7731_(next, StripperCache.hashedBlockCache.remove(next), this.blockUpdateFlag);
        }
        return this.queue.size() != 0;
    }
}

