/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.network.messages;

import com.ewyboy.worldstripper.settings.Settings;
import com.ewyboy.worldstripper.stripclub.BlockUpdater;
import com.ewyboy.worldstripper.workers.StripWorker;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageStripWorker {
    public int x;
    public int z;

    public MessageStripWorker() {
        this.x = -1;
        this.z = -1;
    }

    public MessageStripWorker(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
    }

    public static MessageStripWorker decode(FriendlyByteBuf buf) {
        return new MessageStripWorker(buf.readInt(), buf.readInt());
    }

    public static void handle(MessageStripWorker message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            int chunkClearSizeX = (Integer)Settings.SETTINGS.stripRadiusX.get() / 2;
            int chunkClearSizeZ = (Integer)Settings.SETTINGS.stripRadiusZ.get() / 2;
            BlockState replacementBlock = Objects.requireNonNull(Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Settings.SETTINGS.replacementBlock.get()))).m_49966_());
            if (player != null) {
                if (player.m_5833_() || player.m_7500_()) {
                    player.m_9146_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.RED + "WARNING! " + ChatFormatting.WHITE + "World Stripping Initialized! Lag May Occur.."), ChatType.GAME_INFO, player.m_142081_());
                    WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)new StripWorker(new BlockPos(player.m_20182_()), chunkClearSizeX, chunkClearSizeZ, player.m_183503_(), 4096, BlockUpdater.getBlockUpdateFlag(), replacementBlock));
                } else {
                    player.m_9146_((Component)new TextComponent(ChatFormatting.RED + "Error: You have to be in creative mode to use this feature!"), ChatType.GAME_INFO, player.m_142081_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

