/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.network.messages;

import com.ewyboy.worldstripper.settings.Settings;
import com.ewyboy.worldstripper.stripclub.BlockUpdater;
import com.ewyboy.worldstripper.workers.DressWorker;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.network.NetworkEvent;

public class MessageDressWorker {
    public int x;
    public int z;

    public MessageDressWorker() {
        this.x = -1;
        this.z = -1;
    }

    public MessageDressWorker(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
    }

    public static MessageDressWorker decode(FriendlyByteBuf buf) {
        return new MessageDressWorker(buf.readInt(), buf.readInt());
    }

    public static void handle(MessageDressWorker message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            int fillSizeX = (Integer)Settings.SETTINGS.stripRadiusX.get() / 2;
            int fillSizeZ = (Integer)Settings.SETTINGS.stripRadiusZ.get() / 2;
            if (player != null) {
                if (player.m_5833_() || player.m_7500_()) {
                    player.m_9146_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.RED + "WARNING! " + ChatFormatting.WHITE + "World Dressing Initialized! Lag May Occur.."), ChatType.GAME_INFO, player.m_142081_());
                    WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)new DressWorker(new BlockPos(player.m_20182_()), fillSizeX, fillSizeZ, player.m_183503_(), 4096, BlockUpdater.getBlockUpdateFlag()));
                } else {
                    player.m_9146_((Component)new TextComponent(ChatFormatting.RED + "Error: You have to be in creative mode to use this feature!"), ChatType.GAME_INFO, player.m_142081_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

