/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.json;

import com.ewyboy.worldstripper.json.objects.StripListObject;
import com.ewyboy.worldstripper.settings.Settings;
import com.ewyboy.worldstripper.stripclub.ModLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class StripListHandler {
    private static final Gson gson = new Gson();
    public static final File JSON_FILE = new File(FMLPaths.CONFIGDIR.get() + "/worldstripper/stripper.json");
    private static final List<String> STRIP_ENTRIES = new ArrayList<String>();
    public static StripListObject stripList;

    public static void setup() {
        StripListHandler.createDirectory();
        if (!JSON_FILE.exists()) {
            ModLogger.info("Creating World Stripper JSON file", new Object[0]);
            StripListHandler.writeJson(JSON_FILE);
        }
        ModLogger.info("Reading World Stripper JSON file", new Object[0]);
        StripListHandler.readJson(JSON_FILE);
        Settings.setup();
    }

    public static void reload() {
        StripListHandler.writeJson(JSON_FILE);
        StripListHandler.readJson(JSON_FILE);
    }

    public static boolean containsEntry(String entry) {
        for (String block : stripList.getEntries()) {
            if (!block.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public static boolean addEntry(String entry) {
        if (!StripListHandler.containsEntry(entry)) {
            stripList.getEntries().add(entry);
            StripListHandler.reload();
            return true;
        }
        return false;
    }

    public static boolean removeEntry(String entry) {
        if (StripListHandler.containsEntry(entry)) {
            stripList.getEntries().removeIf(target -> target.equals(entry));
            StripListHandler.reload();
            return true;
        }
        return false;
    }

    public static void writeJson(File jsonFile) {
        try (FileWriter writer = new FileWriter(jsonFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)stripList, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readJson(File jsonFile) {
        try (FileReader reader = new FileReader(jsonFile);){
            stripList = (StripListObject)gson.fromJson((Reader)reader, StripListObject.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDirectory() {
        Path path = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "worldstripper");
        try {
            ModLogger.info("Creating World Stripper directory", new Object[0]);
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ModLogger.error("Failed to create world-stripper directory", e);
        }
    }

    static {
        STRIP_ENTRIES.add("minecraft:dirt");
        STRIP_ENTRIES.add("minecraft:grass");
        STRIP_ENTRIES.add("minecraft:grass_path");
        STRIP_ENTRIES.add("minecraft:tall_grass");
        STRIP_ENTRIES.add("minecraft:grass_block");
        STRIP_ENTRIES.add("minecraft:stone");
        STRIP_ENTRIES.add("minecraft:diorite");
        STRIP_ENTRIES.add("minecraft:granite");
        STRIP_ENTRIES.add("minecraft:andesite");
        STRIP_ENTRIES.add("minecraft:gravel");
        STRIP_ENTRIES.add("minecraft:sand");
        STRIP_ENTRIES.add("minecraft:sandstone");
        STRIP_ENTRIES.add("minecraft:oak_log");
        STRIP_ENTRIES.add("minecraft:dark_oak_log");
        STRIP_ENTRIES.add("minecraft:spruce_log");
        STRIP_ENTRIES.add("minecraft:birch_log");
        STRIP_ENTRIES.add("minecraft:jungle_log");
        STRIP_ENTRIES.add("minecraft:acacia_log");
        STRIP_ENTRIES.add("minecraft:oak_leaves");
        STRIP_ENTRIES.add("minecraft:dark_oak_leaves");
        STRIP_ENTRIES.add("minecraft:spruce_leaves");
        STRIP_ENTRIES.add("minecraft:birch_leaves");
        STRIP_ENTRIES.add("minecraft:jungle_leaves");
        STRIP_ENTRIES.add("minecraft:acacia_leaves");
        STRIP_ENTRIES.add("minecraft:water");
        STRIP_ENTRIES.add("minecraft:flowing_water");
        STRIP_ENTRIES.add("minecraft:lava");
        STRIP_ENTRIES.add("minecraft:flowing_lava");
        STRIP_ENTRIES.add("minecraft:netherrack");
        STRIP_ENTRIES.add("minecraft:end_stone");
        STRIP_ENTRIES.add("minecraft:podzol");
        STRIP_ENTRIES.add("minecraft:bamboo");
        STRIP_ENTRIES.add("minecraft:seagrass");
        STRIP_ENTRIES.add("minecraft:tall_seagrass");
        STRIP_ENTRIES.add("minecraft:kelp");
        STRIP_ENTRIES.add("minecraft:kelp_plant");
        STRIP_ENTRIES.add("minecraft:deepslate");
        STRIP_ENTRIES.add("minecraft:tuff");
        STRIP_ENTRIES.add("minecraft:glow_lichen");
        stripList = new StripListObject(STRIP_ENTRIES);
    }
}

