/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.EnumSet;
import journeymap.client.api.display.Context;
import journeymap.client.model.MapType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public enum Feature {
    RadarPlayers,
    RadarAnimals,
    RadarMobs,
    RadarVillagers,
    MapTopo,
    MapSurface,
    MapCaves,
    MapBiome;


    public static EnumSet<Feature> radar() {
        return EnumSet.of(RadarPlayers, RadarAnimals, RadarMobs, RadarVillagers);
    }

    public static EnumSet<Feature> all() {
        return EnumSet.allOf(Feature.class);
    }

    public static Feature fromMapType(MapType mapType) {
        MapType.Name name = mapType.name;
        return switch (name) {
            case MapType.Name.topo -> MapTopo;
            case MapType.Name.underground -> MapCaves;
            case MapType.Name.biome -> MapBiome;
            default -> MapSurface;
        };
    }

    public static Feature fromApiMapType(Context.MapType mapType, ResourceKey<Level> dimension) {
        return Feature.fromMapType(MapType.fromApiContextMapType(mapType, 0, dimension == null ? Minecraft.m_91087_().f_91074_.m_183503_().m_46472_() : dimension));
    }
}

