/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.task.goat_jump;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LongJumpToRandomPos.class})
public abstract class LongJumpToRandomPosMixin {
    @Shadow
    @Final
    private static int f_147623_;
    private final LongArrayList potentialTargets = new LongArrayList();
    private final ShortArrayList potentialWeights = new ShortArrayList();
    @Shadow
    private Optional<LongJumpToRandomPos.PossibleJump> f_147632_;
    @Shadow
    private int f_147633_;
    @Shadow
    @Final
    private List<LongJumpToRandomPos.PossibleJump> f_147630_;
    @Shadow
    private Optional<Vec3> f_147631_;
    @Shadow
    @Final
    private int f_147628_;
    @Shadow
    @Final
    private int f_147627_;

    private static int findIndex(ShortArrayList weights, int weightedIndex) {
        for (int i = 0; i < weights.size(); ++i) {
            if ((weightedIndex -= weights.getShort(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Shadow
    protected abstract Optional<Vec3> m_147656_(Mob var1, Vec3 var2);

    @Overwrite
    public void m_6735_(ServerLevel serverWorld, Mob mobEntity, long l) {
        this.potentialTargets.clear();
        this.potentialWeights.clear();
        int potentialTotalWeight = 0;
        this.f_147632_ = Optional.empty();
        this.f_147633_ = f_147623_;
        this.f_147630_.clear();
        this.f_147631_ = Optional.of(mobEntity.m_20182_());
        BlockPos goatPos = mobEntity.m_142538_();
        int goatX = goatPos.m_123341_();
        int goatY = goatPos.m_123342_();
        int goatZ = goatPos.m_123343_();
        Iterable iterable = BlockPos.m_121976_((int)(goatX - this.f_147628_), (int)(goatY - this.f_147627_), (int)(goatZ - this.f_147628_), (int)(goatX + this.f_147628_), (int)(goatY + this.f_147627_), (int)(goatZ + this.f_147628_));
        PathNavigation entityNavigation = mobEntity.m_21573_();
        BlockPos.MutableBlockPos targetPosCopy = new BlockPos.MutableBlockPos();
        for (BlockPos targetPos : iterable) {
            if (goatX == targetPos.m_123341_() && goatZ == targetPos.m_123343_()) continue;
            double squaredDistance = targetPos.m_123331_((Vec3i)goatPos);
            if (!entityNavigation.m_6342_(targetPos) || mobEntity.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)mobEntity.f_19853_, (BlockPos.MutableBlockPos)targetPosCopy.m_122190_((Vec3i)targetPos))) != 0.0f) continue;
            this.potentialTargets.add(targetPos.m_121878_());
            int weight = Mth.m_14165_((double)squaredDistance);
            this.potentialWeights.add((short)weight);
            potentialTotalWeight += weight;
        }
        while (this.f_147630_.size() < f_147623_) {
            if (potentialTotalWeight == 0) {
                return;
            }
            int chosenIndex = LongJumpToRandomPosMixin.findIndex(this.potentialWeights, serverWorld.f_46441_.nextInt(potentialTotalWeight));
            long chosenPos = this.potentialTargets.getLong(chosenIndex);
            short chosenWeight = this.potentialWeights.set(chosenIndex, (short)0);
            potentialTotalWeight -= chosenWeight;
            Optional<Vec3> optional = this.m_147656_(mobEntity, Vec3.m_82512_((Vec3i)targetPosCopy.m_122188_(chosenPos)));
            if (!optional.isPresent()) continue;
            this.f_147630_.add(new LongJumpToRandomPos.PossibleJump(new BlockPos((Vec3i)targetPosCopy), optional.get(), (int)chosenWeight));
        }
    }

    @Redirect(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Mob;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/random/WeightedRandom;getRandomItem(Ljava/util/Random;Ljava/util/List;)Ljava/util/Optional;"))
    private Optional<LongJumpToRandomPos.PossibleJump> getNextRandomTarget(Random random, List<LongJumpToRandomPos.PossibleJump> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }
}

