/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.pathing;

import com.abdelaziz.canary.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PathNavigationRegion.class})
public abstract class PathNavigationRegionMixin
implements BlockGetter {
    private static final BlockState DEFAULT_BLOCK = Blocks.f_50016_.m_49966_();
    @Shadow
    @Final
    protected ChunkAccess[][] f_47160_;
    @Shadow
    @Final
    protected int f_47158_;
    @Shadow
    @Final
    protected int f_47159_;
    @Shadow
    @Final
    protected Level f_47162_;
    private ChunkAccess[] chunksFlat;
    private int xLen;
    private int zLen;
    private int bottomY;
    private int topY;

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    private void init(Level world, BlockPos minPos, BlockPos maxPos, CallbackInfo ci) {
        this.xLen = 1 + Pos.ChunkCoord.fromBlockCoord(maxPos.m_123341_()) - Pos.ChunkCoord.fromBlockCoord(minPos.m_123341_());
        this.zLen = 1 + Pos.ChunkCoord.fromBlockCoord(maxPos.m_123343_()) - Pos.ChunkCoord.fromBlockCoord(minPos.m_123343_());
        this.chunksFlat = new ChunkAccess[this.xLen * this.zLen];
        for (int x = 0; x < this.xLen; ++x) {
            System.arraycopy(this.f_47160_[x], 0, this.chunksFlat, x * this.zLen, this.zLen);
        }
        this.bottomY = this.m_141937_();
        this.topY = this.m_151558_();
    }

    @Overwrite
    public BlockState m_8055_(BlockPos pos) {
        int y = pos.m_123342_();
        if (y >= this.bottomY && y < this.topY) {
            LevelChunkSection section;
            ChunkAccess chunk;
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            int chunkX = Pos.ChunkCoord.fromBlockCoord(x) - this.f_47158_;
            int chunkZ = Pos.ChunkCoord.fromBlockCoord(z) - this.f_47159_;
            if (chunkX >= 0 && chunkX < this.xLen && chunkZ >= 0 && chunkZ < this.zLen && (chunk = this.chunksFlat[chunkX * this.zLen + chunkZ]) != null && (section = chunk.m_7103_()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this, y)]) != null) {
                return section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
            }
        }
        return DEFAULT_BLOCK;
    }

    @Overwrite
    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }
}

