/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin;

import com.abdelaziz.canary.common.Canary;
import com.abdelaziz.canary.common.config.CanaryConfig;
import com.abdelaziz.canary.common.config.Option;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CanaryMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "com.abdelaziz.canary.mixin.";
    private final Logger logger = LogManager.getLogger((String)"Canary");
    private CanaryConfig config;

    public void onLoad(String mixinPackage) {
        try {
            this.config = CanaryConfig.load(new File("./config/canary.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Canary", e);
        }
        this.logger.info("Loaded configuration file for Canary: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
        Canary.CONFIG = this.config;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.alloc.blockstate") && FMLLoader.getLoadingModList().getModFileById("ferritecore") != null) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.entity.fast_retrieval") && FMLLoader.getLoadingModList().getModFileById("mowziesmobs") != null) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.block.hopper") && FMLLoader.getLoadingModList().getModFileById("quark") != null) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.ai.nearby_entity_tracking") && FMLLoader.getLoadingModList().getModFileById("witherstormmod") != null) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.shapes") && !LoadingModList.get().getErrors().isEmpty()) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.math.sine_lut") && !LoadingModList.get().getErrors().isEmpty()) {
            return false;
        }
        if (mixinClassName.startsWith("com.abdelaziz.canary.mixin.alloc.blockstate") && !LoadingModList.get().getErrors().isEmpty()) {
            return false;
        }
        if (!mixinClassName.startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        Option option = this.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            return false;
        }
        if (option.isOverridden()) {
            Object source = "[unknown]";
            if (option.isUserDefined()) {
                source = "user configuration";
            } else if (option.isModDefined()) {
                source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
            }
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getName(), source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getName(), source);
            }
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

