/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.ai.pathing;

import com.abdelaziz.canary.common.ai.pathing.BlockStatePathingCache;
import com.abdelaziz.canary.common.block.BlockCountingSection;
import com.abdelaziz.canary.common.block.BlockStateFlags;
import com.abdelaziz.canary.common.util.Pos;
import com.abdelaziz.canary.common.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class PathNodeCache {
    private static boolean isChunkSectionDangerousNeighbor(LevelChunkSection section) {
        return section.m_63019_().m_63109_(state -> PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)state) != BlockPathTypes.OPEN);
    }

    public static BlockPathTypes getPathNodeType(BlockState state) {
        return ((BlockStatePathingCache)state).getPathNodeType();
    }

    public static BlockPathTypes getNeighborPathNodeType(BlockBehaviour.BlockStateBase state) {
        return ((BlockStatePathingCache)state).getNeighborPathNodeType();
    }

    public static boolean isSectionSafeAsNeighbor(LevelChunkSection section) {
        if (section.m_188008_()) {
            return true;
        }
        if (BlockStateFlags.ENABLED) {
            return !((BlockCountingSection)section).anyMatch(BlockStateFlags.PATH_NOT_OPEN, true);
        }
        return !PathNodeCache.isChunkSectionDangerousNeighbor(section);
    }

    public static BlockPathTypes getNodeTypeFromNeighbors(BlockGetter world, BlockPos.MutableBlockPos pos, BlockPathTypes type) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        LevelChunkSection section = null;
        if (world instanceof CollisionGetter && WorldHelper.areNeighborsWithinSameChunk((BlockPos)pos)) {
            ChunkAccess chunk;
            if (!world.m_151562_(y) && (chunk = (ChunkAccess)((CollisionGetter)world).m_7925_(Pos.ChunkCoord.fromBlockCoord(x), Pos.ChunkCoord.fromBlockCoord(z))) != null) {
                section = chunk.m_7103_()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)world, y)];
            }
            if (section == null || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                return type;
            }
        }
        int xStart = x - 1;
        int yStart = y - 1;
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (int adjX = xStart; adjX <= xEnd; ++adjX) {
            for (int adjY = yStart; adjY <= yEnd; ++adjY) {
                for (int adjZ = zStart; adjZ <= zEnd; ++adjZ) {
                    BlockState state;
                    if (adjX == x && adjZ == z || (state = section != null ? section.m_62982_(adjX & 0xF, adjY & 0xF, adjZ & 0xF) : world.m_8055_((BlockPos)pos.m_122178_(adjX, adjY, adjZ))).m_60795_()) continue;
                    BlockPathTypes neighborType = PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)state);
                    if (neighborType == null && (neighborType = WalkNodeEvaluator.m_77607_((BlockGetter)world, (BlockPos.MutableBlockPos)pos, null)) == null) {
                        neighborType = BlockPathTypes.OPEN;
                    }
                    if (neighborType == BlockPathTypes.OPEN) continue;
                    return neighborType;
                }
            }
        }
        return type;
    }
}

