/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtspartan.tool;

import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtspartan.items.MaterialSwordSpartan;
import org.gtreimagined.gtspartan.items.MaterialThrowingWeapon;

public class GTSPToolType
extends GTToolType {
    private final WeaponArchetype archetype;

    public GTSPToolType(String domain, String id, float baseAttackDamage, float weaponDamageMultiplier, float baseAttackSpeed, WeaponArchetype archetype) {
        super(domain, id, 2, 1, 10, baseAttackDamage, baseAttackSpeed, false);
        this.archetype = archetype;
        if (!id.equals("boomerang")) {
            this.setOverlayLayers(2);
        }
        this.setToolSupplier((domain2, toolType, tier, properties) -> {
            if (tier.getPrimary() == GTLibMaterials.NetherizedDiamond) {
                properties.m_41486_();
            }
            if (archetype == WeaponArchetype.THROWING_KNIFE || archetype == WeaponArchetype.TOMAHAWK || archetype == WeaponArchetype.JAVELIN || archetype == WeaponArchetype.BOOMERANG) {
                int maxAmmo;
                int n = archetype == WeaponArchetype.THROWING_KNIFE ? 16 : (archetype == WeaponArchetype.TOMAHAWK ? 8 : (maxAmmo = archetype == WeaponArchetype.JAVELIN ? 4 : 1));
                int chargeTicks = archetype == WeaponArchetype.TOMAHAWK ? 8 : (archetype == WeaponArchetype.JAVELIN ? 10 : 5);
                return new MaterialThrowingWeapon(domain2, toolType, tier, properties, archetype, weaponDamageMultiplier, maxAmmo, chargeTicks);
            }
            return new MaterialSwordSpartan(domain2, toolType, tier, properties, archetype, weaponDamageMultiplier);
        });
        String tagString = id.equals("quarterstaff") ? "quarterstaves" : (id.endsWith("knife") ? id.replace("knife", "knives") : (id.endsWith("s") ? id : id + "s"));
        this.tag = TagUtils.getItemTag((ResourceLocation)new ResourceLocation("spartanweaponry", tagString));
        this.addEffectiveBlocks(new Block[]{Blocks.f_50033_}).setType(GTTools.SWORD);
        if (id.equals("battleaxe")) {
            this.addTags(new String[]{"axe"});
        }
    }
}

