/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtspartan.loader.crafting;

import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtspartan.GTSPConfig;
import org.gtreimagined.gtspartan.data.MaterialTypes;
import org.gtreimagined.gtspartan.data.Tools;

public class ToolCrafting {
    public static void removeSpartanWeaponryRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        if (GTSPConfig.REMOVE_MODDED_WEAPONS.get()) {
            ArrayList<String> materials = new ArrayList<String>();
            for (String material : GTSPConfig.HIDDEN_MODDED_TOOL_MATERIALS.get()) {
                if (!GTSPConfig.DEFAULT_MODDED_TOOL_MATERIALS.contains(material)) continue;
                materials.add(material);
            }
            if (GTSPConfig.REMOVE_WOODEN_WEAPONS.get()) {
                materials.add("wooden");
            }
            List<String> tools = List.of("dagger", "parrying_dagger", "longsword", "katana", "saber", "rapier", "greatsword", "battle_hammer", "warhammer", "spear", "halberd", "pike", "lance", "longbow", "heavy_crossbow", "throwing_knife", "tomahawk", "javelin", "boomerang", "battleaxe", "flanged_mace", "glaive", "quarterstaff", "scythe");
            for (String material : materials) {
                for (String tool : tools) {
                    if (material.equals("wooden") && (tool.equals("longbow") || tool.equals("heavy_crossbow"))) continue;
                    provider.removeRecipe(new ResourceLocation("spartanweaponry", material + "_" + tool));
                }
            }
        }
    }

    public static void loadStandardToolRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        MaterialTags.TOOLS.getAll().forEach((m, t) -> {
            boolean replaceVanilla;
            TagKey handleAny = t.handleMaterial() != GTLibMaterials.Wood && t.handleMaterial().has(new IMaterialTag[]{MaterialTypes.HANDLE}) ? MaterialTypes.HANDLE.getMaterialTag(t.handleMaterial()) : TagUtils.getItemTag((ResourceLocation)new ResourceLocation("spartanweaponry", "handles"));
            TagKey poleAny = t.handleMaterial() != GTLibMaterials.Wood && t.handleMaterial().has(new IMaterialTag[]{MaterialTypes.POLE}) ? MaterialTypes.POLE.getMaterialTag(t.handleMaterial()) : TagUtils.getItemTag((ResourceLocation)new ResourceLocation("spartanweaponry", "poles"));
            Object handle = t.handleMaterial() != GTLibMaterials.Wood && t.handleMaterial().has(new IMaterialTag[]{MaterialTypes.HANDLE}) ? MaterialTypes.HANDLE.getMaterialTag(t.handleMaterial()) : ModItems.HANDLE.get();
            Object pole = t.handleMaterial() != GTLibMaterials.Wood && t.handleMaterial().has(new IMaterialTag[]{MaterialTypes.POLE}) ? MaterialTypes.POLE.getMaterialTag(t.handleMaterial()) : ModItems.POLE.get();
            TagKey rod = t.handleMaterial().has(new IMaterialTag[]{GTMaterialTypes.ROD}) ? GTMaterialTypes.ROD.getMaterialTag(t.handleMaterial()) : GTMaterialTypes.ROD.getMaterialTag(GTLibMaterials.Wood);
            boolean bl = replaceVanilla = m != GTLibMaterials.Iron && m != GTLibMaterials.Gold && m != GTLibMaterials.Diamond || GTSPConfig.OVERRIDE_VANILLA_SPARTAN_RECIPES.get();
            if ((m.has(new IMaterialTag[]{GTMaterialTypes.INGOT}) || m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) && replaceVanilla) {
                TagKey plateGem;
                TagKey tagKey = m.has(new IMaterialTag[]{GTMaterialTypes.GEM}) ? GTMaterialTypes.GEM.getMaterialTag(m) : (plateGem = m.has(new IMaterialTag[]{GTMaterialTypes.PLATE}) ? GTMaterialTypes.PLATE.getMaterialTag(m) : GTMaterialTypes.INGOT.getMaterialTag(m));
                if (t.toolTypes().contains(Tools.DAGGER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.DAGGER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handleAny, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", " R"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.DAGGER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handleAny, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FP", "HR"});
                    }
                }
                if (t.toolTypes().contains(Tools.PARRYING_DAGGER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.PARRYING_DAGGER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", "PR"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.PARRYING_DAGGER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", "PR "});
                    }
                }
                if (t.toolTypes().contains(Tools.LONGSWORD)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.LONGSWORD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP ", " P ", "PRP"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.LONGSWORD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", " P ", "PRP"});
                    }
                }
                if (t.toolTypes().contains(Tools.KATANA)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.KATANA.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{" FP", " P ", "R  "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.KATANA.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" FP", " PH", "R  "});
                    }
                }
                if (t.toolTypes().contains(Tools.SABER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.SABER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP ", " P ", "PR "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.SABER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", " P ", "PR "});
                    }
                }
                if (t.toolTypes().contains(Tools.RAPIER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.RAPIER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{" FP", " P ", "R  "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.RAPIER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" FP", "PPH", "RP "});
                    }
                }
                if (t.toolTypes().contains(Tools.GREATSWORD)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.GREATSWORD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP ", "PPP", "PRP"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.GREATSWORD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", "PPP", "PRP"});
                    }
                }
                if (t.toolTypes().contains(Tools.BATTLE_HAMMER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BATTLE_HAMMER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"PPP", "PPP", "FR "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BATTLE_HAMMER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PPP", "PPP", "FRH"});
                    }
                }
                if (t.toolTypes().contains(Tools.WARHAMMER)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.WARHAMMER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", "PP", " R"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.WARHAMMER.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", "PP ", " R "});
                    }
                }
                if (t.toolTypes().contains(Tools.SPEAR)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.SPEAR.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)poleAny, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", " R"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.SPEAR.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)poleAny, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FP", "HR"});
                    }
                }
                if (t.toolTypes().contains(Tools.HALBERD)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.HALBERD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", "PP", "PR"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.HALBERD.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", "PP ", "PR "});
                    }
                }
                if (t.toolTypes().contains(Tools.PIKE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.PIKE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", " R", " R"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.PIKE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", " R ", " R "});
                    }
                }
                if (t.toolTypes().contains(Tools.LANCE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.LANCE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('p'), (Object)pole, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{" FP", "Pp ", "RP "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.LANCE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('p'), (Object)pole, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" FP", "PpH", "RP "});
                    }
                }
                if (t.toolTypes().contains(Tools.THROWING_KNIFE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.THROWING_KNIFE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"RP", " F"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.THROWING_KNIFE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"RP", "HF"});
                    }
                }
                if (t.toolTypes().contains(Tools.TOMAHAWK)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.TOMAHAWK.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"RP", "FP"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.TOMAHAWK.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)handle, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"RPH", "FP "});
                    }
                }
                if (t.toolTypes().contains(Tools.JAVELIN)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.JAVELIN.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"RP", " F"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.JAVELIN.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"RP", "HF"});
                    }
                }
                if (t.toolTypes().contains(Tools.BOOMERANG)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BOOMERANG.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('W'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"PWW", "WF ", "W  "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BOOMERANG.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('W'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PWW", "WF ", "WH "});
                    }
                }
                if (t.toolTypes().contains(Tools.BATTLEAXE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BATTLEAXE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('h'), (Object)handle, (Object)Character.valueOf('R'), (Object)rod, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"PPP", "PRP", "Fh "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.BATTLEAXE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('h'), (Object)handle, (Object)Character.valueOf('R'), (Object)rod, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PPP", "PRP", "FhH"});
                    }
                }
                if (t.toolTypes().contains(Tools.FLANGED_MACE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.FLANGED_MACE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('h'), (Object)handle, (Object)Character.valueOf('R'), (Object)rod, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FPP", " RP", "h  "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.FLANGED_MACE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('h'), (Object)handle, (Object)Character.valueOf('R'), (Object)rod, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPP", " RP", "h H"});
                    }
                }
                if (t.toolTypes().contains(Tools.GLAIVE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.GLAIVE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FP", " P", " R"});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.GLAIVE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FPH", " P ", " R "});
                    }
                }
                if (t.toolTypes().contains(Tools.QUARTERSTAFF)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.QUARTERSTAFF.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{" FP", " R ", "P  "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", Tools.QUARTERSTAFF.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" FP", " R ", "PH "});
                    }
                }
                if (t.toolTypes().contains(GTTools.SCYTHE)) {
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", GTTools.SCYTHE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"PPF", "  P", " R "});
                    } else {
                        provider.addStackRecipe(consumer, "gtspartan", "", "", GTTools.SCYTHE.getToolStack(m), ImmutableMap.of((Object)Character.valueOf('R'), (Object)pole, (Object)Character.valueOf('P'), (Object)plateGem, (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PPF", " HP", " R "});
                    }
                }
            }
        });
    }
}

