/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtspartan.items;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.entity.projectile.BoomerangEntity;
import com.oblivioussp.spartanweaponry.entity.projectile.JavelinEntity;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingKnifeEntity;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.entity.projectile.TomahawkEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtspartan.items.MaterialSwordSpartan;
import org.gtreimagined.gtspartan.items.WeaponMaterialWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandlerItem;

public class MaterialThrowingWeapon
extends ThrowingWeaponItem
implements IGTTool {
    private final String domain;
    @NotNull
    private final GTToolType type;
    private final GTItemTier tier;
    private final boolean replacement;

    public MaterialThrowingWeapon(String domain, GTToolType type, GTItemTier tier, Item.Properties properties, WeaponArchetype archetypeIn, float weaponDamageMultiplier, int maxAmmoCapacity, int chargeTicks) {
        this(domain, type, tier, properties, archetypeIn, type.getBaseAttackDamage(), weaponDamageMultiplier, type.getBaseAttackSpeed() + 4.0f, maxAmmoCapacity, chargeTicks, false, "item.spartanweaponry.custom_" + type.getId());
    }

    public MaterialThrowingWeapon(String domain, GTToolType type, GTItemTier tier, Item.Properties properties, WeaponArchetype archetypeIn, float baseAttackDamage, float weaponDamageMultiplier, float baseAttackSpeed, int maxAmmoCapacity, int chargeTicks, boolean replacement, String customDisplayName) {
        super(properties, (WeaponMaterial)new WeaponMaterialWrapper(String.join((CharSequence)"_", tier.getPrimary().getId(), type.getId()), domain, tier, MaterialSwordSpartan.repairTag(tier.getPrimary()), MaterialSwordSpartan.materialTag(tier.getPrimary())), archetypeIn, baseAttackDamage, weaponDamageMultiplier, baseAttackSpeed, maxAmmoCapacity, chargeTicks, customDisplayName);
        this.domain = domain;
        this.type = type;
        this.tier = tier;
        this.replacement = replacement;
        if (!replacement) {
            GTAPI.register(IGTTool.class, (IGTObject)this);
        }
        if (archetypeIn == WeaponArchetype.JAVELIN) {
            this.throwVelocity = 2.4f;
        }
        if (archetypeIn == WeaponArchetype.TOMAHAWK) {
            this.throwVelocity = 1.75f;
        }
    }

    public ThrowingWeaponEntity createThrowingWeaponEntity(Level level, Player player, ItemStack stack, int charge) {
        if (this.archetype == WeaponArchetype.THROWING_KNIFE) {
            return new ThrowingKnifeEntity(level, (LivingEntity)player);
        }
        if (this.archetype == WeaponArchetype.TOMAHAWK) {
            return new TomahawkEntity(level, (LivingEntity)player);
        }
        if (this.archetype == WeaponArchetype.JAVELIN) {
            return new JavelinEntity(level, (LivingEntity)player);
        }
        if (this.archetype == WeaponArchetype.BOOMERANG) {
            BoomerangEntity boomerang = new BoomerangEntity(level, (LivingEntity)player);
            boomerang.setDistanceToReturn((double)charge / 5.0 * 2.0 + 3.0 + (double)((float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PROPEL.get()), (ItemStack)stack) * 3.0f));
            return boomerang;
        }
        return super.createThrowingWeaponEntity(level, player, stack, charge);
    }

    protected SoundEvent getThrowingSound() {
        if (this.archetype == WeaponArchetype.THROWING_KNIFE) {
            return (SoundEvent)ModSounds.THROWING_KNIFE_THROW.get();
        }
        if (this.archetype == WeaponArchetype.TOMAHAWK) {
            return (SoundEvent)ModSounds.TOMAHAWK_THROW.get();
        }
        if (this.archetype == WeaponArchetype.JAVELIN) {
            return (SoundEvent)ModSounds.JAVELIN_THROW.get();
        }
        if (this.archetype == WeaponArchetype.BOOMERANG) {
            return (SoundEvent)ModSounds.BOOMERANG_THROW.get();
        }
        return super.getThrowingSound();
    }

    public String getDomain() {
        return this.domain;
    }

    public GTItemTier getGTItemTier() {
        return this.tier;
    }

    public ItemStack asItemStack(Material primary, Material secondary) {
        return this.resolveStack(primary, secondary, 0L, 0L);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        this.onGenericFillItemGroup(group, items, 0L);
    }

    public int getEnergyTier() {
        return 0;
    }

    public GTToolType getGTToolType() {
        return this.type;
    }

    public String getId() {
        return String.join((CharSequence)"_", this.tier.getPrimary().getId(), this.type.getId());
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext tesseractItemContext) {
        return null;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.genericIsCorrectToolForDrops(stack, state);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return super.canDisableShield(stack, shield, entity, attacker);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)super.getMaxDamage(stack) * this.getGTToolType().getDurabilityMultiplier());
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        return this.onGenericBlockDestroyed(stack, level, state, pos, entity);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type.getBlacklistedEnchantments().contains(enchantment)) {
            return false;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public InteractionResult m_6225_(UseOnContext contextIn) {
        InteractionResult result = this.onGenericItemUse(contextIn);
        if (result != InteractionResult.PASS) {
            return result;
        }
        return super.m_6225_(contextIn);
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        String[] builders;
        for (String builderString : builders = new String[]{"", "_throwing", "_blocking"}) {
            GTItemModelBuilder builder = (GTItemModelBuilder)prov.getBuilder(this.getId() + builderString);
            builder.parent(new ResourceLocation("spartanweaponry", "item/base/" + this.type.getId() + builderString));
            Texture[] textures = this.getTextures();
            for (int i = 0; i < textures.length; ++i) {
                builder.texture("layer" + i, (ResourceLocation)textures[i]);
            }
            builder.texture("coating", new ResourceLocation("spartanweaponry", "item/coating/" + this.type.getId()));
            builder.loader(new ResourceLocation("spartanweaponry", "oil_coated_item"));
            if (!builderString.isEmpty()) continue;
            builder.override().predicate(new ResourceLocation("spartanweaponry", "blocking"), 1.0f).model(new ResourceLocation(this.getDomain(), "item/" + this.getId() + "_blocking")).end();
            builder.override().predicate(new ResourceLocation("spartanweaponry", "throwing"), 1.0f).model(new ResourceLocation(this.getDomain(), "item/" + this.getId() + "_throwing")).end();
        }
    }

    public String getTextureDomain() {
        return "gtspartan";
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (this.replacement) {
            return -1;
        }
        return super.getItemColor(stack, block, i);
    }
}

