/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientPartialTagSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;

public class IngredientPartialTag
extends Ingredient {
    private final ItemStack stack;

    public IngredientPartialTag(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CompoundTag stack1Tag = this.stack.m_41783_();
        CompoundTag stack2Tag = input.m_41783_();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = TagToDataConverter.convertCompound(stack2Tag);
        MapData stack1Data = TagToDataConverter.convertCompound(stack1Tag);
        boolean contains = stack1Data == null ? true : stack2Data != null && stack2Data.contains(stack1Data);
        return this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && contains;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientPartialTagSerializer.INSTANCE;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)NBTIngredient.Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.m_41720_().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            json.addProperty("nbt", this.stack.m_41783_().toString());
        }
        return json;
    }
}

