/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.entity;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.entity.INameplateFunction;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.services.IClientHelper;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;

public class ActionSetNameplate
implements IUndoableAction {
    private final Predicate<Entity> predicate;
    private final INameplateFunction function;

    public ActionSetNameplate(Predicate<Entity> predicate, INameplateFunction function) {
        this.predicate = predicate;
        this.function = function;
    }

    @Override
    public void apply() {
        IClientHelper.NAMEPLATES.put(this.predicate, this.function);
    }

    @Override
    public void undo() {
        IClientHelper.NAMEPLATES.remove(this.predicate);
    }

    @Override
    public String describe() {
        return "Adding a custom nameplate for an entity!";
    }

    @Override
    public String describeUndo() {
        return "Undoing addition of a custom nameplate for an entity!";
    }

    @Override
    public boolean shouldApplyOn(IScriptLoadSource source) {
        return Services.DISTRIBUTION.isClient();
    }
}

