/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.handler;

import com.mojang.logging.LogUtils;
import crystalspider.harvestwithease.api.HarvestWithEaseAPI;
import crystalspider.harvestwithease.api.event.HarvestWithEaseEvent;
import crystalspider.harvestwithease.config.ModConfig;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="harvestwithease", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RightClickBlockHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handle(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        if (RightClickBlockHandler.canInteract(player, event)) {
            BlockPos blockPos = event.getPos();
            BlockState blockState = level.m_8055_(blockPos);
            InteractionHand hand = RightClickBlockHandler.getInteractionHand(player);
            if (hand == event.getHand() && RightClickBlockHandler.canHarvest(level, blockState, blockPos, player, hand, true)) {
                try {
                    IntegerProperty cropAge = HarvestWithEaseAPI.getAge(blockState);
                    if (HarvestWithEaseAPI.isMature(blockState, cropAge)) {
                        RightClickBlockHandler.cancel(event);
                        if (!level.m_5776_()) {
                            TieredItem tool;
                            RightClickBlockHandler.harvest((ServerLevel)level, cropAge, blockState, blockPos, event.getFace(), event.getHitVec(), (ServerPlayer)player, hand);
                            Item item = player.m_21120_(hand).m_41720_();
                            if (item instanceof TieredItem && RightClickBlockHandler.isHoe((tool = (TieredItem)item).m_7968_()) && HarvestWithEaseAPI.isTierForMultiHarvest(tool)) {
                                int fromCenterToEdge = ((HarvestWithEaseAPI.getTierLevel(tool.m_43314_()) - HarvestWithEaseAPI.getTierLevel(ModConfig.getMultiHarvestStartingTier())) * ModConfig.getAreaIncrementStep().step + ModConfig.getAreaStartingSize().size - 1) / 2;
                                BlockPos.m_121921_((AABB)new AABB(blockPos, blockPos).m_82377_((double)fromCenterToEdge, 0.0, (double)fromCenterToEdge)).filter(pos -> !pos.equals((Object)blockPos)).forEach(pos -> {
                                    IntegerProperty age;
                                    BlockState state = level.m_8055_(pos);
                                    if (RightClickBlockHandler.canHarvest(level, state, pos, player, hand, false) && HarvestWithEaseAPI.isMature(state, age = HarvestWithEaseAPI.getAge(state))) {
                                        RightClickBlockHandler.harvest((ServerLevel)level, age, state, pos, event.getFace(), null, (ServerPlayer)player, hand);
                                    }
                                });
                            }
                        }
                    }
                }
                catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                    LOGGER.debug("Exception generated by block at [" + blockPos.m_123344_() + "]");
                    LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod harvestwithease");
                    LOGGER.debug("Most probably the cause of this issue was that a non-crop ID was added in the configuration and its age property could not be retrieved, see stack trace for more details", (Throwable)e);
                }
            }
        }
    }

    private static void harvest(ServerLevel level, IntegerProperty age, BlockState blockState, BlockPos blockPos, Direction face, BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        MinecraftForge.EVENT_BUS.post((Event)new HarvestWithEaseEvent.BeforeHarvest(level, blockState, blockPos, face, hitResult, player, hand));
        RightClickBlockHandler.grantExp(player);
        RightClickBlockHandler.damageHoe(player, hand);
        BlockPos basePos = RightClickBlockHandler.getBasePos(level, blockState.m_60734_(), blockPos);
        RightClickBlockHandler.updateCrop(level, age, blockState.m_60734_(), basePos, player, RightClickBlockHandler.dropResources(level, level.m_8055_(basePos), basePos, face, hitResult, player, hand));
        RightClickBlockHandler.playSound(level, player, blockState, blockPos);
        MinecraftForge.EVENT_BUS.post((Event)new HarvestWithEaseEvent.AfterHarvest(level, blockState, blockPos, face, hitResult, player, hand));
    }

    private static void updateCrop(ServerLevel level, IntegerProperty age, Block block, BlockPos basePos, ServerPlayer player, boolean customDrops) {
        level.m_46597_(basePos, (BlockState)level.m_8055_(basePos).m_61124_((Property)age, (Comparable)Integer.valueOf(0)));
        if (level.m_8055_(basePos).m_204336_(BlockTags.f_13073_) && level.m_8055_(basePos.m_7494_()).m_60713_(block) && !RightClickBlockHandler.isTallButSeparate(block)) {
            level.m_46953_(basePos.m_7494_(), !customDrops, (Entity)player);
        }
    }

    private static BlockPos getBasePos(ServerLevel world, Block block, BlockPos blockPos) {
        BlockPos basePos = blockPos;
        while (world.m_8055_(blockPos).m_204336_(BlockTags.f_13073_) && !RightClickBlockHandler.isTallButSeparate(block) && world.m_8055_(basePos.m_7495_()).m_60713_(block)) {
            basePos = basePos.m_7495_();
        }
        return basePos;
    }

    private static boolean canInteract(Player player, PlayerInteractEvent.RightClickBlock event) {
        return !player.m_5833_() && event.getUseBlock() != Event.Result.DENY && event.getUseItem() != Event.Result.DENY && event.getResult() != Event.Result.DENY;
    }

    private static void grantExp(ServerPlayer player) {
        if (ModConfig.getGrantedExp() > 0) {
            player.m_6756_(ModConfig.getGrantedExp().intValue());
        }
    }

    private static void damageHoe(ServerPlayer player, InteractionHand hand) {
        if (ModConfig.getRequireHoe().booleanValue() && ModConfig.getDamageOnHarvest() > 0 && !player.m_7500_()) {
            player.m_21120_(hand).m_41622_(ModConfig.getDamageOnHarvest().intValue(), (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
        }
    }

    private static boolean dropResources(ServerLevel level, BlockState blockState, BlockPos blockPos, Direction face, BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        HarvestWithEaseEvent.HarvestDrops event = new HarvestWithEaseEvent.HarvestDrops(level, blockState, blockPos, face, hitResult, player, hand);
        MinecraftForge.EVENT_BUS.post((Event)event);
        for (ItemStack stack : event.drops) {
            if (blockState.m_60767_().m_76334_()) {
                Block.m_152435_((Level)level, (BlockPos)blockPos, (Direction)face, (ItemStack)stack);
                continue;
            }
            Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)stack);
        }
        return event.haveDropsChanged();
    }

    private static void playSound(ServerLevel level, ServerPlayer player, BlockState blockState, BlockPos blockPos) {
        if (ModConfig.getPlaySound().booleanValue()) {
            SoundType soundType = blockState.m_60734_().getSoundType(blockState, (LevelReader)level, blockPos, (Entity)player);
            level.m_5594_(null, blockPos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
        }
    }

    private static void cancel(PlayerInteractEvent.RightClickBlock event) {
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @Nullable
    private static InteractionHand getInteractionHand(Player player) {
        if (!player.m_6047_()) {
            if (RightClickBlockHandler.isHoe(player.m_21205_())) {
                return InteractionHand.MAIN_HAND;
            }
            if (RightClickBlockHandler.isHoe(player.m_21206_())) {
                return InteractionHand.OFF_HAND;
            }
            if (!ModConfig.getRequireHoe().booleanValue()) {
                return InteractionHand.MAIN_HAND;
            }
        }
        return null;
    }

    private static boolean isHoe(ItemStack handItem) {
        return ToolActions.DEFAULT_HOE_ACTIONS.stream().allMatch(toolAction -> handItem.canPerformAction(toolAction));
    }

    private static boolean canHarvest(Level level, BlockState blockState, BlockPos blockPos, Player player, InteractionHand hand, boolean first) {
        if (HarvestWithEaseAPI.isCrop(blockState.m_60734_()) && player.m_36298_(blockState)) {
            HarvestWithEaseEvent.RightClickHarvestCheck event = new HarvestWithEaseEvent.RightClickHarvestCheck(level, blockState, blockPos, player, hand, true, first);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.canHarvest();
        }
        return false;
    }

    private static boolean isTallButSeparate(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        if (location != null) {
            return location.toString().equals("farmersdelight:tomatoes");
        }
        return false;
    }
}

