/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.net.SyncMessageHistoryMessage;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TeamManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("ftbteams");
    private static final LevelResource OLD_ID_FILE = new LevelResource("data/ftbchunks/info.json");
    public static TeamManager INSTANCE;
    public final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    final Map<UUID, PlayerTeam> knownPlayers;
    final Map<UUID, Team> teamMap;
    Map<String, Team> nameMap;
    private CompoundTag extraData;

    public TeamManager(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, Team>();
        this.extraData = new CompoundTag();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Map<UUID, PlayerTeam> getKnownPlayers() {
        return this.knownPlayers;
    }

    public Map<UUID, Team> getTeamMap() {
        return this.teamMap;
    }

    public Collection<Team> getTeams() {
        return this.getTeamMap().values();
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (Team team : this.getTeams()) {
                this.nameMap.put(team.getStringID(), team);
            }
        }
        return this.nameMap;
    }

    @Nullable
    public Team getTeamByID(UUID uuid) {
        return uuid == Util.f_137441_ ? null : this.teamMap.get(uuid);
    }

    public PlayerTeam getInternalPlayerTeam(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Nullable
    public Team getPlayerTeam(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? null : t.actualTeam;
    }

    public Team getPlayerTeam(ServerPlayer player) {
        return Objects.requireNonNull(this.getPlayerTeam(player.m_142081_()));
    }

    public boolean arePlayersInSameTeam(ServerPlayer player1, ServerPlayer player2) {
        return this.getPlayerTeam(player1).equals(this.getPlayerTeam(player2));
    }

    public UUID getPlayerTeamID(UUID id) {
        Team t = this.getPlayerTeam(id);
        return t == null ? id : t.getId();
    }

    public void load() {
        this.id = null;
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.m_128441_("id")) {
                this.id = UUID.fromString(dataFileTag.m_128461_("id"));
            }
            this.extraData = dataFileTag.m_128469_("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
        } else {
            Path oldFile = this.server.m_129843_(OLD_ID_FILE);
            if (Files.exists(oldFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(oldFile);){
                    this.id = UUID.fromString(((JsonObject)new GsonBuilder().create().fromJson((Reader)reader, JsonObject.class)).get("id").getAsString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.save();
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path dir = directory.resolve(type.m_7912_());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try {
                Stream<Path> s = Files.list(dir);
                try {
                    s.filter(path -> path.getFileName().toString().endsWith(".snbt")).forEach(file -> {
                        SNBTCompoundTag nbt = SNBT.read((Path)file);
                        if (nbt != null) {
                            Team team = type.factory.apply(this);
                            team.id = UUID.fromString(nbt.m_128461_("id"));
                            this.teamMap.put(team.id, team);
                            team.deserializeNBT((CompoundTag)nbt);
                        }
                    });
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.actualTeam = team;
            }
        }
        FTBTeams.LOGGER.info("loaded team data: {} known players, {} teams total", (Object)this.knownPlayers.size(), (Object)this.teamMap.size());
    }

    public void save() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path path = directory.resolve(type.m_7912_());
            if (!Files.notExists(path, new LinkOption[0])) continue;
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.getTeams()) {
            if (!team.shouldSave) continue;
            SNBT.write((Path)directory.resolve(team.getType().m_7912_() + "/" + team.getId() + ".snbt"), (CompoundTag)team.serializeNBT());
            team.shouldSave = false;
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.m_128359_("id", this.getId().toString());
        nbt.m_128365_("extra", (Tag)this.extraData);
        return nbt;
    }

    private ServerTeam createServerTeam(ServerPlayer player, String name) {
        ServerTeam team = new ServerTeam(this);
        team.id = UUID.randomUUID();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? team.id.toString().substring(0, 8) : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PartyTeam createPartyTeam(ServerPlayer player, String name) {
        PartyTeam team = new PartyTeam(this);
        team.id = UUID.randomUUID();
        team.owner = player.m_142081_();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? player.m_36316_().getName() + "'s Party" : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PlayerTeam createPlayerTeam(@Nullable ServerPlayer player, UUID playerId, String playerName) {
        PlayerTeam team = new PlayerTeam(this);
        team.id = playerId;
        team.playerName = playerName;
        team.setProperty(Team.DISPLAY_NAME, team.playerName);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.ranks.put(playerId, TeamRank.OWNER);
        team.onCreated(player);
        return team;
    }

    public void playerLoggedIn(@Nullable ServerPlayer player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean syncToAll = false;
        FTBTeams.LOGGER.debug("player {} logged in, player team = {}", (Object)id, (Object)team);
        if (team == null) {
            FTBTeams.LOGGER.debug("creating new player team for player {}", (Object)id);
            team = this.createPlayerTeam(player, id, name);
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            syncToAll = true;
            team.changedTeam(null, id, player, false);
            FTBTeams.LOGGER.debug("  - team created");
        } else if (!team.playerName.equals(name)) {
            FTBTeams.LOGGER.debug("updating player name: {} -> {}", (Object)team.playerName, (Object)name);
            team.playerName = name;
            team.save();
            this.save();
            syncToAll = true;
        }
        FTBTeams.LOGGER.debug("syncing player team data, all = {}", (Object)syncToAll);
        if (player != null) {
            this.syncAllToPlayer(player, team.actualTeam);
        }
        if (syncToAll) {
            this.syncTeamsToAll(team.actualTeam);
        }
        FTBTeams.LOGGER.debug("updating team presence");
        team.online = true;
        team.updatePresence();
        if (player != null) {
            FTBTeams.LOGGER.debug("sending team login event for {}...", (Object)player.m_142081_());
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.actualTeam, player));
            FTBTeams.LOGGER.debug("team login event for {} sent", (Object)player.m_142081_());
        }
    }

    public void playerLoggedOut(ServerPlayer player) {
        PlayerTeam team = this.knownPlayers.get(player.m_142081_());
        if (team != null) {
            team.online = false;
            team.updatePresence();
        }
    }

    private ClientTeamManager createClientTeamManager(Collection<Team> teams) {
        ClientTeamManager clientManager = new ClientTeamManager(this.getId());
        for (Team team : teams) {
            ClientTeam t = this.teamMap.containsKey(team.getId()) ? new ClientTeam(clientManager, team) : ClientTeam.invalidTeam(clientManager, team);
            clientManager.teamMap.put(t.getId(), t);
            if (!(team instanceof PlayerTeam)) continue;
            clientManager.knownPlayers.put(team.getId(), new KnownClientPlayer((PlayerTeam)team));
        }
        return clientManager;
    }

    public void syncAllToPlayer(ServerPlayer player, Team selfTeam) {
        new SyncTeamsMessage(this.createClientTeamManager(this.getTeams()), selfTeam, true).sendTo(player);
        new SyncMessageHistoryMessage(selfTeam).sendTo(player);
        this.server.m_6846_().m_11289_(player);
    }

    public void syncTeamsToAll(Team ... teams) {
        if (teams.length == 0) {
            return;
        }
        ClientTeamManager manager = this.createClientTeamManager(Arrays.stream(teams).toList());
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            Team selfTeam = this.getPlayerTeam(player);
            new SyncTeamsMessage(manager, selfTeam, false).sendTo(player);
            if (teams.length <= 1) continue;
            new SyncMessageHistoryMessage(selfTeam).sendTo(player);
        }
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayer player, String name) throws CommandSyntaxException {
        return this.createParty(player, name, null, null);
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayer player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        if (FTBTeamsAPI.partyCreationOverride != null) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        UUID id = player.m_142081_();
        Team oldTeam = this.getPlayerTeam(player);
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        PartyTeam team = this.createPartyTeam(player, name);
        if (description != null) {
            team.setProperty(TeamBase.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamBase.COLOR, color);
        }
        playerTeam.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        team.sendMessage(Util.f_137441_, (Component)new TranslatableComponent("ftbteams.message.joined", new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.YELLOW));
        team.save();
        playerTeam.ranks.remove(id);
        playerTeam.save();
        playerTeam.updatePresence();
        this.syncTeamsToAll(team, playerTeam);
        team.changedTeam(playerTeam, id, player, false);
        return Pair.of((Object)1, (Object)team);
    }

    public Pair<Integer, ServerTeam> createServer(CommandSourceStack source, String name) throws CommandSyntaxException {
        if (name.length() < 3) {
            throw TeamArgument.NAME_TOO_SHORT.create();
        }
        ServerTeam team = this.createServerTeam(source.m_81375_(), name);
        source.m_81354_((Component)new TranslatableComponent("ftbteams.message.created_server_team", new Object[]{team.getName()}), true);
        this.syncTeamsToAll(team);
        return Pair.of((Object)1, (Object)team);
    }

    public Component getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.f_137441_)) {
            return new TextComponent("System").m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return new TextComponent(team == null ? "Unknown" : team.playerName).m_130940_(ChatFormatting.YELLOW);
    }

    public CompoundTag getExtraData() {
        return this.extraData;
    }
}

