/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsCrossbow;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsThrowingWeapon;
    public ForgeConfigSpec.BooleanValue forceCompatibilityCrosshairs;
    public ForgeConfigSpec.EnumValue<AlignmentHelper.Alignment> quiverHudAlignment;
    public ForgeConfigSpec.EnumValue<AlignmentHelper.Alignment> oilUsesHudAlignment;
    public ForgeConfigSpec.IntValue quiverHudOffsetX;
    public ForgeConfigSpec.IntValue quiverHudOffsetY;
    public ForgeConfigSpec.IntValue oilUsesHudOffsetX;
    public ForgeConfigSpec.IntValue oilUsesHudOffsetY;
    public ForgeConfigSpec.BooleanValue forceDisableUncraftableTooltips;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.forceDisableUncraftableTooltips = builder.comment("Requires game restart! Set to true to remove the uncraftable tooltips for any uncraftable weapon (highlighted in red). Useful for modpack makers who wish to change recipes.").translation("config.spartanweaponry.client.force_disable_uncraftable_tooltips").worldRestart().define("force_disable_uncraftable_tooltips", false);
        builder.pop();
        builder.push("hud");
        this.disableNewCrosshairsCrossbow = builder.comment("Set to true to disable a new Crosshair for the Crossbow which visually shows inaccuracy, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_crossbow").define("disable_new_crosshairs_crossbow", false);
        this.disableNewCrosshairsThrowingWeapon = builder.comment("Set to true to disable a new Crosshair for Throwing Weapons which show the charge for them, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_throwing_weapons").define("disable_new_crosshairs_throwing_weapons", false);
        this.forceCompatibilityCrosshairs = builder.comment("Set to force compatibility crosshairs for Crosshairs and Throwing Weapons. This won't work if the new crosshairs are disabled").translation("config.spartanweaponry.client.force_compatibility_crosshairs").define("force_compatibility_crosshairs", false);
        builder.push("quiver");
        this.quiverHudAlignment = builder.comment("Sets where the Quiver HUD Element should be aligned").translation("config.spartanweaponry.client.quiver_hud_alignment").defineEnum("quiver_hud_alignment", (Enum)AlignmentHelper.Alignment.BOTTOM_CENTER);
        this.quiverHudOffsetX = builder.comment("Sets where on the X-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_x").defineInRange("quiver_hud_offset_x", -138, -400, 400);
        this.quiverHudOffsetY = builder.comment("Sets where on the Y-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_y").defineInRange("quiver_hud_offset_y", 65, -400, 400);
        builder.pop();
        builder.push("oil_uses");
        this.oilUsesHudAlignment = builder.comment("Sets where the Oil Uses HUD Element should be aligned").translation("config.spartanweaponry.client.oil_uses_hud_alignment").defineEnum("oil_uses_alignment", (Enum)AlignmentHelper.Alignment.CENTER);
        this.oilUsesHudOffsetX = builder.comment("Sets where on the X-axis the Oil Uses HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.oil_uses_hud_offset_x").defineInRange("oil_uses_hud_offset_x", 0, -400, 400);
        this.oilUsesHudOffsetY = builder.comment("Sets where on the Y-axis the Oil Uses HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.oil_uses_offset_y").defineInRange("oil_uses_hud_offset_y", 0, -400, 400);
        builder.pop();
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        INSTANCE = (ClientConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

