/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.damagesource.IArmorPiercingDamageSource;
import com.oblivioussp.spartanweaponry.mixin.EntityMixin;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
extends EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, cancellable=true)
    protected void getDamageAfterArmorAbsorb(DamageSource source, float damage, CallbackInfoReturnable<Float> callback) {
        if (source instanceof IArmorPiercingDamageSource && !source.m_19376_()) {
            this.m_6472_(source, damage);
            float percentage = ((IArmorPiercingDamageSource)source).getArmorPiercingPercentage();
            Log.debug("Found armor piercing damage source! Reducing armor value of target by " + percentage * 100.0f + "%");
            float toughness = (float)this.m_21133_(Attributes.f_22285_);
            float armorPiercingDamage = damage * percentage;
            float regularDamage = damage - armorPiercingDamage;
            float reducedDamage = CombatRules.m_19272_((float)regularDamage, (float)this.m_21230_(), (float)toughness);
            float resultDamage = armorPiercingDamage + reducedDamage;
            Log.debug("Full damage: " + damage + " Armor value: " + (float)this.m_21230_() + " Damage ignoring armor (" + percentage * 100.0f + "% damage): " + armorPiercingDamage + " Damage not ignoring armor: " + regularDamage + " Reduced Damage: " + reducedDamage + " Result Damage: " + resultDamage);
            callback.setReturnValue((Object)Float.valueOf(resultDamage));
        }
    }

    @Shadow
    protected void m_6472_(DamageSource source, float damage) {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.hurtArmor(float)\" method!");
    }

    @Shadow
    public int m_21230_() {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.getArmorValue()\" method!");
    }

    @Shadow
    public double m_21133_(Attribute attribute) {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.getAttributeValue(Attribute)\" method!");
    }

    @Shadow
    public ItemStack m_21120_(InteractionHand hand) {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.getItemInHand(InteractionHand)\" method!");
    }
}

