/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.mixin.ProjectileMixin;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends ProjectileMixin {
    @Shadow
    protected boolean f_36703_;
    @Shadow
    public int f_36706_;
    @Shadow
    public AbstractArrow.Pickup f_36705_;

    @Inject(at={@At(value="HEAD")}, method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, cancellable=true)
    private void playerTouch(Player entityIn, CallbackInfo callback) {
        if (!this.f_19853_.f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
            Log.debug("Player collision with arrow entity intercepted!");
            if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                List<ItemStack> quivers = QuiverHelper.findValidQuivers(entityIn);
                ItemStack arrowStack = this.m_7941_();
                ItemStack mainHand = entityIn.m_21205_();
                ItemStack offHand = entityIn.m_21206_();
                if (offHand.m_41720_() == arrowStack.m_41720_() && offHand.m_41613_() < offHand.m_41741_() || mainHand.m_41720_() == arrowStack.m_41720_() && mainHand.m_41613_() < mainHand.m_41741_()) {
                    return;
                }
                if (!quivers.isEmpty()) {
                    for (ItemStack quiver : quivers) {
                        if (!arrowStack.m_41619_() && !quiver.m_41619_() && ((QuiverBaseItem)quiver.m_41720_()).isAmmoValid(arrowStack, quiver) && quiver.m_41784_().m_128471_("AmmoCollect")) {
                            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().orElseThrow();
                            for (int i = 0; i < quiverHandler.getSlots(); ++i) {
                                arrowStack = quiverHandler.insertItem(i, arrowStack, false);
                            }
                        }
                        if (!arrowStack.m_41619_()) continue;
                        Log.debug("Picked up arrow on the ground and placed it in the quiver!");
                        Entity thisEntity = this.f_19853_.m_6815_(this.m_142049_());
                        entityIn.m_7938_(thisEntity, 1);
                        this.m_146870_();
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.7f + 0.0f);
                        callback.cancel();
                        break;
                    }
                }
            }
        }
    }

    @Shadow
    public boolean m_36797_() {
        throw new IllegalStateException("Mixin failed to shadow the \"AbstractArrow.isNoPhysics()\" method!");
    }

    @Shadow
    public ItemStack m_7941_() {
        throw new IllegalStateException("Mixin failed to shadow the \"AbstractArrow.getPickupItem()\" method!");
    }
}

