/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TippedProjectileBaseRecipe
extends CustomRecipe {
    protected final Item projectileIn;
    protected final Item projectileOut;

    public TippedProjectileBaseRecipe(ResourceLocation idIn, Item arrowIn, Item arrowOut) {
        super(idIn);
        this.projectileIn = arrowIn;
        this.projectileOut = arrowOut;
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (container.m_39347_() == 3 && container.m_39346_() == 3) {
            for (int i = 0; i < container.m_39347_(); ++i) {
                for (int j = 0; j < container.m_39346_(); ++j) {
                    ItemStack stack = container.m_8020_(j * container.m_39347_() + i);
                    if (stack.m_41619_()) {
                        return false;
                    }
                    Item item = stack.m_41720_();
                    if (!(i == 1 && j == 1 ? item != Items.f_42739_ : item != this.projectileIn)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Potion potion;
        ItemStack potionStack = inv.m_8020_(1 + inv.m_39347_());
        if (potionStack.m_41720_() == Items.f_42739_ && !(potion = PotionUtils.m_43579_((ItemStack)potionStack)).m_43488_().isEmpty()) {
            ItemStack arrowResult = new ItemStack((ItemLike)this.projectileOut, 8);
            PotionUtils.m_43549_((ItemStack)arrowResult, (Potion)potion);
            return arrowResult;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.TIPPED_PROJECTILE_BASE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TippedProjectileBaseRecipe> {
        public TippedProjectileBaseRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String projInName = GsonHelper.m_13906_((JsonObject)json, (String)"projectile");
            String projOutName = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            Item projIn = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(projInName));
            Item projOut = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(projOutName));
            if (projIn == null) {
                throw new JsonSyntaxException("Input projectile " + projInName + " doesn't exist!");
            }
            if (projOut == null) {
                throw new JsonSyntaxException("Result projectile " + projOutName + " doesn't exist!");
            }
            return new TippedProjectileBaseRecipe(recipeId, projIn, projOut);
        }

        public TippedProjectileBaseRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ResourceLocation projInLoc = buffer.m_130281_();
            ResourceLocation projOutLoc = buffer.m_130281_();
            Item projIn = (Item)ForgeRegistries.ITEMS.getValue(projInLoc);
            Item projOut = (Item)ForgeRegistries.ITEMS.getValue(projOutLoc);
            return new TippedProjectileBaseRecipe(recipeId, projIn, projOut);
        }

        public void toNetwork(FriendlyByteBuf buffer, TippedProjectileBaseRecipe recipe) {
            buffer.m_130085_(recipe.projectileIn.getRegistryName());
            buffer.m_130085_(recipe.projectileOut.getRegistryName());
        }
    }
}

