/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class OilBrewingRecipe
implements IBrewingRecipe {
    private static final List<PotionBrewing.Mix<OilEffect>> VALID_MIXES = new ArrayList<PotionBrewing.Mix<OilEffect>>();

    public boolean isInput(ItemStack input) {
        return input.m_150930_((Item)ModItems.WEAPON_OIL.get());
    }

    public boolean isIngredient(ItemStack ingredient) {
        for (PotionBrewing.Mix<OilEffect> mix : VALID_MIXES) {
            if (!mix.f_43533_.test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            OilEffect effect = OilHelper.getOilFromStack(input);
            for (PotionBrewing.Mix<OilEffect> mix : VALID_MIXES) {
                if (mix.f_43532_.get() != effect || !mix.f_43533_.test(ingredient)) continue;
                return OilHelper.makeOilStack((OilEffect)((Object)mix.f_43534_.get()));
            }
        }
        return ItemStack.f_41583_;
    }

    public static int getBrewingSteps(OilEffect effect) {
        OilEffect currentEffect = effect;
        int steps = 0;
        do {
            int currentSteps = steps;
            for (PotionBrewing.Mix<OilEffect> mix : VALID_MIXES) {
                if (currentEffect != mix.f_43534_.get()) continue;
                ++steps;
                currentEffect = (OilEffect)((Object)mix.f_43532_.get());
                break;
            }
            if (currentSteps != steps) continue;
            return Integer.MAX_VALUE;
        } while (currentEffect != OilEffects.NONE.get());
        return steps;
    }

    public static void clearMixes() {
        VALID_MIXES.clear();
    }

    public static void addBaseOilMix(Ingredient ingredientIn, OilEffect oilEffectOut) {
        VALID_MIXES.add((PotionBrewing.Mix<OilEffect>)new PotionBrewing.Mix((ForgeRegistryEntry)((OilEffect)((Object)OilEffects.NONE.get())), ingredientIn, (ForgeRegistryEntry)oilEffectOut));
    }

    public static void addOilMix(OilEffect oilEffectIn, Ingredient ingredientIn, OilEffect oilEffectOut) {
        VALID_MIXES.add((PotionBrewing.Mix<OilEffect>)new PotionBrewing.Mix((ForgeRegistryEntry)oilEffectIn, ingredientIn, (ForgeRegistryEntry)oilEffectOut));
    }

    public static List<PotionBrewing.Mix<OilEffect>> getValidMixes() {
        return ImmutableList.copyOf(VALID_MIXES);
    }
}

